/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.exception.ErrorHandler;
import org.mule.runtime.core.exception.ErrorHandlerFactory;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.OnErrorPropagateHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import reactor.core.publisher.Mono;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@SmallTest
@Features(value={"Error Handling"})
@Stories(value={"Error Handler"})
@RunWith(value=MockitoJUnitRunner.class)
public class ErrorHandlerTestCase
extends AbstractMuleTestCase {
    @Mock
    private MessagingExceptionHandlerAcceptor mockTestExceptionStrategy1;
    @Mock
    private MessagingExceptionHandlerAcceptor mockTestExceptionStrategy2;
    private DefaultMessagingExceptionHandlerAcceptor defaultMessagingExceptionHandler = (DefaultMessagingExceptionHandlerAcceptor)Mockito.spy((Object)new DefaultMessagingExceptionHandlerAcceptor());
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Event mockMuleEvent;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext mockMuleContext;
    @Mock
    private ErrorType mockErrorType;
    private MessagingException mockException;

    @Before
    public void before() throws MuleException {
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)Message.of((Object)""));
        Mockito.when((Object)this.mockMuleEvent.getMuleContext()).thenReturn((Object)this.mockMuleContext);
        Error mockError = (Error)Mockito.mock(Error.class);
        Mockito.when((Object)mockError.getErrorType()).thenReturn((Object)this.mockErrorType);
        Mockito.when((Object)this.mockMuleEvent.getError()).thenReturn(Optional.of(mockError));
        this.mockException = new MessagingException(this.mockMuleEvent, (Throwable)new Exception());
        Event handledEvent = this.testEvent();
        Mockito.when((Object)this.mockTestExceptionStrategy1.accept((Event)org.mockito.Matchers.any(Event.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockTestExceptionStrategy1.apply((MessagingException)((Object)org.mockito.Matchers.any(MessagingException.class)))).thenReturn((Object)Mono.just((Object)handledEvent));
        Mockito.when((Object)this.mockTestExceptionStrategy2.accept((Event)org.mockito.Matchers.any(Event.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockTestExceptionStrategy2.apply((MessagingException)((Object)org.mockito.Matchers.any(MessagingException.class)))).thenReturn((Object)Mono.just((Object)handledEvent));
    }

    @Test
    public void nonMatchThenCallDefault() throws Exception {
        ErrorHandler errorHandler = new ErrorHandler();
        Mockito.when((Object)this.mockMuleContext.getDefaultErrorHandler()).thenReturn((Object)this.defaultMessagingExceptionHandler);
        errorHandler.setExceptionListeners(new ArrayList<MessagingExceptionHandlerAcceptor>(Arrays.asList(this.mockTestExceptionStrategy1, this.mockTestExceptionStrategy2)));
        errorHandler.setMuleContext(this.mockMuleContext);
        errorHandler.initialise();
        Mockito.when((Object)this.mockTestExceptionStrategy1.accept((Event)org.mockito.Matchers.any(Event.class))).thenReturn((Object)false);
        Mockito.when((Object)this.mockTestExceptionStrategy2.accept((Event)org.mockito.Matchers.any(Event.class))).thenReturn((Object)false);
        errorHandler.handleException(this.mockException, this.mockMuleEvent);
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockTestExceptionStrategy1, (VerificationMode)VerificationModeFactory.times((int)0))).apply((MessagingException)((Object)org.mockito.Matchers.any(MessagingException.class)));
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockTestExceptionStrategy2, (VerificationMode)VerificationModeFactory.times((int)0))).apply((MessagingException)((Object)org.mockito.Matchers.any(MessagingException.class)));
        ((DefaultMessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.defaultMessagingExceptionHandler, (VerificationMode)VerificationModeFactory.times((int)1))).handleException((MessagingException)((Object)org.mockito.Matchers.eq((Object)((Object)this.mockException))), (Event)org.mockito.Matchers.any(Event.class));
    }

    @Test
    public void secondMatches() throws Exception {
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setExceptionListeners(new ArrayList<MessagingExceptionHandlerAcceptor>(Arrays.asList(this.mockTestExceptionStrategy1, this.mockTestExceptionStrategy2)));
        Mockito.when((Object)this.mockMuleContext.getDefaultErrorHandler()).thenReturn((Object)this.defaultMessagingExceptionHandler);
        errorHandler.setMuleContext(this.mockMuleContext);
        errorHandler.initialise();
        Mockito.when((Object)this.mockTestExceptionStrategy1.accept((Event)org.mockito.Matchers.any(Event.class))).thenReturn((Object)false);
        errorHandler.handleException(this.mockException, this.mockMuleEvent);
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockTestExceptionStrategy1, (VerificationMode)VerificationModeFactory.times((int)0))).apply((MessagingException)((Object)org.mockito.Matchers.any(MessagingException.class)));
        ((DefaultMessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.defaultMessagingExceptionHandler, (VerificationMode)VerificationModeFactory.times((int)0))).apply((MessagingException)((Object)org.mockito.Matchers.any(MessagingException.class)));
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockTestExceptionStrategy2, (VerificationMode)VerificationModeFactory.times((int)1))).handleException((MessagingException)((Object)org.mockito.Matchers.eq((Object)((Object)this.mockException))), (Event)org.mockito.Matchers.any(Event.class));
    }

    @Test(expected=MuleRuntimeException.class)
    public void firstAcceptsAllMatches() throws Exception {
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setExceptionListeners(new ArrayList<MessagingExceptionHandlerAcceptor>(Arrays.asList(this.mockTestExceptionStrategy1, this.mockTestExceptionStrategy2)));
        errorHandler.setMuleContext(this.mockMuleContext);
        Mockito.when((Object)this.mockMuleContext.getDefaultErrorHandler()).thenReturn((Object)this.defaultMessagingExceptionHandler);
        Mockito.when((Object)this.mockTestExceptionStrategy1.acceptsAll()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTestExceptionStrategy2.acceptsAll()).thenReturn((Object)false);
        errorHandler.initialise();
    }

    @Test
    public void criticalIsNotHandled() throws Exception {
        Mockito.when((Object)this.mockErrorType.getParentErrorType()).thenReturn((Object)ErrorTypeRepository.CRITICAL_ERROR_TYPE);
        ErrorHandler errorHandler = new ErrorHandler();
        Mockito.when((Object)this.mockMuleContext.getDefaultErrorHandler()).thenReturn((Object)this.defaultMessagingExceptionHandler);
        errorHandler.setExceptionListeners(new ArrayList<MessagingExceptionHandlerAcceptor>(Arrays.asList(this.mockTestExceptionStrategy1)));
        errorHandler.setMuleContext(this.mockMuleContext);
        errorHandler.initialise();
        errorHandler.handleException(this.mockException, this.mockMuleEvent);
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockTestExceptionStrategy1, (VerificationMode)VerificationModeFactory.times((int)0))).apply((MessagingException)((Object)org.mockito.Matchers.any(MessagingException.class)));
        ((DefaultMessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.defaultMessagingExceptionHandler, (VerificationMode)VerificationModeFactory.times((int)0))).apply((MessagingException)((Object)org.mockito.Matchers.any(MessagingException.class)));
    }

    @Test
    public void defaultErrorHandler() throws InitialisationException {
        ErrorHandler defaultHandler = new ErrorHandlerFactory().createDefault();
        Assert.assertThat((Object)defaultHandler.getExceptionListeners(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)defaultHandler.getExceptionListeners(), (Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.instanceOf(OnErrorPropagateHandler.class)));
    }

    class DefaultMessagingExceptionHandlerAcceptor
    implements MessagingExceptionHandlerAcceptor {
        DefaultMessagingExceptionHandlerAcceptor() {
        }

        public boolean accept(Event event) {
            return true;
        }

        public boolean acceptsAll() {
            return true;
        }

        public Event handleException(MessagingException exception, Event event) {
            exception.setHandled(true);
            return event;
        }
    }
}

