/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.exception.Errors;
import org.mule.tck.junit4.AbstractMuleTestCase;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@Features(value={"Error Handling"})
@Stories(value={"Error Types"})
public class ErrorTypeRepositoryTestCase
extends AbstractMuleTestCase {
    private ErrorTypeRepository errorTypeRepository = new ErrorTypeRepository();
    private ComponentIdentifier MY_ERROR = ComponentIdentifier.builder().withNamespace("ns").withName("name").build();

    @Before
    public void setUp() {
        this.errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.CONNECTIVITY, this.errorTypeRepository.getAnyErrorType());
        this.errorTypeRepository.addInternalErrorType(this.MY_ERROR, this.errorTypeRepository.getCriticalErrorType());
    }

    @Test
    public void lookupsAvailableErrorType() {
        Optional errorType = this.errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.CONNECTIVITY);
        Assert.assertThat((Object)errorType.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ErrorType)errorType.get()).getIdentifier(), (Matcher)Matchers.is((Object)Errors.ComponentIdentifiers.CONNECTIVITY.getName()));
        Assert.assertThat((Object)((ErrorType)errorType.get()).getParentErrorType().getIdentifier(), (Matcher)Matchers.is((Object)"ANY"));
    }

    @Test
    public void doesNotLookupUnavailableErrorType() {
        Assert.assertThat((Object)this.errorTypeRepository.lookupErrorType(this.MY_ERROR).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void getsAvailableErrorTypes() {
        Optional myErrorType = this.errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.CONNECTIVITY);
        Assert.assertThat((Object)myErrorType.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ErrorType)myErrorType.get()).getIdentifier(), (Matcher)Matchers.is((Object)"CONNECTIVITY"));
        Assert.assertThat((Object)((ErrorType)myErrorType.get()).getParentErrorType().getIdentifier(), (Matcher)Matchers.is((Object)"ANY"));
    }

    @Test
    public void getsUnavailableErrorTypes() {
        Optional myErrorType = this.errorTypeRepository.getErrorType(this.MY_ERROR);
        Assert.assertThat((Object)myErrorType.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ErrorType)myErrorType.get()).getIdentifier(), (Matcher)Matchers.is((Object)"name"));
        Assert.assertThat((Object)((ErrorType)myErrorType.get()).getParentErrorType().getIdentifier(), (Matcher)Matchers.is((Object)"CRITICAL"));
    }
}

