/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.exception.ExceptionMapper;
import org.mule.tck.junit4.AbstractMuleTestCase;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@Features(value={"Error Handling"})
@Stories(value={"Exception Mappings"})
public class ExceptionMapperTestCase
extends AbstractMuleTestCase {
    private ErrorType runtimeExceptionErrorType = (ErrorType)Mockito.mock(ErrorType.class);
    private ErrorType illegalArgumentExceptionErrorType = (ErrorType)Mockito.mock(ErrorType.class);
    private ErrorType numberFormatExceptionErrorType = (ErrorType)Mockito.mock(ErrorType.class);
    private ErrorType classCastExceptionErrorType = (ErrorType)Mockito.mock(ErrorType.class);
    private ErrorType arrayStoreExceptionErrorType = (ErrorType)Mockito.mock(ErrorType.class);
    private ErrorType arrayStoreChildExceptionErrorType = (ErrorType)Mockito.mock(ErrorType.class);

    @Test
    public void sameHierarchyMapping() {
        ExceptionMapper exceptionMapper = ExceptionMapper.builder().addExceptionMapping(RuntimeException.class, this.runtimeExceptionErrorType).addExceptionMapping(NumberFormatException.class, this.numberFormatExceptionErrorType).addExceptionMapping(IllegalArgumentException.class, this.illegalArgumentExceptionErrorType).build();
        Assert.assertThat(exceptionMapper.resolveErrorType(IllegalArgumentException.class).get(), (Matcher)Is.is((Object)this.illegalArgumentExceptionErrorType));
        Assert.assertThat(exceptionMapper.resolveErrorType(NumberFormatException.class).get(), (Matcher)Is.is((Object)this.numberFormatExceptionErrorType));
        Assert.assertThat(exceptionMapper.resolveErrorType(RuntimeException.class).get(), (Matcher)Is.is((Object)this.runtimeExceptionErrorType));
        Assert.assertThat((Object)exceptionMapper.resolveErrorType(Exception.class).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void differentHierarchyMapping() {
        ExceptionMapper exceptionMapper = ExceptionMapper.builder().addExceptionMapping(NumberFormatException.class, this.numberFormatExceptionErrorType).addExceptionMapping(ClassCastException.class, this.classCastExceptionErrorType).addExceptionMapping(ArrayStoreException.class, this.arrayStoreExceptionErrorType).build();
        Assert.assertThat(exceptionMapper.resolveErrorType(NumberFormatException.class).get(), (Matcher)Is.is((Object)this.numberFormatExceptionErrorType));
        Assert.assertThat(exceptionMapper.resolveErrorType(ArrayStoreException.class).get(), (Matcher)Is.is((Object)this.arrayStoreExceptionErrorType));
        Assert.assertThat(exceptionMapper.resolveErrorType(ClassCastException.class).get(), (Matcher)Is.is((Object)this.classCastExceptionErrorType));
        Assert.assertThat((Object)exceptionMapper.resolveErrorType(Exception.class).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void complexHierarchyMapping() {
        ExceptionMapper exceptionMapper = ExceptionMapper.builder().addExceptionMapping(NumberFormatException.class, this.numberFormatExceptionErrorType).addExceptionMapping(ClassCastException.class, this.classCastExceptionErrorType).addExceptionMapping(RuntimeException.class, this.runtimeExceptionErrorType).addExceptionMapping(ArrayStoreChildException.class, this.arrayStoreChildExceptionErrorType).addExceptionMapping(ArrayStoreException.class, this.arrayStoreExceptionErrorType).build();
        Assert.assertThat(exceptionMapper.resolveErrorType(RuntimeException.class).get(), (Matcher)Is.is((Object)this.runtimeExceptionErrorType));
        Assert.assertThat(exceptionMapper.resolveErrorType(IllegalArgumentException.class).get(), (Matcher)Is.is((Object)this.runtimeExceptionErrorType));
        Assert.assertThat(exceptionMapper.resolveErrorType(NumberFormatException.class).get(), (Matcher)Is.is((Object)this.numberFormatExceptionErrorType));
        Assert.assertThat(exceptionMapper.resolveErrorType(ArrayStoreException.class).get(), (Matcher)Is.is((Object)this.arrayStoreExceptionErrorType));
        Assert.assertThat(exceptionMapper.resolveErrorType(ArrayStoreChildException.class).get(), (Matcher)Is.is((Object)this.arrayStoreChildExceptionErrorType));
        Assert.assertThat(exceptionMapper.resolveErrorType(ClassCastException.class).get(), (Matcher)Is.is((Object)this.classCastExceptionErrorType));
        Assert.assertThat(exceptionMapper.resolveErrorType(ClassCastChildException.class).get(), (Matcher)Is.is((Object)this.classCastExceptionErrorType));
        Assert.assertThat((Object)exceptionMapper.resolveErrorType(Exception.class).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=MuleRuntimeException.class)
    public void sameExceptionWithDifferentErrorTypes() {
        ExceptionMapper.builder().addExceptionMapping(NumberFormatException.class, this.numberFormatExceptionErrorType).addExceptionMapping(NumberFormatException.class, this.illegalArgumentExceptionErrorType);
    }

    private static class ArrayStoreChildException
    extends ArrayStoreException {
        private ArrayStoreChildException() {
        }
    }

    private static class ClassCastChildException
    extends ClassCastException {
        private ClassCastChildException() {
        }
    }
}

