/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.util.StreamCloserService;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.OnErrorContinueHandler;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.streaming.StreamingManager;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.tck.util.MuleContextUtils;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@Features(value={"Error Handling"})
@Stories(value={"On Error Continue"})
@RunWith(value=MockitoJUnitRunner.class)
public class OnErrorContinueHandlerTestCase
extends AbstractMuleContextTestCase {
    protected MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private MessagingException mockException;
    private Event muleEvent;
    private Message muleMessage = Message.of((Object)"");
    @Mock
    private StreamCloserService mockStreamCloserService;
    @Mock
    private StreamingManager mockStreamingManager;
    @Spy
    private TestTransaction mockTransaction = new TestTransaction(this.mockMuleContext);
    @Spy
    private TestTransaction mockXaTransaction = new TestTransaction(this.mockMuleContext, true);
    private Flow flow;
    private EventContext context;
    private OnErrorContinueHandler onErrorContinueHandler;

    @Before
    public void before() throws Exception {
        Transaction currentTransaction = TransactionCoordination.getInstance().getTransaction();
        if (currentTransaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(currentTransaction);
        }
        this.flow = MuleTestUtils.getTestFlow((MuleContext)this.muleContext);
        this.flow.initialise();
        this.onErrorContinueHandler = new OnErrorContinueHandler();
        this.onErrorContinueHandler.setMuleContext(this.mockMuleContext);
        this.onErrorContinueHandler.setFlowConstruct((FlowConstruct)this.flow);
        Mockito.when((Object)this.mockMuleContext.getStreamCloserService()).thenReturn((Object)this.mockStreamCloserService);
        MuleRegistry registry = this.mockMuleContext.getRegistry();
        ((MuleRegistry)Mockito.doReturn((Object)this.mockStreamingManager).when((Object)registry)).lookupObject(StreamingManager.class);
        this.context = DefaultEventContext.create((FlowConstruct)this.flow, (ComponentLocation)TEST_CONNECTOR_LOCATION);
        this.muleEvent = Event.builder((EventContext)this.context).message(this.muleMessage).flow((FlowConstruct)this.flow).build();
    }

    @Test
    public void testHandleExceptionWithNoConfig() throws Exception {
        this.configureXaTransactionAndSingleResourceTransaction();
        Event resultEvent = this.onErrorContinueHandler.handleException(this.mockException, this.muleEvent);
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)this.muleEvent.getMessage().getPayload().getValue()));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)VerificationModeFactory.times((int)0))).setRollbackOnly();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)VerificationModeFactory.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)VerificationModeFactory.times((int)0))).rollback();
        ((StreamCloserService)Mockito.verify((Object)this.mockStreamCloserService)).closeStream(Matchers.any(Object.class));
    }

    @Test
    public void testHandleExceptionWithConfiguredMessageProcessors() throws Exception {
        this.onErrorContinueHandler.setMessageProcessors(Arrays.asList(this.createSetStringMessageProcessor("A"), this.createSetStringMessageProcessor("B")));
        this.onErrorContinueHandler.initialise();
        Event result = this.onErrorContinueHandler.handleException(this.mockException, this.muleEvent);
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"B"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testHandleExceptionWithMessageProcessorsChangingEvent() throws Exception {
        Event lastEventCreated = Event.builder((EventContext)this.context).message(this.muleMessage).flow((FlowConstruct)this.flow).build();
        this.onErrorContinueHandler.setMessageProcessors(Arrays.asList(this.createChagingEventMessageProcessor(Event.builder((EventContext)this.context).message(this.muleMessage).flow((FlowConstruct)this.flow).build()), this.createChagingEventMessageProcessor(lastEventCreated)));
        this.onErrorContinueHandler.initialise();
        Event exceptionHandlingResult = this.onErrorContinueHandler.handleException(this.mockException, this.muleEvent);
        Assert.assertThat((Object)exceptionHandlingResult.getCorrelationId(), (Matcher)Is.is((Object)lastEventCreated.getCorrelationId()));
    }

    @Test
    public void testMessageToStringNotCalledOnFailure() throws Exception {
        this.muleEvent = Event.builder((Event)this.muleEvent).message((Message)Mockito.spy((Object)this.muleMessage)).build();
        this.muleEvent = (Event)Mockito.spy((Object)this.muleEvent);
        Mockito.when((Object)this.mockException.getStackTrace()).thenReturn((Object)new StackTraceElement[0]);
        Event lastEventCreated = Event.builder((EventContext)this.context).message(this.muleMessage).flow((FlowConstruct)this.flow).build();
        this.onErrorContinueHandler.setMessageProcessors(Arrays.asList(this.createFailingEventMessageProcessor(Event.builder((EventContext)this.context).message(this.muleMessage).flow((FlowConstruct)this.flow).build()), this.createFailingEventMessageProcessor(lastEventCreated)));
        this.onErrorContinueHandler.initialise();
        Mockito.when((Object)this.muleEvent.getMessage().toString()).thenThrow(new Throwable[]{new RuntimeException("Message.toString() should not be called")});
        this.expectedException.expect(Exception.class);
        Event exceptionHandlingResult = this.onErrorContinueHandler.handleException(this.mockException, this.muleEvent);
    }

    private Processor createChagingEventMessageProcessor(Event lastEventCreated) {
        return event -> lastEventCreated;
    }

    private Processor createFailingEventMessageProcessor(Event lastEventCreated) {
        return event -> {
            throw new DefaultMuleException((Throwable)this.mockException);
        };
    }

    private Processor createSetStringMessageProcessor(String appendText) {
        return event -> Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)appendText).build()).build();
    }

    private void configureXaTransactionAndSingleResourceTransaction() throws TransactionException {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockXaTransaction);
        TransactionCoordination.getInstance().suspendCurrentTransaction();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
    }
}

