/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.context.notification.ServerNotificationManager;
import org.mule.runtime.core.exception.ErrorHandler;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.OnErrorContinueHandler;
import org.mule.runtime.core.exception.OnErrorPropagateHandler;
import org.mule.runtime.core.execution.ErrorHandlingExecutionTemplate;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.mule.runtime.core.transaction.TransactionTemplateTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.mule.TestTransaction;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class ErrorHandlingExecutionTemplateTestCase
extends AbstractMuleTestCase {
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private FlowConstruct mockFlow = (FlowConstruct)Mockito.mock(FlowConstruct.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    @Mock
    private Event RETURN_VALUE;
    @Mock
    private MessagingException mockMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Event mockEvent;
    @Spy
    protected TestTransaction mockTransaction = new TestTransaction(this.mockMuleContext);
    @Mock
    protected MessagingExceptionHandler mockMessagingExceptionHandler;
    @Mock
    private ErrorHandler errorHandler;

    @Before
    public void unbindTransaction() throws Exception {
        Mockito.when((Object)this.mockEvent.getMessage()).thenReturn((Object)Message.of((Object)""));
        Transaction currentTransaction = TransactionCoordination.getInstance().getTransaction();
        if (currentTransaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(currentTransaction);
        }
        Mockito.when((Object)this.mockMessagingException.getStackTrace()).thenReturn((Object)new StackTraceElement[0]);
        Mockito.when((Object)this.mockEvent.getError()).thenReturn(Optional.empty());
    }

    @Test
    public void testSuccessfulExecution() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        Object result = executionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(this.RETURN_VALUE));
        Assert.assertThat((Object)((Event)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
    }

    private ExecutionTemplate createExceptionHandlingTransactionTemplate() {
        return ErrorHandlingExecutionTemplate.createErrorHandlingExecutionTemplate((MuleContext)this.mockMuleContext, (FlowConstruct)this.mockFlow, (MessagingExceptionHandler)this.mockMessagingExceptionHandler);
    }

    @Test
    public void testFailureException() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        Event mockResultEvent = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)this.mockMessagingException.getEvent()).thenReturn((Object)this.mockEvent).thenReturn((Object)this.mockEvent).thenReturn((Object)mockResultEvent);
        Mockito.when((Object)this.mockMessagingExceptionHandler.handleException(this.mockMessagingException, this.mockEvent)).thenReturn((Object)mockResultEvent);
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
            ((MessagingException)((Object)Mockito.verify((Object)((Object)this.mockMessagingException)))).setProcessedEvent(mockResultEvent);
        }
    }

    @Test
    public void testTransactionIsMarkedRollbackOnExceptionByDefault() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, null);
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).rollback();
    }

    @Test
    public void testTransactionIsNotRollbackOnEveryException() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, "*");
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).setRollbackOnly();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).rollback();
    }

    @Test
    public void testTransactionIsNotRollbackOnMatcherRegexPatternException() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, "org.mule.runtime.core.excep*");
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).setRollbackOnly();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).rollback();
    }

    @Test
    public void testTransactionIsNotRollbackOnClassHierarchyPatternException() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, "org.mule.runtime.api.exception.MuleException+");
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).setRollbackOnly();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).rollback();
    }

    @Test
    public void testTransactionIsNotRollbackOnClassExactlyPatternException() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, "org.mule.runtime.core.exception.MessagingException");
        executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(new MessagingException(this.mockEvent, (Throwable)null)));
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).setRollbackOnly();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).rollback();
    }

    @Test
    public void testTransactionIsRollbackOnPatternAppliesToRollbackAndCommit() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener("org.mule.runtime.api.exception.MuleException+", "org.mule.runtime.core.exception.MessagingException");
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)1))).setRollbackOnly();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)1))).rollback();
    }

    @Test
    public void testSuspendedTransactionNotResumedOnException() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        TransactionCoordination.getInstance().suspendCurrentTransaction();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
        this.configureExceptionListener(null, null);
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).resume();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).rollback();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).setRollbackOnly();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testSuspendedTransactionNotResumedAndNewTransactionResolvedOnException() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        TransactionCoordination.getInstance().suspendCurrentTransaction();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
        this.configureExceptionListener(null, null);
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        Transaction mockNewTransaction = (Transaction)Mockito.spy((Object)new TestTransaction(this.mockMuleContext));
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallbackStartsTransaction(this.mockMessagingException, mockNewTransaction));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).resume();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).rollback();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).setRollbackOnly();
        ((Transaction)Mockito.verify((Object)mockNewTransaction, (VerificationMode)Mockito.times((int)1))).rollback();
        ((Transaction)Mockito.verify((Object)mockNewTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((Transaction)Mockito.verify((Object)mockNewTransaction, (VerificationMode)Mockito.times((int)1))).setRollbackOnly();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testTransactionIsResolved() throws Exception {
        this.configureExceptionListener(null, null);
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallbackStartsTransaction(this.mockMessagingException, (Transaction)this.mockTransaction));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)1))).setRollbackOnly();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)1))).rollback();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    private void configureExceptionListener(String rollbackFilter, String commitFilter) {
        Mockito.when((Object)this.mockMessagingException.getEvent()).thenReturn((Object)this.mockEvent);
        Mockito.when((Object)this.mockMuleContext.getNotificationManager()).thenReturn(Mockito.mock(ServerNotificationManager.class));
        Mockito.when((Object)this.mockMuleContext.getRegistry()).thenReturn(Mockito.mock(MuleRegistry.class));
        Mockito.when((Object)this.mockMessagingExceptionHandler.handleException((MessagingException)((Object)Matchers.any(MessagingException.class)), (Event)Matchers.any(Event.class))).thenAnswer(invocationOnMock -> {
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.setMuleContext(this.mockMuleContext);
            errorHandler.setFlowConstruct(this.mockFlow);
            Object onError = rollbackFilter != null ? new OnErrorPropagateHandler() : (commitFilter != null ? new OnErrorContinueHandler() : new OnErrorPropagateHandler());
            onError.setMuleContext(this.mockMuleContext);
            onError.setFlowConstruct(this.mockFlow);
            errorHandler.setExceptionListeners(Collections.singletonList(onError));
            errorHandler.handleException((MessagingException)((Object)((Object)invocationOnMock.getArguments()[0])), (Event)invocationOnMock.getArguments()[1]);
            return null;
        });
    }
}

