/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.exception.ErrorTypeLocator;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.ExceptionToMessagingExceptionExecutionInterceptor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExceptionToMessagingExceptionExecutionInterceptorTestCase
extends AbstractMuleTestCase {
    @Mock
    private Processor mockMessageProcessor;
    @Mock
    private MuleContext mockMuleContext;
    @Mock
    private Event mockMuleEvent;
    @Mock
    private Event mockResultMuleEvent;
    @Mock
    private EventContext mockEventContext;
    @Mock
    private MessagingException mockMessagingException;
    @Mock
    private MuleException mockMuleException;
    @Mock
    private ErrorTypeLocator mockErrorTypeLocator;
    @Mock
    private ErrorTypeRepository mockErrorTypeRepository;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private org.mule.runtime.api.message.Error mockError;
    @Mock
    private ErrorType mockErrorType;
    private ExceptionToMessagingExceptionExecutionInterceptor cut;

    @Before
    public void before() {
        Mockito.when((Object)this.mockMessagingException.getFailingMessageProcessor()).thenCallRealMethod();
        Mockito.when((Object)this.mockMessagingException.getEvent()).thenReturn((Object)this.mockMuleEvent);
        Mockito.when((Object)this.mockMuleContext.getErrorTypeLocator()).thenReturn((Object)this.mockErrorTypeLocator);
        Mockito.when((Object)this.mockMuleContext.getErrorTypeRepository()).thenReturn((Object)this.mockErrorTypeRepository);
        Mockito.when((Object)this.mockMuleEvent.getFlowCallStack()).thenReturn((Object)new DefaultFlowCallStack());
        Mockito.when((Object)this.mockMuleEvent.getError()).thenReturn(Optional.of(this.mockError));
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)Message.of(null));
        Mockito.when((Object)this.mockMuleEvent.getContext()).thenReturn((Object)this.mockEventContext);
        Mockito.when((Object)this.mockErrorTypeLocator.lookupErrorType((Throwable)Matchers.any(Throwable.class))).thenReturn((Object)this.mockErrorType);
        Mockito.when((Object)this.mockErrorTypeRepository.getErrorType((ComponentIdentifier)Matchers.any())).thenReturn(Optional.of(Mockito.mock(ErrorType.class)));
        this.cut = new ExceptionToMessagingExceptionExecutionInterceptor();
        this.cut.setMuleContext(this.mockMuleContext);
    }

    @Test
    public void executionSuccessfully() throws MuleException {
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenReturn((Object)this.mockResultMuleEvent);
        Event result = this.cut.execute(this.mockMessageProcessor, this.mockMuleEvent);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.mockResultMuleEvent));
    }

    @Test
    public void messageExceptionThrown() throws MuleException {
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenThrow(new Throwable[]{this.mockMessagingException});
        try {
            this.cut.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
        }
    }

    @Test
    public void checkedExceptionThrown() throws MuleException {
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenThrow(new Throwable[]{this.mockMuleException});
        try {
            this.cut.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Is.is((Object)((Object)this.mockMuleException)));
        }
    }

    @Test
    public void runtimeExceptionThrown() throws MuleException {
        RuntimeException runtimeException = new RuntimeException();
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenThrow(new Throwable[]{runtimeException});
        try {
            this.cut.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Is.is((Object)runtimeException));
        }
    }

    @Test
    public void errorThrown() throws MuleException {
        Error error = new Error();
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenThrow(new Throwable[]{error});
        try {
            this.cut.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Error)e.getCause()), (Matcher)Is.is((Object)error));
        }
    }

    @Test
    public void messagingExceptionWithErrorWrappedByAnotherMessagingException() throws Exception {
        this.testExceptionWrappedByAnotherException((MuleException)((Object)this.mockMessagingException));
    }

    @Test
    public void messagingExceptionWithErrorWrappedByNonMessagingException() throws Exception {
        this.testExceptionWrappedByAnotherException(this.mockMuleException);
    }

    private void testExceptionWrappedByAnotherException(MuleException wrapperException) throws MuleException {
        ErrorType moreSpecificErrorType = (ErrorType)Mockito.mock(ErrorType.class);
        org.mule.runtime.api.message.Error moreSpecificError = (org.mule.runtime.api.message.Error)Mockito.mock(org.mule.runtime.api.message.Error.class);
        Mockito.when((Object)moreSpecificError.getErrorType()).thenReturn((Object)moreSpecificErrorType);
        IllegalStateException causeOfMoreSpecificException = new IllegalStateException();
        Mockito.when((Object)moreSpecificError.getCause()).thenReturn((Object)causeOfMoreSpecificException);
        MessagingException moreSpecificException = (MessagingException)((Object)Mockito.mock(MessagingException.class, (Answer)Answers.RETURNS_DEEP_STUBS.get()));
        Mockito.when((Object)moreSpecificException.getEvent().getError()).thenReturn(Optional.of(moreSpecificError));
        Mockito.when((Object)moreSpecificException.getCause()).thenReturn((Object)causeOfMoreSpecificException);
        Mockito.when((Object)wrapperException.getCause()).thenReturn((Object)moreSpecificException);
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenThrow(new Throwable[]{wrapperException});
        try {
            this.cut.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat(e.getEvent().getError().get(), (Matcher)Is.is((Object)moreSpecificError));
        }
    }
}

