/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ReplyToHandler;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.context.notification.MessageProcessorNotification;
import org.mule.runtime.core.context.notification.ServerNotificationManager;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.MessageProcessorExecutionInterceptor;
import org.mule.runtime.core.execution.MessageProcessorNotificationExecutionInterceptor;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class MessageProcessorNotificationExecutionInterceptorTestCase
extends AbstractMuleTestCase {
    @Mock
    private ServerNotificationManager mockNotificationManager;
    @Mock
    private MessageProcessorExecutionInterceptor mockNextInterceptor;
    @Mock(extraInterfaces={AnnotatedObject.class})
    private Processor mockMessageProcessor;
    @Mock
    private MuleContext mockMuleContext;
    @Mock
    private Pipeline mockPipeline;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Event mockMuleEvent;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Event mockMuleEventPreviousExecution;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Event mockResultMuleEvent;
    @Mock
    private ReplyToHandler mockReplyToHandler;
    @Mock
    private MessagingException mockMessagingException;
    private MessageProcessorNotificationExecutionInterceptor messageProcessorNotificationExecutionInterceptor;

    @Before
    public void setUpTest() {
        this.messageProcessorNotificationExecutionInterceptor = new MessageProcessorNotificationExecutionInterceptor(this.mockNextInterceptor);
        this.messageProcessorNotificationExecutionInterceptor.setMuleContext(this.mockMuleContext);
        Mockito.when((Object)this.mockPipeline.getName()).thenReturn((Object)"flow");
        this.messageProcessorNotificationExecutionInterceptor.setFlowConstruct((FlowConstruct)this.mockPipeline);
        Mockito.when((Object)this.mockMuleContext.getNotificationManager()).thenReturn((Object)this.mockNotificationManager);
        Mockito.when((Object)((AnnotatedObject)this.mockMessageProcessor).getAnnotation(AbstractAnnotatedObject.LOCATION_KEY)).thenReturn((Object)new DefaultComponentLocation(Optional.empty(), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("path", Optional.empty(), Optional.empty(), Optional.empty()))));
    }

    @Test
    public void testExecutionSuccessfully() throws MuleException {
        ArrayList serverNotifications = new ArrayList();
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenReturn((Object)this.mockResultMuleEvent);
        Mockito.when((Object)this.mockMuleEvent.isNotificationsEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNextInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent)).thenReturn((Object)this.mockResultMuleEvent);
        Mockito.when((Object)this.mockNotificationManager.isNotificationEnabled(MessageProcessorNotification.class)).thenReturn((Object)true);
        ((ServerNotificationManager)Mockito.doAnswer(invocationOnMock -> {
            serverNotifications.add((ServerNotification)invocationOnMock.getArguments()[0]);
            return null;
        }).when((Object)this.mockNotificationManager)).fireNotification((ServerNotification)Matchers.any(ServerNotification.class));
        Event result = this.messageProcessorNotificationExecutionInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.mockResultMuleEvent));
        Assert.assertThat((Object)serverNotifications.size(), (Matcher)Is.is((Object)2));
        MessageProcessorNotification beforeMessageProcessorNotification = (MessageProcessorNotification)serverNotifications.get(0);
        MessageProcessorNotification afterMessageProcessorNotification = (MessageProcessorNotification)serverNotifications.get(1);
        Assert.assertThat((Object)beforeMessageProcessorNotification.getAction(), (Matcher)Is.is((Object)1601));
        Assert.assertThat((Object)beforeMessageProcessorNotification.getProcessor(), (Matcher)Is.is((Object)this.mockMessageProcessor));
        Assert.assertThat((Object)beforeMessageProcessorNotification.getException(), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)afterMessageProcessorNotification.getAction(), (Matcher)Is.is((Object)1602));
        Assert.assertThat((Object)afterMessageProcessorNotification.getProcessor(), (Matcher)Is.is((Object)this.mockMessageProcessor));
        Assert.assertThat((Object)afterMessageProcessorNotification.getException(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void ignoresSuccessfulNotificationIfDisabled() throws MuleException {
        ArrayList serverNotifications = new ArrayList();
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenReturn((Object)this.mockResultMuleEvent);
        Mockito.when((Object)this.mockNextInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent)).thenReturn((Object)this.mockResultMuleEvent);
        Mockito.when((Object)this.mockNotificationManager.isNotificationEnabled(MessageProcessorNotification.class)).thenReturn((Object)true);
        ((ServerNotificationManager)Mockito.doAnswer(invocationOnMock -> {
            serverNotifications.add((ServerNotification)invocationOnMock.getArguments()[0]);
            return null;
        }).when((Object)this.mockNotificationManager)).fireNotification((ServerNotification)Matchers.any(ServerNotification.class));
        Event result = this.messageProcessorNotificationExecutionInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.mockResultMuleEvent));
        Assert.assertThat((Object)serverNotifications.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void requestContextSetBeforeProcessingEvent() throws MuleException {
        ArrayList serverNotifications = new ArrayList();
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenReturn((Object)this.mockResultMuleEvent);
        Mockito.when((Object)this.mockNextInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent)).thenReturn((Object)this.mockResultMuleEvent);
        Mockito.when((Object)this.mockNotificationManager.isNotificationEnabled(MessageProcessorNotification.class)).thenReturn((Object)true);
        ((ServerNotificationManager)Mockito.doAnswer(invocationOnMock -> {
            serverNotifications.add((ServerNotification)invocationOnMock.getArguments()[0]);
            return null;
        }).when((Object)this.mockNotificationManager)).fireNotification((ServerNotification)Matchers.any(ServerNotification.class));
        Event.setCurrentEvent((Event)this.mockMuleEventPreviousExecution);
        Event result = this.messageProcessorNotificationExecutionInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.mockResultMuleEvent));
        Assert.assertThat((Object)serverNotifications.size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)Event.getCurrentEvent(), (Matcher)Is.is((Object)this.mockMuleEvent));
        Assert.assertThat((Object)Event.getCurrentEvent(), (Matcher)CoreMatchers.not((Object)this.mockMuleEventPreviousExecution));
    }

    @Test
    public void testExecutionFailure() throws MuleException {
        ArrayList serverNotifications = new ArrayList();
        Mockito.when((Object)this.mockNextInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent)).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMuleEvent.isNotificationsEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNotificationManager.isNotificationEnabled(MessageProcessorNotification.class)).thenReturn((Object)true);
        ((ServerNotificationManager)Mockito.doAnswer(invocationOnMock -> {
            serverNotifications.add((ServerNotification)invocationOnMock.getArguments()[0]);
            return null;
        }).when((Object)this.mockNotificationManager)).fireNotification((ServerNotification)Matchers.any(ServerNotification.class));
        try {
            this.messageProcessorNotificationExecutionInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        Assert.assertThat((Object)serverNotifications.size(), (Matcher)Is.is((Object)2));
        MessageProcessorNotification beforeMessageProcessorNotification = (MessageProcessorNotification)serverNotifications.get(0);
        MessageProcessorNotification afterMessageProcessorNotification = (MessageProcessorNotification)serverNotifications.get(1);
        Assert.assertThat((Object)beforeMessageProcessorNotification.getAction(), (Matcher)Is.is((Object)1601));
        Assert.assertThat((Object)beforeMessageProcessorNotification.getProcessor(), (Matcher)Is.is((Object)this.mockMessageProcessor));
        Assert.assertThat((Object)((Object)beforeMessageProcessorNotification.getException()), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)afterMessageProcessorNotification.getAction(), (Matcher)Is.is((Object)1602));
        Assert.assertThat((Object)afterMessageProcessorNotification.getProcessor(), (Matcher)Is.is((Object)this.mockMessageProcessor));
        Assert.assertThat((Object)((Object)afterMessageProcessorNotification.getException()), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
    }

    @Test
    public void ignoresFailureNotificationIfDisabled() throws MuleException {
        ArrayList serverNotifications = new ArrayList();
        Mockito.when((Object)this.mockNextInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent)).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockNotificationManager.isNotificationEnabled(MessageProcessorNotification.class)).thenReturn((Object)true);
        ((ServerNotificationManager)Mockito.doAnswer(invocationOnMock -> {
            serverNotifications.add((ServerNotification)invocationOnMock.getArguments()[0]);
            return null;
        }).when((Object)this.mockNotificationManager)).fireNotification((ServerNotification)Matchers.any(ServerNotification.class));
        try {
            this.messageProcessorNotificationExecutionInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        Assert.assertThat((Object)serverNotifications.size(), (Matcher)Is.is((Object)0));
    }
}

