/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.DefaultMuleContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.exception.ErrorTypeRepositoryFactory;
import org.mule.runtime.core.exception.Errors;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.ModuleFlowProcessingPhase;
import org.mule.runtime.core.execution.ModuleFlowProcessingPhaseTemplate;
import org.mule.runtime.core.execution.PhaseResultNotifier;
import org.mule.runtime.core.execution.ResponseCompletionCallback;
import org.mule.runtime.core.message.ErrorBuilder;
import org.mule.runtime.core.message.ErrorTypeBuilder;
import org.mule.runtime.core.policy.FailureSourcePolicyResult;
import org.mule.runtime.core.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.policy.SourcePolicy;
import org.mule.runtime.core.policy.SuccessSourcePolicyResult;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.EitherMatcher;
import org.mule.tck.junit4.matcher.EventMatcher;
import org.mule.tck.junit4.matcher.MessagingExceptionMatcher;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.size.SmallTest;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

@RunWith(value=Parameterized.class)
@SmallTest
public class ModuleFlowProcessingPhaseTestCase
extends AbstractMuleTestCase {
    private static final ErrorType ERROR_FROM_FLOW = ErrorTypeBuilder.builder().parentErrorType((ErrorType)Mockito.mock(ErrorType.class)).namespace("TEST").identifier("FLOW_FAILED").build();
    private boolean enableSourcePolicies;
    @Rule
    public SystemProperty enableSourcePoliciesSystemProperty;
    private MuleContext muleContext;
    private FlowConstruct flow;
    private MessageProcessContext context;
    private ModuleFlowProcessingPhaseTemplate template;
    private PhaseResultNotifier notifier;
    private SourcePolicy sourcePolicy;
    private ModuleFlowProcessingPhase moduleFlowProcessingPhase;

    public ModuleFlowProcessingPhaseTestCase(boolean enableSourcePolicies) {
        this.enableSourcePolicies = enableSourcePolicies;
        this.enableSourcePoliciesSystemProperty = enableSourcePolicies ? new SystemProperty("enableSourcePolicies", "true") : new SystemProperty("enableSourcePolicies", null);
    }

    @Parameterized.Parameters
    public static Collection<Object> data() {
        return Arrays.asList(false, true);
    }

    @Before
    public void before() throws Exception {
        new DefaultMuleContext();
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.muleContext.getErrorTypeRepository()).thenReturn((Object)ErrorTypeRepositoryFactory.createDefaultErrorTypeRepository());
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn(Mockito.mock(MuleRegistry.class));
        PolicyManager policyManager = (PolicyManager)Mockito.mock(PolicyManager.class);
        this.sourcePolicy = (SourcePolicy)Mockito.mock(SourcePolicy.class);
        Mockito.when((Object)policyManager.createSourcePolicyInstance((ComponentLocation)Matchers.any(), (Event)Matchers.any(), (Processor)Matchers.any(), (MessageSourceResponseParametersProcessor)Matchers.any())).thenReturn((Object)this.sourcePolicy);
        ((SourcePolicy)Mockito.doAnswer(invocation -> Either.right((Object)new SuccessSourcePolicyResult((Event)invocation.getArgumentAt(0, Event.class), Collections.emptyMap(), null))).when((Object)this.sourcePolicy)).process((Event)Matchers.any());
        this.moduleFlowProcessingPhase = new ModuleFlowProcessingPhase(policyManager);
        LifecycleUtils.initialiseIfNeeded((Object)this.moduleFlowProcessingPhase, (MuleContext)this.muleContext);
        this.flow = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        MessagingExceptionHandler exceptionHandler = (MessagingExceptionHandler)Mockito.mock(MessagingExceptionHandler.class);
        Mockito.when((Object)this.flow.getExceptionListener()).thenReturn((Object)exceptionHandler);
        Mockito.when((Object)this.flow.getMuleContext()).thenReturn((Object)this.muleContext);
        this.context = (MessageProcessContext)Mockito.mock(MessageProcessContext.class);
        Mockito.when((Object)this.context.getFlowConstruct()).thenReturn((Object)this.flow);
        MessageSource source = (MessageSource)Mockito.mock(MessageSource.class);
        Mockito.when((Object)source.getLocation()).thenReturn((Object)DefaultComponentLocation.fromSingleComponent((String)"/0"));
        Mockito.when((Object)this.context.getMessageSource()).thenReturn((Object)source);
        Mockito.when((Object)this.context.getTransactionConfig()).thenReturn(Optional.empty());
        this.template = (ModuleFlowProcessingPhaseTemplate)Mockito.mock(ModuleFlowProcessingPhaseTemplate.class);
        Mockito.when((Object)this.template.getMessage()).thenReturn((Object)Message.of(null));
        Mockito.when((Object)this.template.sendResponseToClient((Event)Matchers.any(), (Map)Matchers.any(), (Function)Matchers.any(), (ResponseCompletionCallback)Matchers.any())).thenAnswer(invocation -> {
            ((ResponseCompletionCallback)invocation.getArgumentAt(3, ResponseCompletionCallback.class)).responseSentSuccessfully();
            return Mono.empty();
        });
        Mockito.when((Object)this.template.sendFailureResponseToClient((MessagingException)((Object)Matchers.any()), (Map)Matchers.any(), (ResponseCompletionCallback)Matchers.any())).thenAnswer(invocation -> {
            ((ResponseCompletionCallback)invocation.getArgumentAt(2, ResponseCompletionCallback.class)).responseSentSuccessfully();
            return Mono.empty();
        });
        this.notifier = (PhaseResultNotifier)Mockito.mock(PhaseResultNotifier.class);
    }

    @Test
    public void success() throws Exception {
        this.configureSuccessfulFlow(this.template);
        Mockito.when((Object)this.template.getSuccessfulExecutionResponseParametersFunction()).thenReturn(event -> Collections.emptyMap());
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        this.verifySuccess();
    }

    private void verifySuccess() {
        ((MessagingExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((MessagingException)((Object)Matchers.any()), (Event)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendResponseToClient((Event)Matchers.any(), (Map)Matchers.any(), (Function)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendFailureResponseToClient((MessagingException)((Object)Matchers.any()), (Map)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendAfterTerminateResponseToClient((Either)Matchers.argThat((Matcher)EitherMatcher.rightMatches((Matcher)org.hamcrest.Matchers.any(Event.class))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)Matchers.any());
    }

    @Test
    public void successWithAsyncResponse() throws Exception {
        Assume.assumeThat((Object)this.enableSourcePolicies, (Matcher)org.hamcrest.Matchers.is((Object)false));
        Reference sinkReference = new Reference();
        Mockito.reset((Object[])new ModuleFlowProcessingPhaseTemplate[]{this.template});
        Mockito.when((Object)this.template.sendResponseToClient((Event)Matchers.any(), (Map)Matchers.any(), (Function)Matchers.any(), (ResponseCompletionCallback)Matchers.any())).thenAnswer(invocation -> {
            ((ResponseCompletionCallback)invocation.getArgumentAt(3, ResponseCompletionCallback.class)).responseSentSuccessfully();
            return Mono.create(arg_0 -> ((Reference)sinkReference).set(arg_0));
        });
        Mockito.when((Object)this.template.getMessage()).thenReturn((Object)Message.of(null));
        this.configureSuccessfulFlow(this.template);
        Mockito.when((Object)this.template.getSuccessfulExecutionResponseParametersFunction()).thenReturn(event -> Collections.emptyMap());
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendAfterTerminateResponseToClient((Either)Matchers.any());
        ((MonoSink)sinkReference.get()).success();
        this.verifySuccess();
    }

    @Test
    public void sourceResponseGenerateErrorType() throws Exception {
        this.configureSuccessfulFlow(this.template);
        this.configureFailureResponse();
        Mockito.when((Object)this.template.getFailedExecutionResponseParametersFunction()).thenReturn(event -> Collections.emptyMap());
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        this.verifyFlowErrorHandler(this.isErrorTypeSourceResponseGenerate());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((Event)Matchers.any(), (Map)Matchers.any(), (Function)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any()), (Map)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendAfterTerminateResponseToClient((Either)Matchers.argThat((Matcher)EitherMatcher.rightMatches((Matcher)org.hamcrest.Matchers.any(Event.class))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)Matchers.any());
    }

    @Test
    public void sourceResponseSendErrorType() throws Exception {
        this.configureSuccessfulFlow(this.template);
        Mockito.when((Object)this.template.getSuccessfulExecutionResponseParametersFunction()).thenReturn(event -> Collections.emptyMap());
        this.configureFailingResponseSend();
        Mockito.when((Object)this.template.getFailedExecutionResponseParametersFunction()).thenReturn(event -> Collections.emptyMap());
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        this.verifyFlowErrorHandler(this.isErrorTypeSourceResponseSend());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendResponseToClient((Event)Matchers.any(), (Map)Matchers.any(), (Function)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any()), (Map)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendAfterTerminateResponseToClient((Either)Matchers.argThat((Matcher)EitherMatcher.rightMatches((Matcher)org.hamcrest.Matchers.any(Event.class))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)Matchers.any());
    }

    @Test
    public void flowError() throws Exception {
        this.configureFailingFlow(this.template, this.mockException());
        Mockito.when((Object)this.template.getSuccessfulExecutionResponseParametersFunction()).thenReturn(event -> Collections.emptyMap());
        Mockito.when((Object)this.template.getFailedExecutionResponseParametersFunction()).thenReturn(event -> Collections.emptyMap());
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        this.verifyFlowError();
    }

    private void verifyFlowError() {
        ((MessagingExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((MessagingException)((Object)Matchers.any()), (Event)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((Event)Matchers.any(), (Map)Matchers.any(), (Function)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any()), (Map)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendAfterTerminateResponseToClient((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeFlowFailure()))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)Matchers.any());
    }

    @Test
    public void flowErrorWithAsyncResponse() throws Exception {
        Assume.assumeThat((Object)this.enableSourcePolicies, (Matcher)org.hamcrest.Matchers.is((Object)false));
        Reference sinkReference = new Reference();
        Reference exception = new Reference();
        Mockito.reset((Object[])new ModuleFlowProcessingPhaseTemplate[]{this.template});
        Mockito.when((Object)this.template.getMessage()).thenReturn((Object)Message.of(null));
        Mockito.when((Object)this.template.sendFailureResponseToClient((MessagingException)((Object)Matchers.any()), (Map)Matchers.any(), (ResponseCompletionCallback)Matchers.any())).thenAnswer(invocation -> {
            ((ResponseCompletionCallback)invocation.getArgumentAt(2, ResponseCompletionCallback.class)).responseSentSuccessfully();
            Event event = ((MessagingException)((Object)((Object)invocation.getArgumentAt(0, MessagingException.class)))).getEvent();
            exception.set((Object)this.buildFailingFlowException(event, this.mockException()));
            return Mono.create(arg_0 -> ((Reference)sinkReference).set(arg_0));
        });
        this.configureFailingFlow(this.template, this.mockException());
        Mockito.when((Object)this.template.getSuccessfulExecutionResponseParametersFunction()).thenReturn(event -> Collections.emptyMap());
        Mockito.when((Object)this.template.getFailedExecutionResponseParametersFunction()).thenReturn(event -> Collections.emptyMap());
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendAfterTerminateResponseToClient((Either)Matchers.any());
        ((MonoSink)sinkReference.get()).error((Throwable)exception.get());
        this.verifyFlowError();
    }

    @Test
    public void sourceErrorResponseGenerateErrorType() throws Exception {
        this.configureSuccessfulFlow(this.template);
        this.configureFailureResponse();
        Mockito.when((Object)this.template.getFailedExecutionResponseParametersFunction()).thenReturn(event -> {
            throw this.mockException();
        });
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        this.verifyFlowErrorHandler(this.isErrorTypeSourceResponseGenerate());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((Event)Matchers.any(), (Map)Matchers.any(), (Function)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendFailureResponseToClient((MessagingException)((Object)Matchers.any()), (Map)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendAfterTerminateResponseToClient((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeSourceErrorResponseGenerate()))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseFailure((Exception)Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(this.mockException().getClass())));
    }

    @Test
    public void sourceErrorResponseSendErrorType() throws Exception {
        this.configureSuccessfulFlow(this.template);
        this.configureFailureResponse();
        this.configureFailingErrorSend();
        Mockito.when((Object)this.template.getFailedExecutionResponseParametersFunction()).thenReturn(event -> Collections.emptyMap());
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        this.verifyFlowErrorHandler(this.isErrorTypeSourceResponseGenerate());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((Event)Matchers.any(), (Map)Matchers.any(), (Function)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any()), (Map)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendAfterTerminateResponseToClient((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeSourceErrorResponseSend()))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseFailure((Exception)Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(this.mockException().getClass())));
    }

    @Test
    public void sourceErrorResponseGenerateErrorTypeAfterFlowError() throws Exception {
        this.configureFailingFlow(this.template, this.mockException());
        Mockito.when((Object)this.template.getSuccessfulExecutionResponseParametersFunction()).thenReturn(event -> {
            Assert.fail((String)"Must not call success handling methods");
            return Collections.emptyMap();
        });
        Mockito.when((Object)this.template.getFailedExecutionResponseParametersFunction()).thenReturn(event -> {
            throw this.mockException();
        });
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((MessagingException)((Object)Matchers.any()), (Event)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((Event)Matchers.any(), (Map)Matchers.any(), (Function)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendFailureResponseToClient((MessagingException)((Object)Matchers.any()), (Map)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendAfterTerminateResponseToClient((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeSourceErrorResponseGenerate()))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseFailure((Exception)Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(this.mockException().getClass())));
    }

    @Test
    public void sourceErrorResponseGenerateErrorTypeDuringHandler() throws Exception {
        this.configureErrorHandlingFailingFlow(this.template, this.mockException());
        Mockito.when((Object)this.template.getFailedExecutionResponseParametersFunction()).thenReturn(event -> Collections.emptyMap());
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((MessagingException)((Object)Matchers.any()), (Event)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((Event)Matchers.any(), (Map)Matchers.any(), (Function)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendFailureResponseToClient((MessagingException)((Object)Matchers.any()), (Map)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendAfterTerminateResponseToClient((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeSourceErrorResponseGenerate()))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseFailure((Exception)Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(this.mockException().getClass())));
    }

    @Test
    public void sourceErrorResponseSendErrorTypeAfterFlowError() throws Exception {
        this.configureFailingFlow(this.template, this.mockException());
        Mockito.when((Object)this.template.getSuccessfulExecutionResponseParametersFunction()).thenReturn(event -> {
            Assert.fail((String)"Must not call success handling methods");
            return Collections.emptyMap();
        });
        this.configureFailingErrorSend();
        Mockito.when((Object)this.template.getFailedExecutionResponseParametersFunction()).thenReturn(event -> Collections.emptyMap());
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((MessagingException)((Object)Matchers.any()), (Event)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((Event)Matchers.any(), (Map)Matchers.any(), (Function)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any()), (Map)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendAfterTerminateResponseToClient((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeSourceErrorResponseSend()))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseFailure((Exception)Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(this.mockException().getClass())));
    }

    private void verifyFlowErrorHandler(EventMatcher errorHandlerEventMatcher) {
        if (this.enableSourcePolicies) {
            ((MessagingExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((MessagingException)((Object)Matchers.any()), (Event)Matchers.any());
        } else {
            ((MessagingExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener())).handleException((MessagingException)((Object)Matchers.any()), (Event)Matchers.argThat((Matcher)errorHandlerEventMatcher));
        }
    }

    private EventMatcher isErrorTypeSourceResponseGenerate() {
        return EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.SOURCE_RESPONSE_GENERATE.getNamespace(), (String)Errors.ComponentIdentifiers.SOURCE_RESPONSE_GENERATE.getName());
    }

    private EventMatcher isErrorTypeSourceResponseSend() {
        return EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.SOURCE_RESPONSE_SEND.getNamespace(), (String)Errors.ComponentIdentifiers.SOURCE_RESPONSE_SEND.getName());
    }

    private EventMatcher isErrorTypeFlowFailure() {
        return EventMatcher.hasErrorType((String)ERROR_FROM_FLOW.getNamespace(), (String)ERROR_FROM_FLOW.getIdentifier());
    }

    private EventMatcher isErrorTypeSourceErrorResponseGenerate() {
        return EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.SOURCE_ERROR_RESPONSE_GENERATE.getNamespace(), (String)Errors.ComponentIdentifiers.SOURCE_ERROR_RESPONSE_GENERATE.getName());
    }

    private EventMatcher isErrorTypeSourceErrorResponseSend() {
        return EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.SOURCE_ERROR_RESPONSE_SEND.getNamespace(), (String)Errors.ComponentIdentifiers.SOURCE_ERROR_RESPONSE_SEND.getName());
    }

    private void configureSuccessfulFlow(ModuleFlowProcessingPhaseTemplate template) throws Exception {
        Mockito.when((Object)template.routeEventAsync((Event)Matchers.any())).then(invocation -> Mono.just((Object)invocation.getArgumentAt(0, Event.class)));
        Mockito.when((Object)this.sourcePolicy.process((Event)Matchers.any())).thenAnswer(invocation -> Either.right((Object)new SuccessSourcePolicyResult((Event)invocation.getArgumentAt(0, Event.class), Collections.emptyMap(), (MessageSourceResponseParametersProcessor)Mockito.mock(MessageSourceResponseParametersProcessor.class))));
    }

    private void configureThrowingFlow(ModuleFlowProcessingPhaseTemplate template, RuntimeException failure, boolean inErrorHandler) throws Exception {
        Mockito.when((Object)template.routeEventAsync((Event)Matchers.any())).then(invocation -> {
            MessagingException me = this.buildFailingFlowException((Event)invocation.getArgumentAt(0, Event.class), failure);
            me.setInErrorHandler(inErrorHandler);
            throw me;
        });
        Mockito.when((Object)this.sourcePolicy.process((Event)Matchers.any())).thenAnswer(invocation -> {
            MessagingException me = this.buildFailingFlowException((Event)invocation.getArgumentAt(0, Event.class), failure);
            me.setInErrorHandler(inErrorHandler);
            return Either.left((Object)new FailureSourcePolicyResult(me, Collections.emptyMap()));
        });
    }

    private void configureFailingFlow(ModuleFlowProcessingPhaseTemplate template, RuntimeException failure) throws Exception {
        this.configureThrowingFlow(template, failure, false);
    }

    private void configureErrorHandlingFailingFlow(ModuleFlowProcessingPhaseTemplate template, RuntimeException failure) throws Exception {
        this.configureThrowingFlow(template, failure, true);
    }

    private void configureFailureResponse() throws Exception {
        Mockito.when((Object)this.template.getSuccessfulExecutionResponseParametersFunction()).thenReturn(event -> {
            throw this.mockException();
        });
        ((SourcePolicy)Mockito.doAnswer(invocation -> Either.left((Object)new FailureSourcePolicyResult(new MessagingException((Event)invocation.getArgumentAt(0, Event.class), (Throwable)this.mockException()), Collections.emptyMap()))).when((Object)this.sourcePolicy)).process((Event)Matchers.any());
    }

    private void configureFailingResponseSend() {
        ((ModuleFlowProcessingPhaseTemplate)Mockito.doAnswer(invocation -> {
            Event event = (Event)invocation.getArgumentAt(0, Event.class);
            MessagingException messagingException = new MessagingException(event, (Throwable)this.mockException());
            try {
                ((ResponseCompletionCallback)invocation.getArgumentAt(3, ResponseCompletionCallback.class)).responseSentWithFailure(messagingException, messagingException.getEvent());
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
            return Optional.empty();
        }).when((Object)this.template)).sendResponseToClient((Event)Matchers.any(), (Map)Matchers.any(), (Function)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
    }

    private void configureFailingErrorSend() {
        ((ModuleFlowProcessingPhaseTemplate)Mockito.doAnswer(invocation -> {
            MessagingException messagingException = (MessagingException)((Object)((Object)invocation.getArgumentAt(0, MessagingException.class)));
            try {
                ((ResponseCompletionCallback)invocation.getArgumentAt(2, ResponseCompletionCallback.class)).responseSentWithFailure(messagingException, messagingException.getEvent());
                return Mono.empty();
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }).when((Object)this.template)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any()), (Map)Matchers.any(), (ResponseCompletionCallback)Matchers.any());
    }

    private MessagingException buildFailingFlowException(Event event, Exception exception) {
        return new MessagingException(Event.builder((Event)event).error(ErrorBuilder.builder((Throwable)exception).errorType(ERROR_FROM_FLOW).build()).build(), (Throwable)exception);
    }

    private RuntimeException mockException() {
        return new NullPointerException("Mock");
    }
}

