/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.transaction.ExternalTransactionAwareTransactionFactory;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.context.notification.ServerNotificationManager;
import org.mule.runtime.core.exception.ErrorHandler;
import org.mule.runtime.core.exception.ErrorHandlerFactory;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.OnErrorContinueHandler;
import org.mule.runtime.core.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.runtime.core.execution.TransactionalExecutionTemplateTestCase;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.mule.runtime.core.transaction.TransactionTemplateTestUtils;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.tck.testmodels.mule.TestTransactionFactory;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class TransactionalErrorHandlingExecutionTemplateTestCase
extends TransactionalExecutionTemplateTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private TransactionConfig mockTransactionConfig;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private TransactionFactory mockTransactionFactory;

    @Before
    public void setUp() throws TransactionException {
        Mockito.when((Object)this.mockTransactionConfig.getFactory()).thenReturn((Object)this.mockTransactionFactory);
        Mockito.when((Object)this.mockTransactionFactory.beginTransaction(this.mockMuleContext)).thenAnswer(invocationOnMock -> {
            TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
            return this.mockTransaction;
        });
    }

    @Test
    public void testActionNoneAndXaTxAndFailureInCallback() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Event mockExceptionListenerResultEvent = this.configureExceptionListenerCall();
        try {
            executionTemplate.execute(this.getFailureTransactionCallback());
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
            ((MessagingException)((Object)Mockito.verify((Object)((Object)this.mockMessagingException)))).setProcessedEvent(mockExceptionListenerResultEvent);
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).suspend();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).rollback();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).resume();
    }

    @Test
    public void testActionAlwaysBeginAndSuspendXaTxAndFailureCallback() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = this.createAlwaysBeginXaTransaction();
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Event exceptionListenerResult = this.configureExceptionListenerCall();
        try {
            executionTemplate.execute(this.getFailureTransactionCallback());
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
            Assert.assertThat((Object)e.getEvent(), (Matcher)Is.is((Object)exceptionListenerResult));
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).suspend();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).rollback();
        ((TestTransaction)Mockito.verify((Object)this.mockNewTransaction)).rollback();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).resume();
        Assert.assertThat((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction()), (Matcher)Is.is((Object)this.mockTransaction));
    }

    @Test
    public void testActionAlwaysJoinAndExternalTxAndFailureCallback() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(3);
        config.setInteractWithExternal(true);
        this.mockExternalTransactionFactory = (ExternalTransactionAwareTransactionFactory)Mockito.mock(ExternalTransactionAwareTransactionFactory.class);
        config.setFactory((TransactionFactory)this.mockExternalTransactionFactory);
        Mockito.when((Object)this.mockExternalTransactionFactory.joinExternalTransaction(this.mockMuleContext)).thenAnswer(invocationOnMock -> {
            TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
            return this.mockTransaction;
        });
        ExecutionTemplate transactionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        Event exceptionListenerResult = this.configureExceptionListenerCall();
        try {
            transactionTemplate.execute(this.getFailureTransactionCallback());
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
            Assert.assertThat((Object)e.getEvent(), (Matcher)Is.is((Object)exceptionListenerResult));
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)1))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testInnerTransactionCreatedAndResolved() throws Exception {
        ExecutionTemplate transactionTemplate = this.createExecutionTemplate((TransactionConfig)new MuleTransactionConfig());
        this.configureExceptionListenerCall();
        Mockito.when((Object)this.mockMessagingException.causedRollback()).thenReturn((Object)false);
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallbackStartsTransaction(this.mockMessagingException, (Transaction)this.mockTransaction));
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)1))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testInnerTransactionCreatedAndNotResolved() throws Exception {
        TransactionalErrorHandlingExecutionTemplate transactionTemplate = TransactionalErrorHandlingExecutionTemplate.createScopeExecutionTemplate((MuleContext)this.mockMuleContext, (FlowConstruct)this.mockFlow, (TransactionConfig)new MuleTransactionConfig(), (MessagingExceptionHandler)this.mockMessagingExceptionHandler);
        this.configureCatchExceptionListenerCall();
        Mockito.when((Object)this.mockMessagingException.causedRollback()).thenReturn((Object)false);
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallbackStartsTransaction(this.mockMessagingException, (Transaction)this.mockTransaction));
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)Mockito.times((int)0))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void transactionCommitFailsCallsExceptionHandler() throws Exception {
        Mockito.when((Object)this.mockTransactionConfig.getAction()).thenReturn((Object)1);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate(this.mockTransactionConfig);
        ((TestTransaction)Mockito.doAnswer(invocationOnMock -> {
            TransactionCoordination.getInstance().unbindTransaction((Transaction)this.mockTransaction);
            throw new RuntimeException();
        }).when((Object)this.mockTransaction)).commit();
        this.configureCatchExceptionListenerCall();
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(this.mockEvent));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)e.getEvent(), (Matcher)Is.is((Object)this.mockEvent));
        }
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction)).commit();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockMessagingExceptionHandler)).handleException((MessagingException)((Object)Matchers.any(MessagingException.class)), (Event)Matchers.eq((Object)this.mockEvent));
    }

    @Override
    protected ExecutionTemplate createExecutionTemplate(TransactionConfig config) {
        return TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate((MuleContext)this.mockMuleContext, (FlowConstruct)this.mockFlow, (TransactionConfig)config, (MessagingExceptionHandler)this.mockMessagingExceptionHandler);
    }

    private Event configureExceptionListenerCall() {
        Event mockResultEvent = (Event)Mockito.mock(Event.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)mockResultEvent.getError()).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockMessagingException.getEvent()).thenReturn((Object)this.mockEvent).thenReturn((Object)mockResultEvent);
        Mockito.when((Object)this.mockEvent.getError()).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockMessagingExceptionHandler.handleException(this.mockMessagingException, this.mockEvent)).thenAnswer(invocationOnMock -> {
            ErrorHandler errorHandler = new ErrorHandlerFactory().createDefault();
            Mockito.when((Object)this.mockMuleContext.getNotificationManager()).thenReturn(Mockito.mock(ServerNotificationManager.class));
            Mockito.when((Object)this.mockMuleContext.getRegistry()).thenReturn(Mockito.mock(MuleRegistry.class));
            errorHandler.setMuleContext(this.mockMuleContext);
            errorHandler.setFlowConstruct(this.mockFlow);
            errorHandler.handleException((MessagingException)((Object)((Object)invocationOnMock.getArguments()[0])), (Event)invocationOnMock.getArguments()[1]);
            return mockResultEvent;
        });
        return mockResultEvent;
    }

    private Event configureCatchExceptionListenerCall() {
        Event mockResultEvent = (Event)Mockito.mock(Event.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)this.mockMessagingException.getEvent()).thenReturn((Object)this.mockEvent).thenReturn((Object)mockResultEvent);
        Mockito.when((Object)this.mockEvent.getError()).thenReturn(Optional.empty());
        Mockito.when((Object)mockResultEvent.getError()).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockMessagingExceptionHandler.handleException(this.mockMessagingException, this.mockEvent)).thenAnswer(invocationOnMock -> {
            OnErrorContinueHandler exceptionStrategy = new OnErrorContinueHandler();
            exceptionStrategy.setMuleContext(this.mockMuleContext);
            exceptionStrategy.setFlowConstruct(this.mockFlow);
            Mockito.when((Object)this.mockMuleContext.getNotificationManager()).thenReturn(Mockito.mock(ServerNotificationManager.class));
            Mockito.when((Object)this.mockMuleContext.getRegistry()).thenReturn(Mockito.mock(MuleRegistry.class));
            exceptionStrategy.handleException((MessagingException)((Object)((Object)invocationOnMock.getArguments()[0])), (Event)invocationOnMock.getArguments()[1]);
            return mockResultEvent;
        });
        return mockResultEvent;
    }

    protected ExecutionCallback<Event> getFailureTransactionCallback() throws Exception {
        return TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException);
    }

    private MuleTransactionConfig createAlwaysBeginXaTransaction() throws TransactionException {
        return this.createTransactionConfig(true);
    }

    private MuleTransactionConfig createTransactionConfig(boolean isXa) throws TransactionException {
        this.mockTransaction.setXA(isXa);
        return new MuleTransactionConfig(1);
    }
}

