/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.expression;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.expression.ExpressionConfig;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ExpressionConfigTestCase
extends AbstractMuleContextTestCase {
    private MuleExpressionLanguage expressionManager;

    @Before
    public void setup() throws InitialisationException {
        this.expressionManager = muleContext.getExpressionManager();
    }

    @Test
    public void testExpressionLanguageExpression() throws Exception {
        ExpressionConfig config = new ExpressionConfig("message.inboundProperty['foo']=='bar'", "$[", "]");
        Assert.assertEquals((Object)"$[message.inboundProperty['foo']=='bar']", (Object)config.getFullExpression());
        config = new ExpressionConfig();
        config.parse("#[message.inboundAttachment['baz']]");
        Assert.assertEquals((Object)"message.inboundAttachment['baz']", (Object)config.getExpression());
    }

    @Test
    public void testELExpression() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("message.payload");
        Assert.assertEquals((Object)"message.payload", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[message.payload]", (Object)expressionConfig.getFullExpression());
    }

    @Test
    public void testELExpressionWithBrackets() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("#[message.payload]");
        Assert.assertEquals((Object)"message.payload", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[message.payload]", (Object)expressionConfig.getFullExpression());
    }

    @Test
    public void testELExpressionWithTenaryIf() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("1==1?true:false");
        Assert.assertEquals((Object)"1==1?true:false", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[1==1?true:false]", (Object)expressionConfig.getFullExpression());
    }

    @Test
    public void testELExpressionWithForeach() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("for(a:[1,2,3){'1'}");
        Assert.assertEquals((Object)"for(a:[1,2,3){'1'}", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[for(a:[1,2,3){'1'}]", (Object)expressionConfig.getFullExpression());
    }

    @Test
    public void testELExpressionWithColonInString() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("'This is a message : msg'");
        Assert.assertEquals((Object)"'This is a message : msg'", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#['This is a message : msg']", (Object)expressionConfig.getFullExpression());
    }
}

