/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.interceptor;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.component.AbstractComponent;
import org.mule.runtime.core.interceptor.AbstractEnvelopeInterceptor;
import org.mule.runtime.core.interceptor.InterceptorStack;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.management.stats.ProcessingTime;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptorTestCase
extends AbstractMuleContextTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterceptorTestCase.class);
    private final String BEFORE = "Before";
    private final String AFTER = "After";
    private final String COMPONENT = "component";
    private final String INTERCEPTOR_ONE = "inteceptor1";
    private final String INTERCEPTOR_TWO = "inteceptor2";
    private final String INTERCEPTOR_THREE = "inteceptor3";
    private final String SINGLE_INTERCEPTOR_RESULT = "inteceptor1Beforecomponentinteceptor1After";
    private final String MULTIPLE_INTERCEPTOR_RESULT = "inteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1After";
    private Flow flow;

    @Test
    public void testSingleInterceptor() throws Exception {
        Flow flow = this.createUninitializedFlow();
        TestComponent component = (TestComponent)((Object)flow.getMessageProcessors().get(0));
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        component.setInterceptors(interceptors);
        flow.initialise();
        flow.start();
        Event result = component.process(Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"")).build());
        Assert.assertEquals((Object)"inteceptor1Beforecomponentinteceptor1After", (Object)result.getMessageAsString(muleContext));
    }

    @Test
    public void testMultipleInterceptor() throws Exception {
        Flow flow = this.createUninitializedFlow();
        TestComponent component = (TestComponent)((Object)flow.getMessageProcessors().get(0));
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        interceptors.add(new TestInterceptor("inteceptor2"));
        interceptors.add(new TestInterceptor("inteceptor3"));
        component.setInterceptors(interceptors);
        flow.initialise();
        flow.start();
        Event result = component.process(Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"")).build());
        Assert.assertEquals((Object)"inteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1After", (Object)result.getMessageAsString(muleContext));
    }

    @Test
    public void testSingleInterceptorStack() throws Exception {
        Flow flow = this.createUninitializedFlow();
        TestComponent component = (TestComponent)((Object)flow.getMessageProcessors().get(0));
        ArrayList<InterceptorStack> interceptors = new ArrayList<InterceptorStack>();
        ArrayList<TestInterceptor> stackInterceptors = new ArrayList<TestInterceptor>();
        stackInterceptors.add(new TestInterceptor("inteceptor1"));
        interceptors.add(new InterceptorStack(stackInterceptors));
        component.setInterceptors(interceptors);
        flow.initialise();
        flow.start();
        Event result = component.process(Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"")).build());
        Assert.assertEquals((Object)"inteceptor1Beforecomponentinteceptor1After", (Object)result.getMessageAsString(muleContext));
    }

    @Test
    public void testMultipleInterceptorStack() throws Exception {
        Flow flow = this.createUninitializedFlow();
        TestComponent component = (TestComponent)((Object)flow.getMessageProcessors().get(0));
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        ArrayList<TestInterceptor> stackInterceptors = new ArrayList<TestInterceptor>();
        stackInterceptors.add(new TestInterceptor("inteceptor2"));
        stackInterceptors.add(new TestInterceptor("inteceptor3"));
        interceptors.add((TestInterceptor)new InterceptorStack(stackInterceptors));
        component.setInterceptors(interceptors);
        flow.initialise();
        flow.start();
        Event result = this.process((Processor)component, Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"")).build());
        Assert.assertEquals((Object)"inteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1After", (Object)result.getMessageAsString(muleContext));
    }

    @Test
    public void testMultipleInterceptorStack2() throws Exception {
        Flow flow = this.createUninitializedFlow();
        TestComponent component = (TestComponent)((Object)flow.getMessageProcessors().get(0));
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        interceptors.add(new TestInterceptor("inteceptor2"));
        interceptors.add(new TestInterceptor("inteceptor3"));
        ArrayList<TestInterceptor> stackInterceptors = new ArrayList<TestInterceptor>();
        stackInterceptors.add(new TestInterceptor("inteceptor1"));
        stackInterceptors.add(new TestInterceptor("inteceptor2"));
        stackInterceptors.add(new TestInterceptor("inteceptor3"));
        interceptors.add((TestInterceptor)new InterceptorStack(stackInterceptors));
        component.setInterceptors(interceptors);
        flow.initialise();
        flow.start();
        Event result = this.process((Processor)component, Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"")).build());
        Assert.assertEquals((Object)"inteceptor1Beforeinteceptor2Beforeinteceptor3Beforeinteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1Afterinteceptor3Afterinteceptor2Afterinteceptor1After", (Object)result.getMessageAsString(muleContext));
    }

    protected Flow createUninitializedFlow() throws Exception {
        TestComponent component = new TestComponent();
        this.flow = Flow.builder((String)"name", (MuleContext)muleContext).messageProcessors(Collections.singletonList(component)).build();
        return this.flow;
    }

    @After
    public void after() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.flow);
        LifecycleUtils.disposeIfNeeded((Object)this.flow, (Logger)LOGGER);
    }

    class TestComponent
    extends AbstractComponent {
        TestComponent() {
        }

        protected Object doInvoke(Event event, Event.Builder eventBuilder) throws Exception {
            return event.getMessageAsString(this.muleContext) + "component";
        }
    }

    class TestInterceptor
    extends AbstractEnvelopeInterceptor {
        private String name;

        public TestInterceptor(String name) {
            this.name = name;
        }

        public Event after(Event event) {
            try {
                event = Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)(InterceptorTestCase.this.getPayloadAsString(event.getMessage()) + this.name + "After")).build()).build();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            return event;
        }

        public Event before(Event event) {
            try {
                event = Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)(InterceptorTestCase.this.getPayloadAsString(event.getMessage()) + this.name + "Before")).build()).build();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            return event;
        }

        public Event last(Event event, ProcessingTime time, long startTime, boolean exceptionWasThrown) throws MuleException {
            return event;
        }
    }
}

