/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultConnectionManagerTestCase
extends AbstractMuleTestCase {
    private Apple config = new Apple();
    private Banana connection = new Banana();
    private CachedConnectionProvider<Banana> connectionProvider;
    private ConnectionProvider<Banana> testeableConnectionProvider;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    private DefaultConnectionManager connectionManager;

    @Before
    public void before() throws Exception {
        this.connectionProvider = this.mockConnectionProvider(CachedConnectionProvider.class);
        this.testeableConnectionProvider = this.mockConnectionProvider(ConnectionProvider.class);
        Mockito.when((Object)this.muleContext.getRegistry().get("_muleConnectionManager")).thenReturn((Object)this.connectionManager);
        this.connectionManager = new DefaultConnectionManager(this.muleContext);
    }

    private <T extends ConnectionProvider> T mockConnectionProvider(Class<T> type) throws Exception {
        ConnectionProvider connectionProvider = (ConnectionProvider)Mockito.mock(type);
        Mockito.when((Object)connectionProvider.connect()).thenReturn((Object)this.connection);
        Mockito.when((Object)connectionProvider.validate((Object)this.connection)).thenReturn((Object)ConnectionValidationResult.success());
        return (T)connectionProvider;
    }

    @Test
    public void getConnection() throws Exception {
        this.connectionManager.bind((Object)this.config, this.connectionProvider);
        ConnectionHandler connectionHandler = this.connectionManager.getConnection((Object)this.config);
        Assert.assertThat((Object)connectionHandler.getConnection(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.connection)));
    }

    @Test(expected=ConnectionException.class)
    public void assertUnboundedConnection() throws Exception {
        this.connectionManager.getConnection((Object)this.config);
    }

    @Test
    public void hasBinding() throws Exception {
        this.assertBound(false);
        this.connectionManager.bind((Object)this.config, this.connectionProvider);
        this.assertBound(true);
        this.connectionManager.unbind((Object)this.config);
        this.assertBound(false);
    }

    private void assertBound(boolean bound) {
        Assert.assertThat((Object)this.connectionManager.hasBinding((Object)this.config), (Matcher)CoreMatchers.is((Object)bound));
    }

    @Test
    public void stop() throws Exception {
        this.getConnection();
        this.connectionManager.stop();
        this.verifyDisconnect();
    }

    @Test(expected=ConnectionException.class)
    public void unbind() throws Exception {
        this.getConnection();
        this.connectionManager.unbind((Object)this.config);
        this.verifyDisconnect();
        this.assertUnboundedConnection();
    }

    private void verifyDisconnect() {
        ((CachedConnectionProvider)Mockito.verify(this.connectionProvider)).disconnect((Object)this.connection);
    }

    @Test(expected=IllegalStateException.class)
    public void bindWithStoppingMuleContext() throws Exception {
        Mockito.when((Object)this.muleContext.isStopped()).thenReturn((Object)true);
        this.connectionManager.bind((Object)this.config, this.connectionProvider);
    }

    @Test
    public void successfulConnectionProviderConnectivity() throws Exception {
        ConnectionValidationResult result = this.connectionManager.testConnectivity(this.testeableConnectionProvider);
        Assert.assertThat((Object)result.isValid(), (Matcher)CoreMatchers.is((Object)true));
        ((ConnectionProvider)Mockito.verify(this.testeableConnectionProvider)).connect();
        ((ConnectionProvider)Mockito.verify(this.testeableConnectionProvider)).validate((Object)this.connection);
        ((ConnectionProvider)Mockito.verify(this.testeableConnectionProvider)).disconnect((Object)this.connection);
    }

    @Test
    public void failingConnectionProviderConnectivity() throws Exception {
        ConnectionValidationResult validationResult = ConnectionValidationResult.failure((String)"oops", (Exception)new Exception());
        Mockito.when((Object)this.testeableConnectionProvider.validate((Object)this.connection)).thenReturn((Object)validationResult);
        ConnectionValidationResult result = this.connectionManager.testConnectivity(this.testeableConnectionProvider);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)validationResult)));
        ((ConnectionProvider)Mockito.verify(this.testeableConnectionProvider)).connect();
        ((ConnectionProvider)Mockito.verify(this.testeableConnectionProvider)).validate((Object)this.connection);
        ((ConnectionProvider)Mockito.verify(this.testeableConnectionProvider)).disconnect((Object)this.connection);
    }

    @Test
    public void poolingConnectionProviderConnectivity() throws Exception {
        this.testeableConnectionProvider = this.mockConnectionProvider(PoolingConnectionProvider.class);
        ConnectionValidationResult result = this.connectionManager.testConnectivity(this.testeableConnectionProvider);
        Assert.assertThat((Object)result.isValid(), (Matcher)CoreMatchers.is((Object)true));
        ((ConnectionProvider)Mockito.verify(this.testeableConnectionProvider)).connect();
        ((ConnectionProvider)Mockito.verify(this.testeableConnectionProvider, (VerificationMode)Mockito.atLeastOnce())).validate((Object)this.connection);
        ((ConnectionProvider)Mockito.verify(this.testeableConnectionProvider, (VerificationMode)Mockito.never())).disconnect((Object)this.connection);
    }

    @Test
    public void cachedConnectionProviderConnectivity() throws Exception {
        ConnectionValidationResult result = this.connectionManager.testConnectivity(this.connectionProvider);
        Assert.assertThat((Object)result.isValid(), (Matcher)CoreMatchers.is((Object)true));
        ((CachedConnectionProvider)Mockito.verify(this.connectionProvider)).connect();
        ((CachedConnectionProvider)Mockito.verify(this.connectionProvider, (VerificationMode)Mockito.atLeastOnce())).validate((Object)this.connection);
        ((CachedConnectionProvider)Mockito.verify(this.connectionProvider, (VerificationMode)Mockito.never())).disconnect((Object)this.connection);
    }
}

