/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.runtime.core.internal.connection.PassThroughConnectionHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Banana;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class PassThroughConnectionHandlerTestCase
extends AbstractMuleTestCase {
    @Mock
    private Banana connection;
    @Mock
    private ConnectionProvider<Banana> connectionProvider;
    private ConnectionHandlerAdapter<Banana> managedConnection;

    @Before
    public void before() {
        this.managedConnection = new PassThroughConnectionHandler((Object)this.connection, this.connectionProvider);
    }

    @Test
    public void getConnection() throws Exception {
        Assert.assertThat((Object)this.managedConnection.getConnection(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.connection)));
    }

    @Test
    public void alwaysReturnsSameConnection() throws Exception {
        this.getConnection();
        this.getConnection();
    }

    @Test
    public void release() throws Exception {
        this.doTwiceDisconnectOnce(() -> this.managedConnection.release());
    }

    @Test
    public void close() throws Exception {
        this.doTwiceDisconnectOnce(() -> {
            try {
                this.managedConnection.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void doTwiceDisconnectOnce(Runnable task) {
        task.run();
        task.run();
        ((ConnectionProvider)Mockito.verify(this.connectionProvider)).disconnect((Object)this.connection);
    }
}

