/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connectivity;

import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingStrategy;
import org.mule.runtime.core.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.runtime.core.api.exception.ObjectNotFoundException;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.internal.connectivity.DefaultConnectivityTestingService;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultConnectivityTestingServiceTestCase
extends AbstractMuleTestCase {
    private static final String TEST_IDENTIFIER = "testIdentifier";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private ServiceRegistry mockServiceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private ConnectivityTestingStrategy mockConnectivityTestingStrategy = (ConnectivityTestingStrategy)Mockito.mock(ConnectivityTestingStrategy.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private DefaultConnectivityTestingService connectivityTestingService;
    private AnnotatedObject fakeConnectivityTestingObject = (AnnotatedObject)Mockito.mock(AnnotatedObject.class);

    @Before
    public void createConnectivityService() throws InitialisationException {
        this.connectivityTestingService = new DefaultConnectivityTestingService();
        this.connectivityTestingService.setServiceRegistry(this.mockServiceRegistry);
        this.connectivityTestingService.setMuleContext(this.mockMuleContext);
        Mockito.when((Object)this.mockMuleContext.getConfigurationComponentLocator().find((Location)Matchers.any(Location.class))).thenReturn(Optional.of(this.fakeConnectivityTestingObject));
        Mockito.when((Object)this.mockServiceRegistry.lookupProviders((Class)Matchers.any(), (ClassLoader)Matchers.any())).thenReturn(Arrays.asList(this.mockConnectivityTestingStrategy));
        Mockito.when((Object)this.mockConnectivityTestingStrategy.accepts((Object)this.fakeConnectivityTestingObject)).thenReturn((Object)true);
        Mockito.when((Object)this.mockMuleContext.getRegistry().get(TEST_IDENTIFIER)).thenReturn((Object)this.fakeConnectivityTestingObject);
        this.connectivityTestingService.initialise();
    }

    @Test
    public void testConnectionThrowsException() throws Exception {
        RuntimeException exception = new RuntimeException();
        Mockito.when((Object)this.mockConnectivityTestingStrategy.testConnectivity((Object)this.fakeConnectivityTestingObject)).thenThrow(new Throwable[]{exception});
        ConnectionValidationResult validationResult = this.connectivityTestingService.testConnection(Location.builder().globalName(TEST_IDENTIFIER).build());
        Assert.assertThat((Object)validationResult.isValid(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)validationResult.getException(), (Matcher)Is.is((Object)exception));
    }

    @Test
    public void testConnection() {
        Mockito.when((Object)this.mockConnectivityTestingStrategy.testConnectivity((Object)this.fakeConnectivityTestingObject)).thenReturn((Object)ConnectionValidationResult.success());
        ConnectionValidationResult validationResult = this.connectivityTestingService.testConnection(Location.builder().globalName(TEST_IDENTIFIER).build());
        Assert.assertThat((Object)validationResult.isValid(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testObjectNotSupported() {
        Mockito.reset((Object[])new ConnectivityTestingStrategy[]{this.mockConnectivityTestingStrategy});
        Mockito.when((Object)this.mockConnectivityTestingStrategy.accepts((Object)this.fakeConnectivityTestingObject)).thenReturn((Object)false);
        this.expectedException.expect(UnsupportedConnectivityTestingObjectException.class);
        this.connectivityTestingService.testConnection(Location.builder().globalName(TEST_IDENTIFIER).build());
    }

    @Test
    public void nonExistentConnectivityTestingObject() {
        Mockito.reset((Object[])new MuleContext[]{this.mockMuleContext});
        Mockito.when((Object)this.mockMuleContext.getConfigurationComponentLocator().find((Location)Matchers.any(Location.class))).thenReturn(Optional.empty());
        this.expectedException.expect(ObjectNotFoundException.class);
        this.connectivityTestingService.testConnection(Location.builder().globalName(TEST_IDENTIFIER).build());
    }
}

