/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultFlowBuilderTestCase
extends AbstractMuleTestCase {
    public static final String FLOW_NAME = "flowName";
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private DefaultFlowBuilder flowBuilder = new DefaultFlowBuilder("flowName", this.muleContext);
    private ProcessingStrategyFactory defaultProcessingStrategyFactory = (ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        Mockito.when((Object)muleConfiguration.getDefaultProcessingStrategyFactory()).thenReturn((Object)this.defaultProcessingStrategyFactory);
    }

    @Test
    public void buildsSimpleFlow() throws Exception {
        Flow flow = this.flowBuilder.build();
        MatcherAssert.assertThat((Object)flow.getName(), (Matcher)Matchers.equalTo((Object)FLOW_NAME));
        MatcherAssert.assertThat((Object)flow.getMuleContext(), (Matcher)Matchers.is((Object)this.muleContext));
        MatcherAssert.assertThat((Object)flow.getMessageProcessors(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)flow.getMessageSource(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)flow.getExceptionListener(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)flow.getProcessingStrategyFactory(), (Matcher)Matchers.is((Object)this.defaultProcessingStrategyFactory));
    }

    @Test
    public void buildsFullFlow() throws Exception {
        Processor processor1 = (Processor)Mockito.mock(Processor.class);
        Processor processor2 = (Processor)Mockito.mock(Processor.class);
        ArrayList<Processor> messageProcessors = new ArrayList<Processor>();
        messageProcessors.add(processor1);
        messageProcessors.add(processor2);
        MessageSource messageSource = (MessageSource)Mockito.mock(MessageSource.class);
        ProcessingStrategyFactory processingStrategyFactory = (ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class);
        MessagingExceptionHandler exceptionListener = (MessagingExceptionHandler)Mockito.mock(MessagingExceptionHandler.class);
        Flow flow = this.flowBuilder.messageProcessors(messageProcessors).messageSource(messageSource).processingStrategyFactory(processingStrategyFactory).messagingExceptionHandler(exceptionListener).build();
        MatcherAssert.assertThat((Object)flow.getName(), (Matcher)Matchers.equalTo((Object)FLOW_NAME));
        MatcherAssert.assertThat((Object)flow.getMuleContext(), (Matcher)Matchers.is((Object)this.muleContext));
        MatcherAssert.assertThat((Object)flow.getMessageProcessors(), (Matcher)Matchers.contains((Object[])new Processor[]{processor1, processor2}));
        MatcherAssert.assertThat((Object)flow.getMessageSource(), (Matcher)Matchers.is((Object)messageSource));
        MatcherAssert.assertThat((Object)flow.getExceptionListener(), (Matcher)Matchers.is((Object)exceptionListener));
        MatcherAssert.assertThat((Object)flow.getProcessingStrategyFactory(), (Matcher)Matchers.is((Object)processingStrategyFactory));
    }

    @Test
    public void cannotBuildFlowTwice() throws Exception {
        this.flowBuilder.build();
        this.expectedException.expect(IllegalStateException.class);
        this.flowBuilder.build();
    }

    @Test
    public void cannotChangeMessageSourceAfterFlowBuilt() throws Exception {
        this.flowBuilder.build();
        this.expectedException.expect(IllegalStateException.class);
        this.flowBuilder.messageSource((MessageSource)Mockito.mock(MessageSource.class));
    }

    @Test
    public void cannotChangeMessageProcessorsAfterFlowBuilt() throws Exception {
        this.flowBuilder.build();
        this.expectedException.expect(IllegalStateException.class);
        this.flowBuilder.messageProcessors(new ArrayList());
    }

    @Test
    public void cannotChangeExceptionListenerAfterFlowBuilt() throws Exception {
        this.flowBuilder.build();
        this.expectedException.expect(IllegalStateException.class);
        this.flowBuilder.messagingExceptionHandler((MessagingExceptionHandler)Mockito.mock(MessagingExceptionHandler.class));
    }

    @Test
    public void cannotChangeProcessingStrategyFactoryAfterFlowBuilt() throws Exception {
        this.flowBuilder.build();
        this.expectedException.expect(IllegalStateException.class);
        this.flowBuilder.processingStrategyFactory((ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class));
    }
}

