/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.keygenerator;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.internal.keygenerator.ExpressionMuleEventKeyGenerator;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ExpressionKeyGeneratorTestCase
extends AbstractMuleTestCase {
    private static final String RESOLVED_KEY = "KEY";
    private static final String SINGLE_EXPRESSION = "#[expression]";
    private ExpressionMuleEventKeyGenerator keyGenerator;
    private InternalMessage message;
    private MuleContext muleContext;
    private Event event;
    private ExtendedExpressionManager expressionManager;

    @Before
    public void setUp() throws Exception {
        this.expressionManager = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        ((MuleContext)Mockito.doReturn((Object)this.expressionManager).when((Object)this.muleContext)).getExpressionManager();
        this.message = (InternalMessage)Mockito.mock(InternalMessage.class);
        this.event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        this.keyGenerator = new ExpressionMuleEventKeyGenerator();
    }

    @Test
    public void testGeneratesSerializableKey() throws Exception {
        this.keyGenerator.setExpression(SINGLE_EXPRESSION);
        this.keyGenerator.setMuleContext(this.muleContext);
        TypedValue typedValue = new TypedValue((Object)RESOLVED_KEY, DataType.STRING);
        Mockito.when((Object)this.expressionManager.evaluate(SINGLE_EXPRESSION, this.event)).thenReturn((Object)typedValue);
        Serializable key = this.keyGenerator.generateKey(this.event);
        Assert.assertEquals((Object)RESOLVED_KEY, (Object)key);
    }

    @Test
    public void resolvesCompositeExpression() throws Exception {
        this.keyGenerator.setExpression("#[expression]#[expression]");
        this.keyGenerator.setMuleContext(this.muleContext);
        Mockito.when((Object)this.expressionManager.parse("#[expression]#[expression]", this.event, null)).thenReturn((Object)RESOLVED_KEY);
        Serializable key = this.keyGenerator.generateKey(this.event);
        MatcherAssert.assertThat((Object)key, (Matcher)Matchers.equalTo((Object)RESOLVED_KEY));
    }

    @Test(expected=NotSerializableException.class)
    public void testThrowsExceptionOnNonSerializableKey() throws Exception {
        this.keyGenerator.setExpression(SINGLE_EXPRESSION);
        this.keyGenerator.setMuleContext(this.muleContext);
        Mockito.when((Object)this.expressionManager.evaluate(SINGLE_EXPRESSION, this.event)).thenReturn((Object)new TypedValue(null, DataType.OBJECT));
        this.keyGenerator.generateKey(this.event);
    }
}

