/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.keygenerator;

import java.io.NotSerializableException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.internal.keygenerator.SHA256MuleEventKeyGenerator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class SHA256MuleEventKeyGeneratorTestCase
extends AbstractMuleContextTestCase {
    private static final String TEST_INPUT = "TEST";
    private static final String TEST_HASH = "94ee059335e587e501cc4bf90613e0814f00a7b08bc7c648fd865a2af6a22cc2";
    private SHA256MuleEventKeyGenerator keyGenerator = new SHA256MuleEventKeyGenerator();

    @Before
    public void before() {
        this.keyGenerator.setMuleContext(muleContext);
    }

    @Test
    public void generatesKeyApplyingSHA256ToPayload() throws Exception {
        String key = (String)((Object)this.keyGenerator.generateKey(SHA256MuleEventKeyGeneratorTestCase.eventBuilder().message(Message.of((Object)TEST_INPUT)).build()));
        Assert.assertEquals((Object)TEST_HASH, (Object)key);
    }

    @Test(expected=NotSerializableException.class)
    public void failsToGenerateKeyWhenCannotReadPayload() throws Exception {
        Event event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)event.getMessageAsBytes(muleContext)).thenThrow(new Throwable[]{new DefaultMuleException("Fail")});
        this.keyGenerator.generateKey(event);
    }
}

