/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.registry.ResolverException;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.registry.TypeBasedTransformerResolver;
import org.mule.runtime.core.transformer.builder.MockConverterBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class TypeBasedTransformerResolverTestCase
extends AbstractMuleTestCase {
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
    private DataType dataTypeA = DataType.fromType(A.class);
    private DataType dataTypeB = DataType.fromType(B.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.muleConfiguration);
    }

    @Test
    public void doesNotFailIfCannotResolveType() throws ResolverException, TransformerException {
        MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)muleRegistry);
        ArrayList transformers = new ArrayList();
        Mockito.when((Object)muleRegistry.lookupTransformers(this.dataTypeA, this.dataTypeB)).thenReturn(transformers);
        TypeBasedTransformerResolver resolver = new TypeBasedTransformerResolver();
        resolver.setMuleContext(this.muleContext);
        Transformer resolvedTransformer = resolver.resolve(this.dataTypeA, this.dataTypeB);
        Assert.assertNull((Object)resolvedTransformer);
    }

    @Test
    public void resolvesTypeWithOneMatchingTransformer() throws ResolverException, TransformerException {
        MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)muleRegistry);
        Converter aToBConverter = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(this.dataTypeA)).to(this.dataTypeB)).build();
        ArrayList<Converter> transformers = new ArrayList<Converter>();
        transformers.add(aToBConverter);
        Mockito.when((Object)muleRegistry.lookupTransformers(this.dataTypeA, this.dataTypeB)).thenReturn(transformers);
        TypeBasedTransformerResolver resolver = new TypeBasedTransformerResolver();
        resolver.setMuleContext(this.muleContext);
        Transformer resolvedTransformer = resolver.resolve(this.dataTypeA, this.dataTypeB);
        Assert.assertEquals((Object)aToBConverter, (Object)resolvedTransformer);
    }

    @Test
    public void resolvesTypeWithTwoMatchingTransformer() throws ResolverException, TransformerException {
        MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)muleRegistry);
        Converter aToBConverter = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(this.dataTypeA)).to(this.dataTypeB)).weighting(1)).build();
        Converter betterAToBConverter = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(this.dataTypeA)).to(this.dataTypeB)).weighting(2)).build();
        ArrayList<Converter> transformers = new ArrayList<Converter>();
        transformers.add(aToBConverter);
        transformers.add(betterAToBConverter);
        Mockito.when((Object)muleRegistry.lookupTransformers(this.dataTypeA, this.dataTypeB)).thenReturn(transformers);
        TypeBasedTransformerResolver resolver = new TypeBasedTransformerResolver();
        resolver.setMuleContext(this.muleContext);
        Transformer resolvedTransformer = resolver.resolve(this.dataTypeA, this.dataTypeB);
        Assert.assertEquals((Object)betterAToBConverter, (Object)resolvedTransformer);
    }

    @Test
    public void fallbacksNotRegistered() throws Exception {
        TypeBasedTransformerResolver resolver = new TypeBasedTransformerResolver();
        resolver.setMuleContext(this.muleContext);
        resolver.initialise();
        ((MuleContext)Mockito.verify((Object)this.muleContext, (VerificationMode)Mockito.never())).getRegistry();
    }

    public static class B {
    }

    public static class A {
    }
}

