/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.pool;

import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.internal.pool.DefaultLifecycleEnabledObjectPool;
import org.mule.runtime.core.internal.util.pool.AbstractPoolingTestCase;
import org.mule.runtime.core.object.PrototypeObjectFactory;
import org.mule.tck.testmodels.fruit.WaterMelon;

public class DefaultLifecycleEnabledObjectPoolTestCase
extends AbstractPoolingTestCase {
    @Test
    public void testPoolStart() throws Exception {
        DefaultLifecycleEnabledObjectPool pool = this.createObjectPool();
        WaterMelon borrowed = this.borrow(pool);
        Assert.assertEquals((Object)"void", (Object)borrowed.getState());
        pool.start();
        Assert.assertEquals((Object)"started", (Object)borrowed.getState());
    }

    @Test
    public void testPoolStop() throws Exception {
        DefaultLifecycleEnabledObjectPool pool = this.createObjectPool();
        pool.start();
        WaterMelon borrowed = this.borrow(pool);
        pool.stop();
        Assert.assertEquals((Object)"stopped", (Object)borrowed.getState());
    }

    private DefaultLifecycleEnabledObjectPool createObjectPool() throws Exception {
        PoolingProfile poolingProfile = this.createDefaultPoolingProfile();
        ObjectFactory objectFactory = this.createDefaultObjectFactory();
        DefaultLifecycleEnabledObjectPool pool = new DefaultLifecycleEnabledObjectPool(objectFactory, poolingProfile, muleContext);
        pool.initialise();
        return pool;
    }

    private ObjectFactory createDefaultObjectFactory() {
        PrototypeObjectFactory factory = new PrototypeObjectFactory(WaterMelon.class);
        return factory;
    }

    private WaterMelon borrow(DefaultLifecycleEnabledObjectPool pool) throws Exception {
        return (WaterMelon)pool.borrowObject();
    }
}

