/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.management;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.context.notification.CustomNotificationListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;
import org.mule.runtime.core.context.notification.CustomNotification;
import org.mule.runtime.core.management.DummyListener;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ServerNotificationsTestCase
extends AbstractMuleContextTestCase
implements MuleContextNotificationListener {
    private final AtomicBoolean managerStopped = new AtomicBoolean(false);
    private final AtomicInteger managerStoppedEvents = new AtomicInteger(0);
    private final AtomicInteger componentStartedCount = new AtomicInteger(0);
    private final AtomicInteger customNotificationCount = new AtomicInteger(0);

    public ServerNotificationsTestCase() {
        this.setStartContext(true);
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        this.managerStopped.set(true);
        this.managerStoppedEvents.set(0);
    }

    @Test
    public void testStandardNotifications() throws Exception {
        muleContext.registerListener((ServerNotificationListener)this);
        muleContext.stop();
        Assert.assertTrue((boolean)this.managerStopped.get());
    }

    @Test
    public void testMultipleRegistrations() throws Exception {
        muleContext.registerListener((ServerNotificationListener)this);
        muleContext.registerListener((ServerNotificationListener)this);
        muleContext.stop();
        Assert.assertTrue((boolean)this.managerStopped.get());
        Assert.assertEquals((long)1L, (long)this.managerStoppedEvents.get());
    }

    @Test
    public void testUnregistering() throws Exception {
        muleContext.registerListener((ServerNotificationListener)this);
        muleContext.unregisterListener((ServerNotificationListener)this);
        muleContext.stop();
        Assert.assertFalse((boolean)this.managerStopped.get());
    }

    @Test
    public void testMismatchingUnregistrations() throws Exception {
        muleContext.registerListener((ServerNotificationListener)this);
        DummyListener dummy = new DummyListener();
        muleContext.registerListener((ServerNotificationListener)dummy);
        muleContext.registerListener((ServerNotificationListener)dummy);
        muleContext.unregisterListener((ServerNotificationListener)dummy);
        muleContext.stop();
        Assert.assertTrue((boolean)this.managerStopped.get());
        Assert.assertEquals((long)1L, (long)this.managerStoppedEvents.get());
    }

    @Test
    public void testCustomNotifications() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        muleContext.registerListener((ServerNotificationListener)((DummyNotificationListener)notification -> {
            if (notification.getAction() == -999999) {
                this.customNotificationCount.incrementAndGet();
                Assert.assertEquals((Object)"hello", (Object)notification.getSource());
                latch.countDown();
            }
        }));
        muleContext.fireNotification((ServerNotification)new DummyNotification("hello", -999999));
        muleContext.fireNotification((ServerNotification)new DummyNotification("hello", -999999));
        latch.await(2000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)2L, (long)this.customNotificationCount.get());
    }

    @Test
    public void testCustomNotificationsWithWildcardSubscription() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        muleContext.registerListener((ServerNotificationListener)((DummyNotificationListener)notification -> {
            if (notification.getAction() == -999999) {
                this.customNotificationCount.incrementAndGet();
                Assert.assertFalse((boolean)"e quick bro".equals(notification.getResourceIdentifier()));
                latch.countDown();
            }
        }), "* quick brown*");
        muleContext.fireNotification((ServerNotification)new DummyNotification("the quick brown fox jumped over the lazy dog", -999999));
        muleContext.fireNotification((ServerNotification)new DummyNotification("e quick bro", -999999));
        muleContext.fireNotification((ServerNotification)new DummyNotification(" quick brown", -999999));
        latch.await(20000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)2L, (long)this.customNotificationCount.get());
    }

    public boolean isBlocking() {
        return false;
    }

    public void onNotification(ServerNotification notification) {
        if (notification.getAction() == 106) {
            this.managerStopped.set(true);
            this.managerStoppedEvents.incrementAndGet();
        }
    }

    public class DummyNotification
    extends CustomNotification {
        private static final long serialVersionUID = -1117307108932589331L;
        public static final int EVENT_RECEIVED = -999999;

        public DummyNotification(String message, int action) {
            super((Object)message, action);
            this.resourceIdentifier = message;
        }
    }

    public static interface DummyNotificationListener
    extends CustomNotificationListener {
    }
}

