/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.activation.DataHandler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.internal.message.DefaultMessageBuilder;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.metadata.DefaultCollectionDataType;
import org.mule.runtime.core.message.BaseAttributes;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultMuleMessageBuilderTestCase
extends AbstractMuleTestCase {
    private static final String NEW_PAYLOAD = "new payload";
    private static final Attributes TEST_ATTR = NullAttributes.NULL_ATTRIBUTES;
    private static final Attributes TEST_ATTR_2 = new BaseAttributes(){};
    private static final String PROPERTY_KEY = "propertyKey";
    private static final Serializable PROPERTY_VALUE = "propertyValue";
    private static final MediaType HTML_STRING_UTF8 = MediaType.HTML.withCharset(StandardCharsets.UTF_8);

    @Test
    public void createNewAPIMessageViaMessageInterface() {
        Message message = Message.builder().payload((Object)"test").mediaType(HTML_STRING_UTF8).attributes((Object)TEST_ATTR).build();
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(String.class));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)HTML_STRING_UTF8));
        MatcherAssert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Object)TEST_ATTR));
    }

    @Test
    public void createAPIMessageViaMessageInterfaceFromCopy() {
        Message message = Message.builder().payload((Object)"test").attributes((Object)TEST_ATTR).build();
        Message messageCopy = Message.builder((Message)message).payload((Object)true).attributes((Object)TEST_ATTR_2).build();
        MatcherAssert.assertThat((Object)messageCopy.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)messageCopy.getPayload().getDataType(), (Matcher)CoreMatchers.is((Object)DataType.BOOLEAN));
        MatcherAssert.assertThat((Object)messageCopy.getAttributes().getValue(), (Matcher)CoreMatchers.is((Object)TEST_ATTR_2));
    }

    @Test
    public void createNewMessageViaMessageInterface() {
        Message message = Message.builder().payload((Object)"test").attributes((Object)TEST_ATTR).build();
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType(), (Matcher)CoreMatchers.is((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Object)TEST_ATTR));
    }

    @Test
    public void createNewMessageCollectionViaMessageInterface() {
        ArrayList<String> htmlStringList = new ArrayList<String>();
        htmlStringList.add("HTML1");
        htmlStringList.add("HTML2");
        htmlStringList.add("HTML3");
        InternalMessage message = InternalMessage.builder().collectionPayload(htmlStringList, String.class).itemMediaType(MediaType.HTML).attributes((Object)TEST_ATTR).build();
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is(htmlStringList));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(ArrayList.class));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.ANY));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType(), (Matcher)CoreMatchers.instanceOf(DefaultCollectionDataType.class));
        MatcherAssert.assertThat((Object)((DefaultCollectionDataType)message.getPayload().getDataType()).getItemDataType().getMediaType(), (Matcher)CoreMatchers.equalTo((Object)MediaType.HTML));
    }

    @Test
    public void createNewMessageCollectionViaMessageInterfaceCopy() {
        ArrayList<String> htmlStringList = new ArrayList<String>();
        htmlStringList.add("HTML1");
        htmlStringList.add("HTML2");
        htmlStringList.add("HTML3");
        InternalMessage message = InternalMessage.builder().collectionPayload(htmlStringList, String.class).itemMediaType(MediaType.HTML).attributes((Object)TEST_ATTR).build();
        InternalMessage copy = InternalMessage.builder((Message)message).build();
        MatcherAssert.assertThat((Object)copy.getPayload().getValue(), (Matcher)CoreMatchers.is(htmlStringList));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(ArrayList.class));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.ANY));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType(), (Matcher)CoreMatchers.instanceOf(DefaultCollectionDataType.class));
        MatcherAssert.assertThat((Object)((DefaultCollectionDataType)copy.getPayload().getDataType()).getItemDataType().getMediaType(), (Matcher)CoreMatchers.equalTo((Object)MediaType.HTML));
    }

    @Test
    public void createMessageViaMessageInterfaceFromCopy() {
        InternalMessage messageCopy = InternalMessage.builder((Message)this.createTestMessage()).payload((Object)true).attributes((Object)TEST_ATTR_2).build();
        MatcherAssert.assertThat((Object)messageCopy.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)messageCopy.getPayload().getDataType(), (Matcher)CoreMatchers.is((Object)DataType.BOOLEAN));
        MatcherAssert.assertThat((Object)messageCopy.getAttributes().getValue(), (Matcher)CoreMatchers.is((Object)TEST_ATTR_2));
    }

    @Test
    public void testOnlyPayload() {
        Message message = Message.of((Object)"test");
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"test"));
    }

    @Test
    public void messageAttributes() {
        this.assertTestMessage(this.createTestMessage());
    }

    @Test
    public void messageAttributesCopy() {
        this.assertTestMessage((Message)new DefaultMessageBuilder(this.createTestMessage()).build());
    }

    @Test
    public void inboundPropertyMap() {
        Map<String, Serializable> inboundProperties = Collections.singletonMap(PROPERTY_KEY, PROPERTY_VALUE);
        InternalMessage message = new DefaultMessageBuilder().payload((Object)"test").inboundProperties(inboundProperties).build();
        MatcherAssert.assertThat((Object)message.getInboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)message.getInboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)message.getInboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)message.getInboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void inboundPropertyMapCopy() {
        Map<String, Serializable> inboundProperties = Collections.singletonMap(PROPERTY_KEY, PROPERTY_VALUE);
        InternalMessage copy = new DefaultMessageBuilder((Message)new DefaultMessageBuilder().payload((Object)"test").inboundProperties(inboundProperties).build()).build();
        MatcherAssert.assertThat((Object)copy.getInboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)copy.getInboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)copy.getInboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)copy.getInboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void outboundPropertyMap() {
        Map<String, Serializable> outboundProperties = Collections.singletonMap(PROPERTY_KEY, PROPERTY_VALUE);
        InternalMessage message = new DefaultMessageBuilder().payload((Object)"test").outboundProperties(outboundProperties).build();
        MatcherAssert.assertThat((Object)message.getOutboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void outboundPropertyMapCopy() {
        Map<String, Serializable> outboundProperties = Collections.singletonMap(PROPERTY_KEY, PROPERTY_VALUE);
        InternalMessage copy = new DefaultMessageBuilder((Message)new DefaultMessageBuilder().payload((Object)"test").outboundProperties(outboundProperties).build()).build();
        MatcherAssert.assertThat((Object)copy.getOutboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)copy.getOutboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)copy.getOutboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)copy.getOutboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void inboundProperty() {
        InternalMessage message = new DefaultMessageBuilder().payload((Object)"test").addInboundProperty(PROPERTY_KEY, PROPERTY_VALUE).build();
        MatcherAssert.assertThat((Object)message.getInboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)message.getInboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)message.getInboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)message.getInboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void inboundPropertyDataType() {
        InternalMessage message = new DefaultMessageBuilder().payload((Object)"test").addInboundProperty(PROPERTY_KEY, PROPERTY_VALUE, DataType.HTML_STRING).build();
        MatcherAssert.assertThat((Object)message.getInboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)message.getInboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.HTML_STRING));
        MatcherAssert.assertThat((Object)message.getInboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)message.getInboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void outboundProperty() {
        InternalMessage message = new DefaultMessageBuilder().payload((Object)"test").addOutboundProperty(PROPERTY_KEY, PROPERTY_VALUE).build();
        MatcherAssert.assertThat((Object)message.getOutboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void outboundPropertyDataType() {
        InternalMessage message = new DefaultMessageBuilder().payload((Object)"test").addOutboundProperty(PROPERTY_KEY, PROPERTY_VALUE, DataType.HTML_STRING).build();
        MatcherAssert.assertThat((Object)message.getOutboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.HTML_STRING));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void nullPayload() {
        Message message = Message.of(null);
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(Object.class));
    }

    @Test
    public void mutatePayloadSameTypeConserveTypeAndMimeType() {
        Message message = this.createTestMessage();
        InternalMessage copy = new DefaultMessageBuilder(message).payload((Object)NEW_PAYLOAD).build();
        MatcherAssert.assertThat((Object)copy.getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)NEW_PAYLOAD));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(String.class));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.TEXT));
    }

    @Test
    public void mutatePayloadDifferentTypeUpdateTypeAndConserveMimeType() {
        InternalMessage copy = new DefaultMessageBuilder(this.createTestMessage()).payload((Object)1).build();
        MatcherAssert.assertThat((Object)copy.getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(Integer.class));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.TEXT));
    }

    @Test
    public void mutatePayloadDifferentTypeWithMediaTypeUpdateTypeAndConserveMimeType() {
        Long payload = new Long(1L);
        DataHandler dataHandler = new DataHandler((Object)payload, MediaType.XML.toString());
        InternalMessage copy = new DefaultMessageBuilder(this.createTestMessage()).payload((Object)dataHandler).build();
        MatcherAssert.assertThat((Object)copy.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)dataHandler));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(DataHandler.class));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.XML));
    }

    private Message createTestMessage() {
        return new DefaultMessageBuilder().payload((Object)"test").mediaType(MediaType.TEXT).attributes((Object)TEST_ATTR).build();
    }

    private void assertTestMessage(Message message) {
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType(), (Matcher)CoreMatchers.is((Object)DataType.TEXT_STRING));
        MatcherAssert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Object)TEST_ATTR));
    }
}

