/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.message.DefaultMultiPartPayload;
import org.mule.runtime.core.message.PartAttributes;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultMultiPartPayloadTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void stringAttachment() throws Exception {
        Message attachmentPart = Message.builder().payload((Object)"this is the attachment").mediaType(MediaType.TEXT).attributes((Object)new PartAttributes("attachment")).build();
        Message message = Message.builder().payload((Object)new DefaultMultiPartPayload(new Message[]{Message.builder().payload((Object)"test").attributes((Object)DefaultMultiPartPayload.BODY_ATTRIBUTES).build(), attachmentPart})).build();
        MultiPartPayload multiPartPayload = (MultiPartPayload)message.getPayload().getValue();
        Assert.assertThat((Object)multiPartPayload.getPartNames(), (Matcher)IsCollectionContaining.hasItem((Object)"attachment"));
        Assert.assertThat((Object)multiPartPayload.getPart("attachment"), (Matcher)CoreMatchers.sameInstance((Object)attachmentPart));
        Assert.assertThat(multiPartPayload.getNamedParts().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"attachment"), (Matcher)CoreMatchers.sameInstance((Object)attachmentPart)));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasKey((Object)"_body"));
    }

    @Test
    public void fromUrlAttachment() throws Exception {
        Message attachmentPart = IOUtils.toMuleMessagePart((String)"spi-props", (Object)IOUtils.getResourceAsUrl((String)"test-spi.properties", ((Object)((Object)this)).getClass()), (MediaType)MediaType.TEXT);
        Message message = Message.builder().payload((Object)new DefaultMultiPartPayload(new Message[]{Message.builder().payload((Object)"test").attributes((Object)DefaultMultiPartPayload.BODY_ATTRIBUTES).build(), attachmentPart})).build();
        MultiPartPayload multiPartPayload = (MultiPartPayload)message.getPayload().getValue();
        Assert.assertThat((Object)multiPartPayload.getParts(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)multiPartPayload.getPartNames(), (Matcher)IsCollectionContaining.hasItem((Object)"spi-props"));
        Assert.assertThat((Object)multiPartPayload.getPart("spi-props"), (Matcher)CoreMatchers.sameInstance((Object)attachmentPart));
        Assert.assertThat((Object)multiPartPayload.getPart("spi-props").getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.TEXT));
        Assert.assertThat(multiPartPayload.getNamedParts().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"spi-props"), (Matcher)CoreMatchers.sameInstance((Object)attachmentPart)));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasKey((Object)"_body"));
    }

    @Test
    public void xmlFromUrlAttachment() throws Exception {
        Message attachmentPart1 = IOUtils.toMuleMessagePart((String)"spi-props", (Object)IOUtils.getResourceAsUrl((String)"test-spi.properties", ((Object)((Object)this)).getClass()), (MediaType)MediaType.TEXT);
        Message attachmentPart2 = IOUtils.toMuleMessagePart((String)"dummy", (Object)IOUtils.getResourceAsUrl((String)"dummy.xml", ((Object)((Object)this)).getClass()), null);
        Message message = Message.builder().payload((Object)new DefaultMultiPartPayload(new Message[]{Message.builder().payload((Object)"test").attributes((Object)DefaultMultiPartPayload.BODY_ATTRIBUTES).build(), attachmentPart1, attachmentPart2})).build();
        MultiPartPayload multiPartPayload = (MultiPartPayload)message.getPayload().getValue();
        Assert.assertThat((Object)multiPartPayload.getParts(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)multiPartPayload.getPart("dummy").getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.APPLICATION_XML));
        Assert.assertThat(multiPartPayload.getNamedParts().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"spi-props"), (Matcher)CoreMatchers.sameInstance((Object)attachmentPart1)));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"dummy"), (Matcher)CoreMatchers.sameInstance((Object)attachmentPart2)));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasKey((Object)"_body"));
    }

    @Test
    public void withBody() throws Exception {
        Message attachmentPart = Message.builder().payload((Object)"this is the attachment").mediaType(MediaType.TEXT).attributes((Object)new PartAttributes("attachment")).build();
        Message bodyPart = Message.builder().payload((Object)"test").attributes((Object)DefaultMultiPartPayload.BODY_ATTRIBUTES).build();
        Message message = Message.of((Object)new DefaultMultiPartPayload(new Message[]{bodyPart, attachmentPart}));
        DefaultMultiPartPayload multiPartPayload = (DefaultMultiPartPayload)message.getPayload().getValue();
        Assert.assertThat((Object)multiPartPayload.hasBodyPart(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)multiPartPayload.getBodyPart(), (Matcher)CoreMatchers.sameInstance((Object)bodyPart));
        Assert.assertThat(multiPartPayload.getNamedParts().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"attachment"), (Matcher)CoreMatchers.sameInstance((Object)attachmentPart)));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasKey((Object)"_body"));
    }

    @Test
    public void withoutBody() throws Exception {
        Message attachmentPart1 = Message.builder().payload((Object)"this is the attachment1").mediaType(MediaType.TEXT).attributes((Object)new PartAttributes("attachment1")).build();
        Message attachmentPart2 = Message.builder().payload((Object)"this is the attachment2").mediaType(MediaType.TEXT).attributes((Object)new PartAttributes("attachment2")).build();
        Message message = Message.of((Object)new DefaultMultiPartPayload(new Message[]{attachmentPart1, attachmentPart2}));
        DefaultMultiPartPayload multiPartPayload = (DefaultMultiPartPayload)message.getPayload().getValue();
        Assert.assertThat((Object)multiPartPayload.hasBodyPart(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(multiPartPayload.getNamedParts().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"attachment1"), (Matcher)CoreMatchers.sameInstance((Object)attachmentPart1)));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"attachment2"), (Matcher)CoreMatchers.sameInstance((Object)attachmentPart2)));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)CoreMatchers.not((Matcher)IsMapContaining.hasKey((Object)"_body")));
    }

    @Test
    public void multiPartPayloadSerialization() throws Exception {
        Message attachmentPart = Message.builder().payload((Object)"this is the attachment").mediaType(MediaType.TEXT).attributes((Object)new PartAttributes("attachment")).build();
        Message message = Message.builder().payload((Object)new DefaultMultiPartPayload(new Message[]{Message.builder().payload((Object)"test").attributes((Object)DefaultMultiPartPayload.BODY_ATTRIBUTES).build(), attachmentPart})).build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        Event.setCurrentEvent((Event)DefaultMultiPartPayloadTestCase.eventBuilder().message(message).build());
        oos.writeObject(message);
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        message = (InternalMessage)ois.readObject();
        MultiPartPayload multiPartPayload = (MultiPartPayload)message.getPayload().getValue();
        Assert.assertThat((Object)multiPartPayload.getPartNames(), (Matcher)IsCollectionContaining.hasItem((Object)"attachment"));
        Assert.assertThat((Object)multiPartPayload.getPart("attachment").getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"this is the attachment"));
        Assert.assertThat((Object)multiPartPayload.getPart("attachment").getAttributes().getValue(), (Matcher)CoreMatchers.equalTo((Object)attachmentPart.getAttributes().getValue()));
        Assert.assertThat(multiPartPayload.getNamedParts().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasKey((Object)"attachment"));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasKey((Object)"_body"));
    }

    @Test
    public void multiPartPayloadStreamsSerialization() throws Exception {
        Message attachmentPart = IOUtils.toMuleMessagePart((String)"spi-props", (Object)IOUtils.getResourceAsUrl((String)"test-spi.properties", ((Object)((Object)this)).getClass()), (MediaType)MediaType.TEXT);
        Assert.assertThat((Object)attachmentPart.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(InputStream.class));
        Message message = Message.builder().payload((Object)new DefaultMultiPartPayload(new Message[]{Message.builder().payload((Object)"test").attributes((Object)DefaultMultiPartPayload.BODY_ATTRIBUTES).build(), attachmentPart})).build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        Event.setCurrentEvent((Event)DefaultMultiPartPayloadTestCase.eventBuilder().message(message).build());
        oos.writeObject(message);
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        message = (InternalMessage)ois.readObject();
        MultiPartPayload multiPartPayload = (MultiPartPayload)message.getPayload().getValue();
        Assert.assertThat((Object)multiPartPayload.getPartNames(), (Matcher)IsCollectionContaining.hasItem((Object)"spi-props"));
        Assert.assertThat((Object)multiPartPayload.getPart("spi-props").getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(byte[].class));
        Assert.assertThat((Object)multiPartPayload.getPart("spi-props").getAttributes().getValue(), (Matcher)CoreMatchers.equalTo((Object)attachmentPart.getAttributes().getValue()));
        Assert.assertThat(multiPartPayload.getNamedParts().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasKey((Object)"spi-props"));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasKey((Object)"_body"));
    }

    @Test
    public void getPayloadAsStringFails() throws Exception {
        Message attachmentPart = Message.builder().payload((Object)"this is the attachment").mediaType(MediaType.TEXT).attributes((Object)new PartAttributes("attachment")).build();
        Message message = Message.builder().payload((Object)new DefaultMultiPartPayload(new Message[]{Message.builder().payload((Object)"test").attributes((Object)DefaultMultiPartPayload.BODY_ATTRIBUTES).build(), attachmentPart})).build();
        this.expected.expect(TransformerException.class);
        this.expected.expectMessage("\"MultiPartPayload\" cannot be transformed to java.lang.String.");
        this.getPayloadAsString(message);
    }

    @Test
    public void getPayloadAsBytesFails() throws Exception {
        Message attachmentPart = Message.builder().payload((Object)"this is the attachment").mediaType(MediaType.TEXT).attributes((Object)new PartAttributes("attachment")).build();
        Message message = Message.builder().payload((Object)new DefaultMultiPartPayload(new Message[]{Message.builder().payload((Object)"test").attributes((Object)DefaultMultiPartPayload.BODY_ATTRIBUTES).build(), attachmentPart})).build();
        this.expected.expect(TransformerException.class);
        this.expected.expectMessage("\"MultiPartPayload\" cannot be transformed to [B.");
        this.getPayloadAsBytes(message);
    }

    @Test
    public void nestedMultiPartFlattens() throws Exception {
        Message attachmentPart1 = Message.builder().payload((Object)"this is the attachment1").mediaType(MediaType.TEXT).attributes((Object)new PartAttributes("attachment1")).build();
        Message attachmentPart2 = Message.builder().payload((Object)"this is the attachment2").mediaType(MediaType.TEXT).attributes((Object)new PartAttributes("attachment2")).build();
        Message messageInner = Message.builder().payload((Object)new DefaultMultiPartPayload(new Message[]{Message.builder().payload((Object)"test").attributes((Object)DefaultMultiPartPayload.BODY_ATTRIBUTES).build(), attachmentPart1})).attributes((Object)DefaultMultiPartPayload.BODY_ATTRIBUTES).build();
        Message message = Message.builder().payload((Object)new DefaultMultiPartPayload(new Message[]{attachmentPart2, messageInner})).build();
        MultiPartPayload multiPartPayload = (MultiPartPayload)message.getPayload().getValue();
        Assert.assertThat((Object)multiPartPayload.getParts(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)multiPartPayload.getPart("attachment1"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)multiPartPayload.getPart("attachment2"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((DefaultMultiPartPayload)multiPartPayload).getBodyPart(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat(multiPartPayload.getNamedParts().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"attachment1"), (Matcher)CoreMatchers.sameInstance((Object)attachmentPart1)));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"attachment2"), (Matcher)CoreMatchers.sameInstance((Object)attachmentPart2)));
        Assert.assertThat((Object)multiPartPayload.getNamedParts(), (Matcher)IsMapContaining.hasKey((Object)"_body"));
    }

    @Test
    public void partWithInvalidAttributes() throws Exception {
        Message attachmentPart = Message.builder().payload((Object)"this is the attachment").mediaType(MediaType.TEXT).attributes((Object)new PartAttributes("attachment")).build();
        this.expected.expect(IllegalArgumentException.class);
        new DefaultMultiPartPayload(new Message[]{Message.of((Object)"test"), attachmentPart});
    }
}

