/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.message.ErrorBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ErrorBuilderTestCase
extends AbstractMuleTestCase {
    private static final String EXCEPTION_MESSAGE = "message";
    private final ErrorType mockErrorType = (ErrorType)Mockito.mock(ErrorType.class);

    @Test
    public void buildErrorFromException() {
        RuntimeException exception = new RuntimeException(EXCEPTION_MESSAGE);
        Error error = ErrorBuilder.builder((Throwable)exception).errorType(this.mockErrorType).build();
        Assert.assertThat((Object)error.getCause(), (Matcher)Is.is((Object)exception));
        Assert.assertThat((Object)error.getDescription(), (Matcher)Is.is((Object)EXCEPTION_MESSAGE));
        Assert.assertThat((Object)error.getDetailedDescription(), (Matcher)Is.is((Object)EXCEPTION_MESSAGE));
        Assert.assertThat((Object)error.getErrorType(), (Matcher)Is.is((Object)this.mockErrorType));
    }

    @Test
    public void buildErrorFromMuleException() {
        DefaultMuleException exception = new DefaultMuleException((Throwable)new RuntimeException(EXCEPTION_MESSAGE));
        Error error = ErrorBuilder.builder((Throwable)exception).errorType(this.mockErrorType).build();
        Assert.assertThat((Object)error.getCause(), (Matcher)Is.is((Object)exception));
        Assert.assertThat((Object)error.getDescription(), (Matcher)Matchers.containsString((String)EXCEPTION_MESSAGE));
        Assert.assertThat((Object)error.getDetailedDescription(), (Matcher)Matchers.containsString((String)EXCEPTION_MESSAGE));
        Assert.assertThat((Object)error.getErrorType(), (Matcher)Is.is((Object)this.mockErrorType));
    }

    @Test
    public void buildError() {
        String detailedDescription = "detailed description";
        String description = "description";
        ErrorType errorType = this.mockErrorType;
        Message errorMessage = Message.of(null);
        IllegalArgumentException exception = new IllegalArgumentException("some message");
        Error error = ErrorBuilder.builder().errorType(errorType).description(description).detailedDescription(detailedDescription).exception((Throwable)exception).errorMessage(errorMessage).build();
        Assert.assertThat((Object)error.getDescription(), (Matcher)Is.is((Object)description));
        Assert.assertThat((Object)error.getDetailedDescription(), (Matcher)Is.is((Object)detailedDescription));
        Assert.assertThat((Object)error.getCause(), (Matcher)Is.is((Object)exception));
        Assert.assertThat((Object)error.getErrorType(), (Matcher)Is.is((Object)errorType));
        Assert.assertThat((Object)error.getErrorMessage(), (Matcher)Is.is((Object)errorMessage));
    }
}

