/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message.processing;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.context.notification.NotificationHelper;
import org.mule.runtime.core.context.notification.ServerNotificationManager;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.AsyncResponseFlowProcessingPhase;
import org.mule.runtime.core.execution.AsyncResponseFlowProcessingPhaseTemplate;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.MessageProcessPhase;
import org.mule.runtime.core.execution.PhaseResultNotifier;
import org.mule.runtime.core.execution.ResponseCompletionCallback;
import org.mule.runtime.core.execution.ResponseDispatchException;
import org.mule.runtime.core.execution.ValidationPhase;
import org.mule.runtime.core.message.processing.PhaseSupportTestHelper;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class AsyncResponseFlowProcessingPhaseTestCase
extends AbstractMuleTestCase {
    private AsyncResponseFlowProcessingPhase phase = new AsyncResponseFlowProcessingPhase(){

        protected NotificationHelper getNotificationHelper(ServerNotificationManager serverNotificationManager) {
            return AsyncResponseFlowProcessingPhaseTestCase.this.notificationHelper;
        }
    };
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private AsyncResponseFlowProcessingPhaseTemplate mockTemplate;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessContext mockContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private PhaseResultNotifier mockNotifier;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ResponseDispatchException mockResponseDispatchException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessagingException mockMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Event mockMuleEvent;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessagingException mockException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private NotificationHelper notificationHelper;

    @Before
    public void before() {
        this.phase.setMuleContext((MuleContext)Mockito.mock(MuleContext.class));
        Mockito.when((Object)this.mockContext.getTransactionConfig()).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockMuleEvent.getError()).thenReturn(Optional.empty());
    }

    @Before
    public void configureExpectedBehaviour() throws Exception {
        Mockito.when((Object)this.mockTemplate.getEvent()).thenReturn((Object)this.mockMuleEvent);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer(invocationOnMock -> {
            ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
            callback.responseSentSuccessfully();
            return null;
        }).when((Object)this.mockTemplate)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any(MessagingException.class)), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer(invocationOnMock -> {
            ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
            callback.responseSentSuccessfully();
            return null;
        }).when((Object)this.mockTemplate)).sendResponseToClient((Event)Matchers.any(Event.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        Mockito.when((Object)this.mockTemplate.getEvent()).thenReturn((Object)this.mockMuleEvent);
    }

    @Test
    public void supportedTemplates() {
        new PhaseSupportTestHelper<AsyncResponseFlowProcessingPhaseTemplate>(AsyncResponseFlowProcessingPhaseTemplate.class).testSupportTemplates((MessageProcessPhase)this.phase);
    }

    @Test
    public void order() {
        Assert.assertThat((Object)this.phase.compareTo((MessageProcessPhase)new ValidationPhase()), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.phase.compareTo((MessageProcessPhase)Mockito.mock(MessageProcessPhase.class)), (Matcher)Is.is((Object)0));
    }

    @Test
    public void runPhaseWithMessagingExceptionThrown() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doThrow((Throwable)this.mockMessagingException).when((Object)this.mockTemplate)).routeEvent((Event)Matchers.any(Event.class));
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockContext.getFlowConstruct().getExceptionListener())).handleException((MessagingException)((Object)Matchers.any(MessagingException.class)), (Event)Matchers.any(Event.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void runPhaseWithSuccessfulFlowProcessing() throws Exception {
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockTemplate)).sendResponseToClient((Event)Matchers.any(Event.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void sendResponseWhenFlowExecutionFailsAndExceptionIsHandled() throws MuleException {
        Mockito.when((Object)this.mockTemplate.routeEvent((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)true);
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockTemplate)).sendResponseToClient((Event)Matchers.any(Event.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void sendFailureResponseWhenFlowExecutionFailsAndExceptionIsNotHandled() throws MuleException {
        Mockito.when((Object)this.mockTemplate.routeEvent((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)false);
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockTemplate)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any(MessagingException.class)), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void callExceptionHandlerWhenSuccessfulExecutionFailsWritingResponse() throws Exception {
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer(invocationOnMock -> {
            ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
            callback.responseSentWithFailure(this.mockException, this.mockMuleEvent);
            return null;
        }).when((Object)this.mockTemplate)).sendResponseToClient((Event)Matchers.any(Event.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockContext.getFlowConstruct().getExceptionListener())).handleException((MessagingException)((Object)Matchers.any(MessagingException.class)), (Event)Matchers.any(Event.class));
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void doNotCallExceptionHandlerWhenFailureExecutionFailsWritingResponse() throws Exception {
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer(invocationOnMock -> {
            ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
            callback.responseSentWithFailure(this.mockException, ((MessagingException)((Object)((Object)invocationOnMock.getArguments()[0]))).getEvent());
            return null;
        }).when((Object)this.mockTemplate)).sendFailureResponseToClient((MessagingException)((Object)Matchers.any(MessagingException.class)), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        Mockito.when((Object)this.mockTemplate.routeEvent((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockContext.getFlowConstruct().getExceptionListener())).handleException((MessagingException)((Object)Matchers.any(MessagingException.class)), (Event)Matchers.any(Event.class));
        this.verifyOnlyFailureWasCalled((Exception)((Object)this.mockException));
    }

    @Test
    public void allowNullEventsOnNotifications() throws Exception {
        Event.setCurrentEvent(null);
        Mockito.when((Object)this.mockTemplate.getEvent()).thenReturn(null);
        Mockito.when((Object)this.mockTemplate.routeEvent((Event)Matchers.any(Event.class))).thenReturn(null);
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        Event.setCurrentEvent((Event)this.mockMuleEvent);
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
    }

    @Test
    public void responseNotificationFired() throws Exception {
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer(invocationOnMock -> {
            ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
            callback.responseSentWithFailure(this.mockException, this.mockMuleEvent);
            return null;
        }).when((Object)this.mockTemplate)).sendResponseToClient((Event)Matchers.any(Event.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper)).fireNotification(Matchers.any(MessageSource.class), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)805));
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper, (VerificationMode)Mockito.never())).fireNotification(Matchers.any(MessageSource.class), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)806));
    }

    @Test
    public void errorResponseNotificationFired() throws Exception {
        ((AsyncResponseFlowProcessingPhaseTemplate)Mockito.doAnswer(invocationOnMock -> {
            ResponseCompletionCallback callback = (ResponseCompletionCallback)invocationOnMock.getArguments()[1];
            callback.responseSentWithFailure(this.mockException, this.mockMuleEvent);
            return null;
        }).when((Object)this.mockTemplate)).sendResponseToClient((Event)Matchers.any(Event.class), (ResponseCompletionCallback)Matchers.any(ResponseCompletionCallback.class));
        Mockito.when((Object)this.mockTemplate.routeEvent((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper, (VerificationMode)Mockito.never())).fireNotification(Matchers.any(MessageSource.class), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)805));
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper)).fireNotification(Matchers.any(MessageSource.class), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)806));
    }

    private void verifyOnlySuccessfulWasCalled() {
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)Matchers.any(Exception.class));
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseConsumedMessage();
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier)).phaseSuccessfully();
    }

    private void verifyOnlyFailureWasCalled(Exception e) {
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier)).phaseFailure(e);
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseConsumedMessage();
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
    }
}

