/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message.processing;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.context.notification.NotificationHelper;
import org.mule.runtime.core.context.notification.ServerNotificationManager;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.FlowProcessingPhase;
import org.mule.runtime.core.execution.FlowProcessingPhaseTemplate;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.MessageProcessPhase;
import org.mule.runtime.core.execution.PhaseResultNotifier;
import org.mule.runtime.core.execution.RequestResponseFlowProcessingPhaseTemplate;
import org.mule.runtime.core.execution.ResponseDispatchException;
import org.mule.runtime.core.execution.ValidationPhase;
import org.mule.runtime.core.message.processing.PhaseSupportTestHelper;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class FlowProcessingPhaseTestCase
extends AbstractMuleTestCase {
    private FlowProcessingPhase phase = new FlowProcessingPhase(){

        protected NotificationHelper getNotificationHelper(ServerNotificationManager serverNotificationManager) {
            return FlowProcessingPhaseTestCase.this.notificationHelper;
        }
    };
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private FlowProcessingPhaseTemplate mockTemplate;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RequestResponseFlowProcessingPhaseTemplate mockRequestResponseTemplate;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessContext mockContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private PhaseResultNotifier mockNotifier;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ResponseDispatchException mockResponseDispatchException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessagingException mockMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleException mockException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private NotificationHelper notificationHelper;

    @Before
    public void before() {
        this.phase.setMuleContext((MuleContext)Mockito.mock(MuleContext.class));
        Mockito.when((Object)this.mockContext.getTransactionConfig()).thenReturn(Optional.empty());
    }

    @Test
    public void supportedTemplates() {
        new PhaseSupportTestHelper<FlowProcessingPhaseTemplate>(FlowProcessingPhaseTemplate.class).testSupportTemplates((MessageProcessPhase)this.phase);
    }

    @Test
    public void order() {
        Assert.assertThat((Object)this.phase.compareTo((MessageProcessPhase)new ValidationPhase()), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.phase.compareTo((MessageProcessPhase)Mockito.mock(MessageProcessPhase.class)), (Matcher)Is.is((Object)0));
    }

    @Test
    public void runPhaseWithExceptionThrown() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        ((FlowProcessingPhaseTemplate)Mockito.doThrow((Throwable)this.mockException).when((Object)this.mockTemplate)).afterSuccessfulProcessingFlow((Event)Matchers.any(Event.class));
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((FlowConstruct)Mockito.verify((Object)this.mockContext.getFlowConstruct())).getExceptionListener();
        this.verifyOnlyFailureWasCalled((Exception)((Object)this.mockException));
    }

    @Test
    public void runPhaseWithMessagingExceptionThrown() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        Mockito.when((Object)this.mockTemplate.routeEvent((Event)Mockito.any(Event.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((FlowConstruct)Mockito.verify((Object)this.mockContext.getFlowConstruct())).getExceptionListener();
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void callSendResponseForRequestResponseTemplate() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        this.verifyOnlySuccessfulWasCalled();
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate)).sendResponseToClient((Event)Matchers.any(Event.class));
    }

    @Test
    public void successfulPhaseExecutionInOrder() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        InOrder inOrderVerify = Mockito.inOrder((Object[])new Object[]{this.mockContext, this.mockContext.getFlowConstruct(), this.mockRequestResponseTemplate, this.mockNotifier});
        ((MessageProcessContext)inOrderVerify.verify((Object)this.mockContext, Mockito.atLeastOnce())).getTransactionConfig();
        ((FlowConstruct)inOrderVerify.verify((Object)this.mockContext.getFlowConstruct())).getExceptionListener();
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate)).getEvent();
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate)).beforeRouteEvent((Event)Matchers.any(Event.class));
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate)).routeEvent((Event)Matchers.any(Event.class));
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate)).afterRouteEvent((Event)Matchers.any(Event.class));
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate)).afterSuccessfulProcessingFlow((Event)Matchers.any(Event.class));
        ((PhaseResultNotifier)inOrderVerify.verify((Object)this.mockNotifier)).phaseSuccessfully();
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void sendResponseWhenFlowExecutionFailsAndExceptionIsHandled() throws MuleException {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        Mockito.when((Object)this.mockRequestResponseTemplate.afterRouteEvent((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)true);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate)).sendResponseToClient((Event)Matchers.any(Event.class));
    }

    @Test
    public void sendFailureResponseWhenFlowExecutionFailsAndExceptionIsNotHandled() throws MuleException {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        Mockito.when((Object)this.mockRequestResponseTemplate.afterRouteEvent((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)false);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate)).afterFailureProcessingFlow(this.mockMessagingException);
    }

    @Test
    public void doNotSendResponseWhenFlowExecutionFailsSendingResponseAndExceptionIsHandled() throws MuleException {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.doThrow((Throwable)this.mockResponseDispatchException).when((Object)this.mockRequestResponseTemplate)).sendResponseToClient((Event)Matchers.any(Event.class));
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)true);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate)).sendResponseToClient((Event)Matchers.any(Event.class));
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate, (VerificationMode)Mockito.never())).afterFailureProcessingFlow(this.mockMessagingException);
    }

    @Test
    public void doNotSendFailureResponseWhenFlowExecutionFailsSendingResponseAndExceptionIsNotHandled() throws MuleException {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.doThrow((Throwable)this.mockMessagingException).when((Object)this.mockRequestResponseTemplate)).sendResponseToClient((Event)Matchers.any(Event.class));
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)false);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate)).sendResponseToClient((Event)Matchers.any(Event.class));
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate)).afterFailureProcessingFlow(this.mockMessagingException);
    }

    @Test
    public void responseNotificationFired() throws MuleException {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        Mockito.when((Object)this.mockRequestResponseTemplate.afterRouteEvent((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)true);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper)).fireNotification(Matchers.any(MessageSource.class), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)805));
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper, (VerificationMode)Mockito.never())).fireNotification(Matchers.any(MessageSource.class), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)806));
    }

    @Test
    public void errorResponseNotificationFired() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        Mockito.when((Object)this.mockRequestResponseTemplate.afterRouteEvent((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMessagingException.handled()).thenReturn((Object)false);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper, (VerificationMode)Mockito.never())).fireNotification(Matchers.any(MessageSource.class), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)805));
        ((NotificationHelper)Mockito.verify((Object)this.notificationHelper)).fireNotification(Matchers.any(MessageSource.class), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class), Matchers.eq((int)806));
    }

    private void verifyOnlySuccessfulWasCalled() {
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)Matchers.any(Exception.class));
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseConsumedMessage();
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier)).phaseSuccessfully();
    }

    private void verifyOnlyFailureWasCalled(Exception e) {
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier)).phaseFailure(e);
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseConsumedMessage();
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
    }
}

