/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message.processing;

import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.mule.runtime.core.execution.EndPhaseTemplate;
import org.mule.runtime.core.execution.EndProcessPhase;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.MessageProcessPhase;
import org.mule.runtime.core.execution.MessageProcessTemplate;
import org.mule.runtime.core.execution.PhaseExecutionEngine;
import org.mule.runtime.core.execution.PhaseResultNotifier;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class PhaseExecutionEngineTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SystemExceptionHandler mockExceptionHandler;
    private List<MessageProcessPhase> phaseList = new ArrayList<MessageProcessPhase>();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private EndProcessPhase mockEndPhase;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessPhase mockProcessPhase1;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessPhase mockProcessPhase2;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessPhase mockProcessPhase3;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessPhase mockFailingPhase;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private EndPhaseTemplate mockTemplate;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessContext mockContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private PhaseResultNotifier mockNotifier;

    @Test
    public void allPhasesRun() throws Exception {
        Mockito.when((Object)this.mockEndPhase.supportsTemplate((MessageProcessTemplate)this.mockTemplate)).thenReturn((Object)true);
        this.verifyAllPhasesAreRun();
        ((EndProcessPhase)Mockito.verify((Object)this.mockEndPhase, (VerificationMode)Mockito.times((int)1))).runPhase((EndPhaseTemplate)Matchers.any(EndPhaseTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class), (PhaseResultNotifier)Matchers.any(PhaseResultNotifier.class));
    }

    @Test
    public void endPhaseDoesNotRun() throws Exception {
        Mockito.when((Object)this.mockEndPhase.supportsTemplate((MessageProcessTemplate)this.mockTemplate)).thenReturn((Object)false);
        this.verifyAllPhasesAreRun();
        ((EndProcessPhase)Mockito.verify((Object)this.mockEndPhase, (VerificationMode)Mockito.times((int)0))).runPhase((EndPhaseTemplate)Matchers.any(EndPhaseTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class), (PhaseResultNotifier)Matchers.any(PhaseResultNotifier.class));
    }

    @Test
    public void exceptionHandlerIsCalledOnFailure() throws Exception {
        this.addSupportedPhase(this.mockFailingPhase);
        this.addSupportedPhase(this.mockProcessPhase1);
        Mockito.when((Object)this.mockEndPhase.supportsTemplate((MessageProcessTemplate)this.mockTemplate)).thenReturn((Object)true);
        PhaseExecutionEngine phaseExecutionEngine = new PhaseExecutionEngine(this.phaseList, this.mockExceptionHandler, this.mockEndPhase);
        phaseExecutionEngine.process((MessageProcessTemplate)this.mockTemplate, this.mockContext);
        ((EndProcessPhase)Mockito.verify((Object)this.mockEndPhase, (VerificationMode)Mockito.times((int)1))).runPhase((EndPhaseTemplate)Matchers.any(EndPhaseTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class), (PhaseResultNotifier)Matchers.any(PhaseResultNotifier.class));
    }

    @Test
    public void phaseItsNoSupportedThenNextPhaseExecutes() throws Exception {
        this.addSupportedPhase(this.mockProcessPhase1);
        this.addNotSupportedPhase(this.mockProcessPhase2);
        this.addSupportedPhase(this.mockProcessPhase3);
        Mockito.when((Object)this.mockProcessPhase2.supportsTemplate((MessageProcessTemplate)this.mockTemplate)).thenReturn((Object)false);
        PhaseExecutionEngine phaseExecutionEngine = new PhaseExecutionEngine(this.phaseList, this.mockExceptionHandler, this.mockEndPhase);
        phaseExecutionEngine.process((MessageProcessTemplate)this.mockTemplate, this.mockContext);
        ((MessageProcessPhase)Mockito.verify((Object)this.mockProcessPhase1, (VerificationMode)Mockito.times((int)1))).runPhase((MessageProcessTemplate)Matchers.any(EndPhaseTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class), (PhaseResultNotifier)Matchers.any(PhaseResultNotifier.class));
        ((MessageProcessPhase)Mockito.verify((Object)this.mockProcessPhase2, (VerificationMode)Mockito.times((int)0))).runPhase((MessageProcessTemplate)Matchers.any(EndPhaseTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class), (PhaseResultNotifier)Matchers.any(PhaseResultNotifier.class));
        ((MessageProcessPhase)Mockito.verify((Object)this.mockProcessPhase3, (VerificationMode)Mockito.times((int)1))).runPhase((MessageProcessTemplate)Matchers.any(EndPhaseTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class), (PhaseResultNotifier)Matchers.any(PhaseResultNotifier.class));
    }

    private void verifyAllPhasesAreRun() {
        PhaseExecutionEngine engine = new PhaseExecutionEngine(this.phaseList, this.mockExceptionHandler, this.mockEndPhase);
        this.addAllPhases();
        engine.process((MessageProcessTemplate)this.mockTemplate, this.mockContext);
        ((MessageProcessPhase)Mockito.verify((Object)this.mockProcessPhase1, (VerificationMode)Mockito.times((int)1))).runPhase((MessageProcessTemplate)Matchers.any(MessageProcessTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class), (PhaseResultNotifier)Matchers.any(PhaseResultNotifier.class));
        ((MessageProcessPhase)Mockito.verify((Object)this.mockProcessPhase2, (VerificationMode)Mockito.times((int)1))).runPhase((MessageProcessTemplate)Matchers.any(MessageProcessTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class), (PhaseResultNotifier)Matchers.any(PhaseResultNotifier.class));
        ((MessageProcessPhase)Mockito.verify((Object)this.mockProcessPhase3, (VerificationMode)Mockito.times((int)1))).runPhase((MessageProcessTemplate)Matchers.any(MessageProcessTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class), (PhaseResultNotifier)Matchers.any(PhaseResultNotifier.class));
    }

    private void addAllPhases() {
        this.addSupportedPhase(this.mockProcessPhase1);
        this.addSupportedPhase(this.mockProcessPhase2);
        this.addSupportedPhase(this.mockProcessPhase3);
    }

    private void addSupportedPhase(MessageProcessPhase mockProcessPhase) {
        this.addPhase(mockProcessPhase, true);
    }

    private void addNotSupportedPhase(MessageProcessPhase mockProcessPhase) {
        this.addPhase(mockProcessPhase, false);
    }

    private void addPhase(MessageProcessPhase mockProcessPhase, boolean supportsTemplate) {
        this.phaseList.add(mockProcessPhase);
        Mockito.when((Object)mockProcessPhase.supportsTemplate((MessageProcessTemplate)this.mockTemplate)).thenReturn((Object)supportsTemplate);
        ((MessageProcessPhase)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ((PhaseResultNotifier)invocationOnMock.getArguments()[2]).phaseSuccessfully();
                return null;
            }
        }).when((Object)mockProcessPhase)).runPhase((MessageProcessTemplate)Matchers.any(MessageProcessTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class), (PhaseResultNotifier)Matchers.any(PhaseResultNotifier.class));
    }
}

