/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message.processing;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.MessageProcessPhase;
import org.mule.runtime.core.execution.PhaseResultNotifier;
import org.mule.runtime.core.execution.ValidationPhase;
import org.mule.runtime.core.execution.ValidationPhaseTemplate;
import org.mule.runtime.core.message.processing.PhaseSupportTestHelper;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class ValidationPhaseTestCase
extends AbstractMuleContextTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ValidationPhaseTemplate mockTemplate;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessContext mockContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private PhaseResultNotifier mockPhaseResultNotifier;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleException mockMulException;

    @Test
    public void supportsTemplate() {
        new PhaseSupportTestHelper<ValidationPhaseTemplate>(ValidationPhaseTemplate.class).testSupportTemplates((MessageProcessPhase)new ValidationPhase());
    }

    @Test
    public void valid() {
        Mockito.when((Object)this.mockTemplate.validateMessage()).thenReturn((Object)true);
        new ValidationPhase().runPhase(this.mockTemplate, this.mockContext, this.mockPhaseResultNotifier);
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockPhaseResultNotifier, (VerificationMode)Mockito.times((int)1))).phaseSuccessfully();
    }

    @Test
    public void invalid() throws Exception {
        Mockito.when((Object)this.mockTemplate.validateMessage()).thenReturn((Object)false);
        new ValidationPhase().runPhase(this.mockTemplate, this.mockContext, this.mockPhaseResultNotifier);
        ((ValidationPhaseTemplate)Mockito.verify((Object)this.mockTemplate, (VerificationMode)Mockito.times((int)1))).discardInvalidMessage();
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockPhaseResultNotifier, (VerificationMode)Mockito.times((int)1))).phaseConsumedMessage();
    }

    @Test
    public void validationFails() throws Exception {
        Mockito.when((Object)this.mockTemplate.validateMessage()).thenReturn((Object)false);
        ((ValidationPhaseTemplate)Mockito.doThrow((Throwable)this.mockMulException).when((Object)this.mockTemplate)).discardInvalidMessage();
        new ValidationPhase().runPhase(this.mockTemplate, this.mockContext, this.mockPhaseResultNotifier);
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockPhaseResultNotifier, (VerificationMode)Mockito.times((int)1))).phaseFailure((Exception)((Object)this.mockMulException));
    }
}

