/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.mule.enricher;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.enricher.MessageEnricher;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;

public class MessageEnricherTestCase
extends AbstractReactiveProcessorTestCase {
    public static final String FOO_FLOW_VAR_EXPRESSION = "#[mel:flowVars['foo']]";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    public MessageEnricherTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
    }

    @Test
    public void testEnrichHeaderWithPayload() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:message.outboundProperties.myHeader]"));
        enricher.setEnrichmentMessageProcessor(event -> Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)"test").build()).build());
        enricher.initialise();
        Message result = this.process((Processor)enricher, this.testEvent()).getMessage();
        Assert.assertEquals((Object)"test", (Object)((InternalMessage)result).getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"test", (Object)result.getPayload().getValue());
    }

    @Test
    public void testEnrichHeaderWithHeader() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:message.outboundProperties.header1]", "#[mel:message.outboundProperties.myHeader]"));
        enricher.setEnrichmentMessageProcessor(event -> Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).addOutboundProperty("header1", (Serializable)((Object)"test")).build()).build());
        Message result = this.process((Processor)enricher, this.testEvent()).getMessage();
        Assert.assertEquals((Object)"test", (Object)((InternalMessage)result).getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"test", (Object)result.getPayload().getValue());
    }

    @Test
    public void testEnrichHeadersMToN() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:message.outboundProperties.header1]", "#[mel:message.outboundProperties.myHeader1]"));
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:message.outboundProperties.header2]", "#[mel:message.outboundProperties.myHeader2]"));
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:message.outboundProperties.header3]", "#[mel:message.outboundProperties.myHeader3]"));
        enricher.setEnrichmentMessageProcessor(event -> Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).addOutboundProperty("header1", (Serializable)((Object)"test")).addOutboundProperty("header2", (Serializable)((Object)"test2")).addOutboundProperty("header3", (Serializable)((Object)"test3")).build()).build());
        Message result = this.process((Processor)enricher, this.testEvent()).getMessage();
        Assert.assertNull((Object)((InternalMessage)result).getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"test2", (Object)((InternalMessage)result).getOutboundProperty("myHeader2"));
        Assert.assertEquals((Object)"test3", (Object)((InternalMessage)result).getOutboundProperty("myHeader3"));
        Assert.assertEquals((Object)"test", (Object)result.getPayload().getValue());
    }

    @Test
    public void testEnrichWithNullResponse() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:message.outboundProperties.myHeader]"));
        enricher.setEnrichmentMessageProcessor(event -> null);
        Message result = this.process((Processor)enricher, this.testEvent()).getMessage();
        Assert.assertNull((Object)((InternalMessage)result).getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"test", (Object)result.getPayload().getValue());
    }

    @Test
    public void testEnrichWithException() throws Exception {
        IllegalStateException testException = new IllegalStateException();
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(event -> {
            throw testException;
        });
        enricher.setFlowConstruct((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
        this.thrown.expect(CoreMatchers.sameInstance((Object)testException));
        this.process((Processor)enricher, this.testEvent());
    }

    @Test
    public void propagateMessage() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:message.outboundProperties.myHeader]"));
        enricher.setEnrichmentMessageProcessor(event -> Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)"enriched").build()).build());
        Event in = MessageEnricherTestCase.eventBuilder().message((Message)InternalMessage.builder().payload((Object)"").addOutboundProperty("foo", (Serializable)((Object)"bar")).build()).build();
        Event out = this.process((Processor)enricher, in);
        Assert.assertThat((Object)out.getCorrelationId(), (Matcher)CoreMatchers.equalTo((Object)in.getCorrelationId()));
        Assert.assertThat((Object)((InternalMessage)out.getMessage()).getOutboundProperty("foo"), (Matcher)CoreMatchers.equalTo((Object)"bar"));
        Assert.assertThat((Object)out.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)in.getMessage().getPayload().getValue()));
    }

    @Test
    public void propagatesVariables() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:message.outboundProperties.myHeader]"));
        enricher.setEnrichmentMessageProcessor(event -> Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)"enriched").build()).build());
        Event in = MessageEnricherTestCase.eventBuilder().message(Message.of((Object)"")).addVariable("flowFoo", (Object)"bar").build();
        in.getSession().setProperty("sessionFoo", (Serializable)((Object)"bar"));
        Event out = this.process((Processor)enricher, in);
        Assert.assertEquals((Object)"bar", (Object)out.getSession().getProperty("sessionFoo"));
        Assert.assertEquals((Object)"bar", (Object)out.getVariable("flowFoo").getValue());
    }

    @Test
    public void doNotImplicitlyEnrichMessagePayload() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:message.outboundProperties.myHeader]"));
        enricher.setEnrichmentMessageProcessor(event -> Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)"enriched").build()).build());
        Message out = this.process((Processor)enricher, this.testEvent()).getMessage();
        Assert.assertEquals((Object)"test", (Object)out.getPayload().getValue());
    }

    @Test
    public void doNotImplicitlyEnrichMessageProperties() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:message.outboundProperties.myHeader]"));
        enricher.setEnrichmentMessageProcessor(event -> Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).addInboundProperty("foo", (Serializable)((Object)"bar")).build()).build());
        Message out = this.process((Processor)enricher, this.testEvent()).getMessage();
        Assert.assertNull((Object)((InternalMessage)out).getOutboundProperty("foo"));
    }

    @Test
    public void doNotImplicitlyEnrichFlowVariable() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:message.outboundProperties.myHeader]"));
        enricher.setEnrichmentMessageProcessor(event -> Event.builder((Event)event).addVariable("flowFoo", (Object)"bar").build());
        Event out = this.process((Processor)enricher, this.testEvent());
        Assert.assertThat((Object)out.getVariableNames(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"flowFoo")));
    }

    @Test
    public void doNotImplicitlyEnrichSessionVariable() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:message.outboundProperties.myHeader]"));
        enricher.setEnrichmentMessageProcessor(event -> {
            event.getSession().setProperty("sessionFoo", (Serializable)((Object)"bar"));
            return event;
        });
        Event out = this.process((Processor)enricher, this.testEvent());
        Assert.assertNull((Object)out.getSession().getProperty("sessionFoo"));
    }

    @Test
    public void enrichFlowVariable() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:flowVars.foo]"));
        enricher.setEnrichmentMessageProcessor(event -> Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)"bar").build()).build());
        Event out = this.process((Processor)enricher, this.testEvent());
        Assert.assertEquals((Object)"bar", (Object)out.getVariable("foo").getValue());
    }

    @Test
    public void enrichSessionVariable() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[mel:sessionVars['foo']]"));
        enricher.setEnrichmentMessageProcessor(event -> Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)"bar").build()).build());
        Event out = this.process((Processor)enricher, this.testEvent());
        Assert.assertEquals((Object)"bar", (Object)out.getSession().getProperty("foo"));
    }

    @Test
    public void enrichesFlowVarWithDataType() throws Exception {
        this.doEnrichDataTypePropagationTest(new MessageEnricher.EnrichExpressionPair("#[mel:payload]", FOO_FLOW_VAR_EXPRESSION));
    }

    @Test
    public void enrichesFlowVarWithDataTypeUsingExpressionEvaluator() throws Exception {
        this.doEnrichDataTypePropagationTest(new MessageEnricher.EnrichExpressionPair(FOO_FLOW_VAR_EXPRESSION));
    }

    private void doEnrichDataTypePropagationTest(MessageEnricher.EnrichExpressionPair pair) throws Exception {
        DataType dataType = DataType.builder().type(String.class).mediaType(MediaType.JSON).charset(StandardCharsets.UTF_16.name()).build();
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(pair);
        enricher.setEnrichmentMessageProcessor(event -> Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)"bar").mediaType(dataType.getMediaType()).build()).build());
        Event out = this.process((Processor)enricher, this.testEvent());
        Assert.assertEquals((Object)"bar", (Object)out.getVariable("foo").getValue());
        Assert.assertThat((Object)out.getVariable("foo").getDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.JSON, (Charset)StandardCharsets.UTF_16));
    }
}

