/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.mule.model;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.DefaultMuleEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.model.InvocationResult;
import org.mule.runtime.core.api.model.resolvers.ArrayEntryPointResolver;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;

public class ArrayEntryPointResolverTestCase
extends AbstractMuleContextTestCase {
    private FlowConstruct flowConstruct;

    @Before
    public void before() throws Exception {
        this.flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
    }

    @Test
    public void testArrayMatch() throws Exception {
        ArrayEntryPointResolver resolver = new ArrayEntryPointResolver();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new Fruit[]{new Apple(), new Orange()})).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult ctx = resolver.invoke((Object)new FruitBowl(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)ctx.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testArrayMatchGenericFail() throws Exception {
        ArrayEntryPointResolver resolver = new ArrayEntryPointResolver();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new Object[]{new Apple(), new Orange()})).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult ctx = resolver.invoke((Object)new FruitBowl(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)ctx.getState(), (Object)InvocationResult.State.FAILED);
    }

    @Test
    public void testArrayMatchFail() throws Exception {
        ArrayEntryPointResolver resolver = new ArrayEntryPointResolver();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new Object[]{"blah"})).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult ctx = resolver.invoke((Object)new Apple(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)ctx.getState(), (Object)InvocationResult.State.FAILED);
    }
}

