/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.mule.model;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.DefaultMuleEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.model.InvocationResult;
import org.mule.runtime.core.api.model.resolvers.CallableEntryPointResolver;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.WaterMelon;

public class CallableEntryPointDiscoveryTestCase
extends AbstractMuleContextTestCase {
    private FlowConstruct flowConstruct;

    @Before
    public void before() throws Exception {
        this.flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
    }

    @Test
    public void testBadMatch() throws Exception {
        CallableEntryPointResolver resolver = new CallableEntryPointResolver();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new StringBuilder("foo"))).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new WaterMelon(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((String)"Service doesn't implement Callable", (Object)result.getState(), (Object)InvocationResult.State.NOT_SUPPORTED);
    }

    @Test
    public void testGoodMatch() throws Exception {
        CallableEntryPointResolver resolver = new CallableEntryPointResolver();
        Apple apple = new Apple();
        apple.setMuleContext(muleContext);
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new StringBuilder("blah"))).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)apple, (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }
}

