/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.mule.model;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.DefaultMuleEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.model.InvocationResult;
import org.mule.runtime.core.api.model.resolvers.ExplicitMethodEntryPointResolver;
import org.mule.runtime.core.mule.model.MultiplePayloadsTestObject;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Fruit;

public class ExplicitMethodEntryPointResolverTestCase
extends AbstractMuleContextTestCase {
    private FlowConstruct flowConstruct;

    @Before
    public void before() throws Exception {
        this.flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
    }

    @Test
    public void testMethodSetPass() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("someBusinessMethod");
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"blah")).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testMethodSetMatchFirst() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("someBusinessMethod");
        resolver.addMethod("someSetter");
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"blah")).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testMethodNotFound() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("noMethod");
        resolver.addMethod("noMethod2");
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"blah")).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    @Test
    public void testNoMethodSet() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        try {
            Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"blah")).build();
            DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
            InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
            Assert.fail((String)"method property is not set, this should cause an error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMethodPropertyParameterAssignableFromPayload() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("wash");
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new Apple())).build();
        DefaultMuleEventContext ctx = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new TestFruitCleaner(), (MuleEventContext)ctx, Event.builder((Event)ctx.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testMethodPropertyParameterNull() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("someOtherBusinessMethod");
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new Object[]{null, "blah"})).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    public static class TestFruitCleaner {
        public void wash(Fruit fruit) {
        }

        public void polish(Fruit fruit) {
        }
    }
}

