/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.mule.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.DefaultMuleEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.model.EntryPointResolver;
import org.mule.runtime.core.api.model.resolvers.ArrayEntryPointResolver;
import org.mule.runtime.core.api.model.resolvers.EntryPointNotFoundException;
import org.mule.runtime.core.api.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.mule.model.MultiplePayloadsTestObject;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.FruitCleaner;
import org.mule.tck.testmodels.fruit.FruitLover;
import org.mule.tck.testmodels.fruit.Kiwi;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.WaterMelon;

public class LegacyEntryPointResolverTestCase
extends AbstractMuleContextTestCase {
    private static final String METHOD_PROPERTY_NAME = "method";
    private static final String INVALID_METHOD_NAME = "nosuchmethod";

    @Test
    public void testExplicitMethodMatch() throws Exception {
        try {
            LegacyEntryPointResolverSet resolver = new LegacyEntryPointResolverSet();
            Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
            Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"blah")).build();
            DefaultMuleEventContext eventContext = new DefaultMuleEventContext((FlowConstruct)flowConstruct, event);
            resolver.invoke((Object)new WaterMelon(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        }
        catch (MuleException e) {
            Assert.fail((String)("Test should have passed: " + (Object)((Object)e)));
        }
    }

    @Test
    public void testExplicitMethodMatchComplexObject() throws Exception {
        try {
            LegacyEntryPointResolverSet resolver = new LegacyEntryPointResolverSet();
            Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
            Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new FruitLover("Mmmm"))).build();
            DefaultMuleEventContext eventContext = new DefaultMuleEventContext((FlowConstruct)flowConstruct, event);
            resolver.invoke((Object)new FruitBowl(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        }
        catch (MuleException e) {
            Assert.fail((String)("Test should have passed: " + (Object)((Object)e)));
        }
    }

    @Test
    public void testExplicitMethodMatchSetArrayFail() throws Exception {
        try {
            LegacyEntryPointResolverSet resolver = new LegacyEntryPointResolverSet();
            Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
            Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new Fruit[]{new Apple(), new Orange()})).build();
            DefaultMuleEventContext eventContext = new DefaultMuleEventContext((FlowConstruct)flowConstruct, event);
            resolver.invoke((Object)new FruitBowl(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
            Assert.fail((String)"Test should have failed because the arguments were not wrapped properly: ");
        }
        catch (MuleException muleException) {
            // empty catch block
        }
    }

    @Test
    public void testExplicitMethodMatchSetArrayPass() throws Exception {
        try {
            LegacyEntryPointResolverSet resolver = new LegacyEntryPointResolverSet();
            Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
            Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new Object[]{new Fruit[]{new Apple(), new Orange()}})).build();
            DefaultMuleEventContext eventContext = new DefaultMuleEventContext((FlowConstruct)flowConstruct, event);
            resolver.invoke((Object)new FruitBowl(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        }
        catch (MuleException e) {
            Assert.fail((String)("Test should have passed: " + (Object)((Object)e)));
        }
    }

    @Test
    public void testExplicitMethodMatchSetArrayPassUsingExplicitResolver() throws Exception {
        try {
            LegacyEntryPointResolverSet resolver = new LegacyEntryPointResolverSet();
            resolver.addEntryPointResolver((EntryPointResolver)new ArrayEntryPointResolver());
            Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
            Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new Fruit[]{new Apple(), new Orange()})).build();
            DefaultMuleEventContext eventContext = new DefaultMuleEventContext((FlowConstruct)flowConstruct, event);
            resolver.invoke((Object)new FruitBowl(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        }
        catch (MuleException e) {
            Assert.fail((String)("Test should have passed: " + (Object)((Object)e)));
        }
    }

    @Test
    public void testFailEntryPointMultiplePayloadMatches() throws Exception {
        LegacyEntryPointResolverSet resolverSet = new LegacyEntryPointResolverSet();
        try {
            Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
            Event.setCurrentEvent((Event)Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"Hello")).build());
            DefaultMuleEventContext eventContext = new DefaultMuleEventContext((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), Event.getCurrentEvent());
            resolverSet.invoke((Object)new MultiplePayloadsTestObject(), (MuleEventContext)eventContext, Event.builder((Event)Event.getCurrentEvent()));
            Assert.fail((String)"Should have failed to find entrypoint.");
        }
        catch (EntryPointNotFoundException entryPointNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testMethodOverrideDoesNotFallback() throws Exception {
        LegacyEntryPointResolverSet resolverSet = new LegacyEntryPointResolverSet();
        Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
        Event.setCurrentEvent((Event)Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new FruitLover("Yummy!"))).build());
        String methodName = INVALID_METHOD_NAME;
        String propertyName = METHOD_PROPERTY_NAME;
        Event event = Event.getCurrentEvent();
        event = Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).addOutboundProperty(METHOD_PROPERTY_NAME, (Serializable)((Object)INVALID_METHOD_NAME)).build()).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), event);
        resolverSet.invoke((Object)new FruitBowl(), (MuleEventContext)eventContext, Event.builder((Event)event));
    }

    @Test
    public void testMethodOverrideIgnoredWithCallable() throws Exception {
        LegacyEntryPointResolverSet resolver = new LegacyEntryPointResolverSet();
        Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
        Event.setCurrentEvent((Event)Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new FruitLover("Yummy!"))).build());
        Event event = Event.getCurrentEvent();
        event = Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).addOutboundProperty(METHOD_PROPERTY_NAME, (Serializable)((Object)INVALID_METHOD_NAME)).build()).build();
        Apple apple = new Apple();
        apple.setAppleCleaner(new FruitCleaner(){

            public void wash(Fruit fruit) {
            }

            public void polish(Fruit fruit) {
            }
        });
        apple.setMuleContext(muleContext);
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), event);
        resolver.invoke((Object)apple, (MuleEventContext)eventContext, Event.builder((Event)event));
    }

    @Test
    public void testMethodOverrideIgnoredWithEventContext() throws Exception {
        LegacyEntryPointResolverSet resolverSet = new LegacyEntryPointResolverSet();
        Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
        Event.setCurrentEvent((Event)Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new FruitLover("Yummy!"))).build());
        String methodName = INVALID_METHOD_NAME;
        String propertyName = METHOD_PROPERTY_NAME;
        Event event = Event.getCurrentEvent();
        event = Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).addOutboundProperty(METHOD_PROPERTY_NAME, (Serializable)((Object)INVALID_METHOD_NAME)).build()).build();
        try {
            DefaultMuleEventContext eventContext = new DefaultMuleEventContext((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), event);
            resolverSet.invoke((Object)new Kiwi(), (MuleEventContext)eventContext, Event.builder((Event)event));
            Assert.fail((String)"no such method on service");
        }
        catch (EntryPointNotFoundException entryPointNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayArgumentResolution() throws Exception {
        LegacyEntryPointResolverSet resolverSet = new LegacyEntryPointResolverSet();
        Object[] payload = new Object[]{new Fruit[]{new Apple(), new Banana()}};
        Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)payload)).build();
        Event.setCurrentEvent((Event)event);
        FruitBowl bowl = new FruitBowl();
        Assert.assertFalse((boolean)bowl.hasApple());
        Assert.assertFalse((boolean)bowl.hasBanana());
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), event);
        resolverSet.invoke((Object)bowl, (MuleEventContext)eventContext, Event.builder((Event)event));
        Assert.assertTrue((boolean)bowl.hasApple());
        Assert.assertTrue((boolean)bowl.hasBanana());
    }

    @Test
    public void testListArgumentResolution() throws Exception {
        LegacyEntryPointResolverSet resolverSet = new LegacyEntryPointResolverSet();
        List<Fruit> payload = Arrays.asList(new Apple(), new Banana());
        Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of(payload)).build();
        Event.setCurrentEvent((Event)event);
        FruitBowl bowl = new FruitBowl();
        Assert.assertFalse((boolean)bowl.hasApple());
        Assert.assertFalse((boolean)bowl.hasBanana());
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), event);
        resolverSet.invoke((Object)bowl, (MuleEventContext)eventContext, Event.builder((Event)event));
        Assert.assertTrue((boolean)bowl.hasApple());
        Assert.assertTrue((boolean)bowl.hasBanana());
    }

    @Test
    public void testExplicitOverride() throws Exception {
        LegacyEntryPointResolverSet resolverSet = new LegacyEntryPointResolverSet();
        List<Fruit> payload = Arrays.asList(new Apple(), new Banana());
        Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of(payload)).build();
        Event.setCurrentEvent((Event)event);
        String methodName = "setFruit";
        String propertyName = METHOD_PROPERTY_NAME;
        event = Event.builder((Event)event).message((Message)InternalMessage.builder((Message)event.getMessage()).addOutboundProperty(METHOD_PROPERTY_NAME, (Serializable)((Object)"setFruit")).build()).build();
        FruitBowl bowl = new FruitBowl();
        Assert.assertFalse((boolean)bowl.hasApple());
        Assert.assertFalse((boolean)bowl.hasBanana());
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), event);
        resolverSet.invoke((Object)bowl, (MuleEventContext)eventContext, Event.builder((Event)event));
        Assert.assertTrue((boolean)bowl.hasApple());
        Assert.assertTrue((boolean)bowl.hasBanana());
    }
}

