/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.mule.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.DefaultMuleEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.model.InvocationResult;
import org.mule.runtime.core.api.model.resolvers.MethodHeaderPropertyEntryPointResolver;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.mule.model.MultiplePayloadsTestObject;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Fruit;

public class MethodHeaderEntryPointResolverTestCase
extends AbstractMuleContextTestCase {
    private MethodHeaderPropertyEntryPointResolver resolver;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.resolver = new MethodHeaderPropertyEntryPointResolver();
    }

    @Test
    public void testMethodSetPass() throws Exception {
        MuleEventContext ctx = this.createMuleEventContext("blah", Collections.singletonMap("method", "someBusinessMethod"));
        InvocationResult result = this.resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx, Event.builder((Event)ctx.getEvent()));
        this.assertInvocationWasSuccessful(result);
    }

    @Test
    public void testMethodSetWithNoArgsPass() throws Exception {
        MuleEventContext ctx = this.createMuleEventContext(null, Collections.singletonMap("method", "wash"));
        InvocationResult result = this.resolver.invoke((Object)new Apple(), ctx, Event.builder((Event)ctx.getEvent()));
        this.assertInvocationWasSuccessful(result);
        Assert.assertEquals((Object)"wash", (Object)result.getMethodCalled());
    }

    @Test
    public void testCustomMethodProperty() throws Exception {
        this.resolver.setMethodProperty("serviceMethod");
        MuleEventContext ctx = this.createMuleEventContext("blah", Collections.singletonMap("serviceMethod", "someBusinessMethod"));
        InvocationResult result = this.resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx, Event.builder((Event)ctx.getEvent()));
        this.assertInvocationWasSuccessful(result);
    }

    @Test
    public void testCustomMethodPropertyFail() throws Exception {
        this.resolver.setMethodProperty("serviceMethod");
        MuleEventContext ctx = this.createMuleEventContext("blah", Collections.singletonMap("serviceMethod", "noMethod"));
        InvocationResult result = this.resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx, Event.builder((Event)ctx.getEvent()));
        this.assertInvocationFailed(result);
    }

    @Test
    public void testMethodPropertyFail() throws Exception {
        this.resolver.setMethodProperty("serviceMethod");
        MuleEventContext ctx = this.createMuleEventContext("blah", Collections.singletonMap("myMethod", "someBusinessMethod"));
        InvocationResult result = this.resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx, Event.builder((Event)ctx.getEvent()));
        this.assertInvocationFailed(result);
    }

    @Test
    public void testMethodPropertyMismatch() throws Exception {
        MuleEventContext ctx = this.createMuleEventContext("blah", Collections.singletonMap("method", "noMethod"));
        InvocationResult result = this.resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx, Event.builder((Event)ctx.getEvent()));
        this.assertInvocationFailed(result);
    }

    @Test
    public void testMethodPropertyParameterAssignableFromPayload() throws Exception {
        MuleEventContext ctx = this.createMuleEventContext(new Apple(), Collections.singletonMap("method", "wash"));
        InvocationResult result = this.resolver.invoke((Object)new TestFruitCleaner(), ctx, Event.builder((Event)ctx.getEvent()));
        this.assertInvocationWasSuccessful(result);
    }

    private void assertInvocationWasSuccessful(InvocationResult result) {
        Assert.assertEquals((Object)InvocationResult.State.SUCCESSFUL, (Object)result.getState());
    }

    private void assertInvocationFailed(InvocationResult result) {
        Assert.assertEquals((Object)InvocationResult.State.FAILED, (Object)result.getState());
    }

    private MuleEventContext createMuleEventContext(Object payload, Map<String, Serializable> inboundProperties) throws Exception {
        Flow flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
        return new DefaultMuleEventContext((FlowConstruct)flowConstruct, Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message((Message)InternalMessage.builder().payload(payload).inboundProperties(inboundProperties).build()).build());
    }

    public static class TestFruitCleaner {
        public void wash(Fruit fruit) {
        }

        public void polish(Fruit fruit) {
        }
    }
}

