/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.mule.model;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.DefaultMuleEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.model.InvocationResult;
import org.mule.runtime.core.api.model.resolvers.NoArgumentsEntryPointResolver;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.InvalidSatsuma;

public class NoArgsEntryPointResolverTestCase
extends AbstractMuleContextTestCase {
    private FlowConstruct flowConstruct;

    @Before
    public void before() throws Exception {
        this.flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
    }

    @Test
    public void testExplicitMethodMatch() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        resolver.addMethod("bite");
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"blah")).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new InvalidSatsuma(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testExplicitMethodMatch2() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        resolver.addMethod("wash");
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"blah")).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new Apple(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testDynamicMethodMatchFail() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"blah")).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new Apple(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((String)"Apple service has a number of matching method, so should have failed", (Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    @Test
    public void testDynamicMethodMatchPass() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"blah")).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new InvalidSatsuma(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testDynamicMethodMatchFailOnWildcardMatch() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        Assert.assertTrue((boolean)resolver.removeIgnoredMethod("is*"));
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"blah")).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new InvalidSatsuma(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((String)"Satsuma service has a number of matching method, so should have failed", (Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    @Test
    public void testExplicitMethodMatchAndNullPayload() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        resolver.addMethod("wash");
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of(null)).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new Apple(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }
}

