/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.mule.model;

import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.cglib.proxy.Callback;
import org.mockito.cglib.proxy.Enhancer;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.cglib.proxy.MethodProxy;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.DefaultMuleEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.model.InvocationResult;
import org.mule.runtime.core.api.model.resolvers.ReflectionEntryPointResolver;
import org.mule.runtime.core.mule.model.MultiplePayloadsTestObject;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.FruitLover;
import org.mule.tck.testmodels.fruit.Kiwi;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.WaterMelon;

public class ReflectionEntryPointResolverTestCase
extends AbstractMuleContextTestCase {
    private FlowConstruct flowConstruct;

    @Before
    public void before() throws Exception {
        this.flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
    }

    @Test
    public void testExplicitMethodMatch() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"blah")).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new WaterMelon(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testExplicitMethodMatchComplexObject() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new FruitLover("Mmmm"))).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new FruitBowl(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testMethodMatchWithArguments() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new Object[]{new Apple(), new Banana()})).build());
        InvocationResult result = resolver.invoke((Object)new FruitBowl(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
        Assert.assertTrue((boolean)(result.getResult() instanceof Fruit[]));
        Assert.assertTrue((boolean)(((Fruit[])result.getResult())[0] instanceof Apple));
        Assert.assertTrue((boolean)(((Fruit[])result.getResult())[1] instanceof Banana));
        Assert.assertEquals((Object)"addAppleAndBanana", (Object)result.getMethodCalled());
        eventContext = new DefaultMuleEventContext(this.flowConstruct, Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new Object[]{new Banana(), new Apple()})).build());
        result = resolver.invoke((Object)new FruitBowl(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
        Assert.assertTrue((boolean)(result.getResult() instanceof Fruit[]));
        Assert.assertTrue((boolean)(((Fruit[])result.getResult())[0] instanceof Banana));
        Assert.assertTrue((boolean)(((Fruit[])result.getResult())[1] instanceof Apple));
        Assert.assertEquals((Object)"addBananaAndApple", (Object)result.getMethodCalled());
    }

    @Test
    public void testExplicitMethodMatchSetArrayFail() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new Fruit[]{new Apple(), new Orange()})).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new FruitBowl(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((String)"Test should have failed because the arguments were not wrapped properly: ", (Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    @Test
    public void testExplicitMethodMatchSetArrayPass() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)new Object[]{new Fruit[]{new Apple(), new Orange()}})).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new FruitBowl(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testFailEntryPointMultiplePayloadMatches() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        Event testEvent = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"Hello")).build();
        Event.setCurrentEvent((Event)testEvent);
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, Event.getCurrentEvent());
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), (MuleEventContext)eventContext, Event.builder((Event)Event.getCurrentEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    @Test
    public void testMatchOnNoArgs() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of(null)).build();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke((Object)new Kiwi(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.FAILED);
        resolver.setAcceptVoidMethods(true);
        result = resolver.invoke((Object)new Kiwi(), (MuleEventContext)eventContext, Event.builder((Event)eventContext.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
        Assert.assertEquals((Object)"bite", (Object)result.getMethodCalled());
    }

    @Test
    public void testAnnotatedMethodOnProxyWithMethodSet() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        Enhancer e = new Enhancer();
        e.setSuperclass(WaterMelon.class);
        e.setCallback((Callback)new DummyMethodCallback());
        Object proxy = e.create();
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"Blah")).build();
        DefaultMuleEventContext context = new DefaultMuleEventContext(this.flowConstruct, event);
        InvocationResult result = resolver.invoke(proxy, (MuleEventContext)context, Event.builder((Event)context.getEvent()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    private class DummyMethodCallback
    implements MethodInterceptor {
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            System.out.println("before: " + method.getName());
            Object r = proxy.invokeSuper(obj, args);
            System.out.println("after: " + method.getName());
            return r;
        }
    }
}

