/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.mule.security;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.security.SecretKeyEncryptionStrategy;
import org.mule.runtime.core.security.SecretKeyFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class SecretKeyEncryptionStrategyTestCase
extends AbstractMuleTestCase {
    private static final String TRIPLE_DES_KEY = RandomStringUtils.randomAlphabetic((int)24);

    @Test
    public void testRoundTripEncryptionBlowfish() throws Exception {
        SecretKeyEncryptionStrategy ske = new SecretKeyEncryptionStrategy();
        ske.setAlgorithm("Blowfish");
        ske.setKey("shhhhh");
        ske.initialise();
        byte[] b = ske.encrypt("hello".getBytes(), null);
        Assert.assertNotSame((Object)new String(b), (Object)"hello");
        String s = new String(ske.decrypt(b, null), "UTF-8");
        Assert.assertEquals((Object)"hello", (Object)s);
    }

    @Test
    public void testRoundTripEncryptionBlowfishWithKeyFactory() throws Exception {
        SecretKeyEncryptionStrategy ske = new SecretKeyEncryptionStrategy();
        ske.setAlgorithm("Blowfish");
        ske.setKeyFactory(new SecretKeyFactory(){

            public byte[] getKey() {
                return "shhhh".getBytes();
            }
        });
        ske.initialise();
        byte[] b = ske.encrypt("hello".getBytes(), null);
        Assert.assertNotSame((Object)new String(b), (Object)"hello");
        String s = new String(ske.decrypt(b, null), "UTF-8");
        Assert.assertEquals((Object)"hello", (Object)s);
    }

    @Test
    public void testRoundTripEncryptionTripleDES() throws Exception {
        SecretKeyEncryptionStrategy ske = new SecretKeyEncryptionStrategy();
        ske.setAlgorithm("TripleDES");
        ske.setKey(TRIPLE_DES_KEY);
        ske.initialise();
        byte[] b = ske.encrypt("hello".getBytes(), null);
        Assert.assertNotSame((Object)new String(b), (Object)"hello");
        String s = new String(ske.decrypt(b, null), "UTF-8");
        Assert.assertEquals((Object)"hello", (Object)s);
    }
}

