/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.policy.DefaultPolicyStateHandler;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.core.policy.PolicyStateHandler;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.message.StringAttributes;

public abstract class AbstractPolicyProcessorTestCase
extends AbstractMuleTestCase {
    private static final String INIT_VAR_NAME = "initVarName";
    private static final String INIT_VAR_VALUE = "initVarValue";
    private static final String ADDED_VAR_NAME = "addedVarName";
    private static final String ADDED_VAR_VALUE = "addedVarValue";
    private static final String PAYLOAD = "payload";
    private static final Message MESSAGE = Message.builder().payload((Object)"payload").attributes((Object)new StringAttributes()).build();
    protected Policy policy = (Policy)Mockito.mock(Policy.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    protected Processor flowProcessor = (Processor)Mockito.mock(Processor.class);
    protected PolicyStateHandler policyStateHandler;
    private ArgumentCaptor<Event> eventCaptor = ArgumentCaptor.forClass(Event.class);
    private FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Processor policyProcessor;
    private String executionId;
    private Event initialEvent;

    @Before
    public void before() {
        this.executionId = UUID.randomUUID().toString();
        this.initialEvent = this.createTestEvent();
        this.policyStateHandler = new DefaultPolicyStateHandler();
        this.policyProcessor = this.getProcessor();
    }

    protected abstract Processor getProcessor();

    @Test
    public void variablesAddedInNextProcessorNotPropagated() throws MuleException {
        Event initialEventWithVars = Event.builder((Event)this.initialEvent).addVariable(INIT_VAR_NAME, (Object)INIT_VAR_VALUE).build();
        Event modifiedVarsEvent = Event.builder((Event)this.initialEvent).addVariable(ADDED_VAR_NAME, (Object)ADDED_VAR_VALUE).build();
        Mockito.when((Object)this.flowProcessor.process((Event)Matchers.any())).thenReturn((Object)modifiedVarsEvent);
        Mockito.when((Object)this.policy.getPolicyChain().process((Event)Matchers.any())).thenAnswer(invocation -> this.policyStateHandler.retrieveNextOperation(this.executionId).process(initialEventWithVars));
        Event resultEvent = this.policyProcessor.process(initialEventWithVars);
        Assert.assertEquals((Object)resultEvent.getVariableNames(), (Object)initialEventWithVars.getVariableNames());
    }

    @Test
    public void variablesAddedBeforeNextProcessorNotPropagatedToIt() throws MuleException {
        Event initialEventWithVars = Event.builder((Event)this.initialEvent).addVariable(INIT_VAR_NAME, (Object)INIT_VAR_VALUE).build();
        Event modifiedVarsEvent = Event.builder((Event)this.initialEvent).addVariable(ADDED_VAR_NAME, (Object)ADDED_VAR_VALUE).build();
        Mockito.when((Object)this.flowProcessor.process((Event)Matchers.any())).thenReturn((Object)initialEventWithVars);
        Mockito.when((Object)this.policy.getPolicyChain().process((Event)Matchers.any())).thenAnswer(invocation -> this.policyStateHandler.retrieveNextOperation(this.executionId).process(modifiedVarsEvent));
        this.policyProcessor.process(initialEventWithVars);
        ((Processor)Mockito.verify((Object)this.flowProcessor)).process((Event)this.eventCaptor.capture());
        Assert.assertEquals((Object)((Event)this.eventCaptor.getValue()).getVariableNames(), (Object)initialEventWithVars.getVariableNames());
    }

    @Test
    public void messageModifiedByNextProcessorIsPropagated() throws MuleException {
        Event modifiedMessageEvent = Event.builder((Event)this.initialEvent).message(MESSAGE).build();
        Mockito.when((Object)this.flowProcessor.process((Event)Matchers.any())).thenReturn((Object)modifiedMessageEvent);
        Mockito.when((Object)this.policy.getPolicyChain().process((Event)Matchers.any())).thenAnswer(invocation -> this.policyStateHandler.retrieveNextOperation(this.executionId).process(this.initialEvent));
        Event resultEvent = this.policyProcessor.process(this.initialEvent);
        Assert.assertEquals((Object)resultEvent.getMessage(), (Object)MESSAGE);
    }

    @Test
    public void messageModifiedBeforeNextProcessorIsPropagatedToIt() throws MuleException {
        Event modifiedMessageEvent = Event.builder((Event)this.initialEvent).message(MESSAGE).build();
        Mockito.when((Object)this.flowProcessor.process((Event)Matchers.any())).thenReturn((Object)modifiedMessageEvent);
        Mockito.when((Object)this.policy.getPolicyChain().process((Event)Matchers.any())).thenAnswer(invocation -> this.policyStateHandler.retrieveNextOperation(this.executionId).process(modifiedMessageEvent));
        this.policyProcessor.process(this.initialEvent);
        ((Processor)Mockito.verify((Object)this.flowProcessor)).process((Event)this.eventCaptor.capture());
        Assert.assertEquals((Object)((Event)this.eventCaptor.getValue()).getMessage(), (Object)MESSAGE);
    }

    @Test
    public void sessionModifiedByNextProcessorIsPropagated() throws MuleException {
        DefaultMuleSession session = new DefaultMuleSession();
        Event modifiedSessionEvent = Event.builder((Event)this.initialEvent).session((MuleSession)session).build();
        Mockito.when((Object)this.flowProcessor.process((Event)Matchers.any())).thenReturn((Object)modifiedSessionEvent);
        Mockito.when((Object)this.policy.getPolicyChain().process((Event)Matchers.any())).thenAnswer(invocation -> this.policyStateHandler.retrieveNextOperation(this.executionId).process(this.initialEvent));
        Event resultEvent = this.policyProcessor.process(this.initialEvent);
        Assert.assertEquals((Object)resultEvent.getSession(), (Object)session);
    }

    @Test
    public void sessionModifiedBeforeNextProcessorIsPropagatedToIt() throws MuleException {
        DefaultMuleSession session = new DefaultMuleSession();
        Event modifiedSessionEvent = Event.builder((Event)this.initialEvent).session((MuleSession)session).build();
        Mockito.when((Object)this.flowProcessor.process((Event)Matchers.any())).thenReturn((Object)modifiedSessionEvent);
        Mockito.when((Object)this.policy.getPolicyChain().process((Event)Matchers.any())).thenAnswer(invocation -> this.policyStateHandler.retrieveNextOperation(this.executionId).process(modifiedSessionEvent));
        this.policyProcessor.process(this.initialEvent);
        ((Processor)Mockito.verify((Object)this.flowProcessor)).process((Event)this.eventCaptor.capture());
        Assert.assertEquals((Object)((Event)this.eventCaptor.getValue()).getSession(), (Object)session);
    }

    private Event createTestEvent() {
        Mockito.when((Object)this.mockFlowConstruct.getUniqueIdString()).thenReturn((Object)this.executionId);
        return Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.mockFlowConstruct, (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)"http"))).message(Message.builder().nullPayload().build()).build();
    }
}

