/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.policy.CompositeOperationPolicy;
import org.mule.runtime.core.policy.OperationExecutionFunction;
import org.mule.runtime.core.policy.OperationParametersProcessor;
import org.mule.runtime.core.policy.OperationPolicyProcessorFactory;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class CompositeOperationPolicyTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private CompositeOperationPolicy compositeOperationPolicy;
    private Optional<OperationPolicyParametersTransformer> operationPolicyParametersTransformer = Optional.of(Mockito.mock(OperationPolicyParametersTransformer.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
    private OperationParametersProcessor operationParametersProcessor = (OperationParametersProcessor)Mockito.mock(OperationParametersProcessor.class);
    private Policy firstPolicy = (Policy)Mockito.mock(Policy.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Policy secondPolicy = (Policy)Mockito.mock(Policy.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Event initialEvent;
    private Event firstPolicyProcessorResultEvent;
    private Event secondPolicyResultProcessorEvent;
    private OperationExecutionFunction operationExecutionFunction = (OperationExecutionFunction)Mockito.mock(OperationExecutionFunction.class);
    private Event nextProcessResultEvent;
    private OperationPolicyProcessorFactory operationPolicyProcessorFactory = (OperationPolicyProcessorFactory)Mockito.mock(OperationPolicyProcessorFactory.class);
    private Processor firstPolicyOperationPolicyProcessor = (Processor)Mockito.mock(Processor.class);
    private Processor secondPolicyOperationPolicyProcessor = (Processor)Mockito.mock(Processor.class);

    @Before
    public void setUp() throws Exception {
        this.initialEvent = this.createTestEvent();
        this.firstPolicyProcessorResultEvent = this.createTestEvent();
        this.secondPolicyResultProcessorEvent = this.createTestEvent();
        this.nextProcessResultEvent = this.createTestEvent();
        Mockito.when((Object)this.operationPolicyParametersTransformer.get().fromParametersToMessage((Map)Matchers.any())).thenReturn((Object)Message.of(null));
        Mockito.when((Object)this.operationExecutionFunction.execute((Map)Matchers.any(), (Event)Matchers.any())).thenReturn((Object)this.nextProcessResultEvent);
        Mockito.when((Object)this.firstPolicy.getPolicyChain().process((Event)Matchers.any())).thenReturn((Object)this.firstPolicyProcessorResultEvent);
        Mockito.when((Object)this.secondPolicy.getPolicyChain().process((Event)Matchers.any())).thenReturn((Object)this.secondPolicyResultProcessorEvent);
        Mockito.when((Object)this.operationPolicyProcessorFactory.createOperationPolicy((Policy)Matchers.same((Object)this.secondPolicy), (Processor)Matchers.any())).thenReturn((Object)this.secondPolicyOperationPolicyProcessor);
        Mockito.when((Object)this.operationPolicyProcessorFactory.createOperationPolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any())).thenAnswer(policyFactoryInvocation -> {
            Mockito.when((Object)this.firstPolicyOperationPolicyProcessor.process((Event)Matchers.any())).thenAnswer(policyProcessorInvocation -> {
                ((Processor)policyFactoryInvocation.getArguments()[1]).process(this.initialEvent);
                return this.firstPolicyProcessorResultEvent;
            });
            return this.firstPolicyOperationPolicyProcessor;
        });
        Mockito.when((Object)this.operationPolicyProcessorFactory.createOperationPolicy((Policy)Matchers.same((Object)this.secondPolicy), (Processor)Matchers.any())).thenAnswer(policyFactoryInvocation -> {
            Mockito.when((Object)this.secondPolicyOperationPolicyProcessor.process((Event)Matchers.any())).thenAnswer(policyProcessorInvocation -> {
                ((Processor)policyFactoryInvocation.getArguments()[1]).process(this.initialEvent);
                return this.secondPolicyResultProcessorEvent;
            });
            return this.secondPolicyOperationPolicyProcessor;
        });
    }

    @Test
    public void singlePolicy() throws Exception {
        this.compositeOperationPolicy = new CompositeOperationPolicy(Arrays.asList(this.firstPolicy), this.operationPolicyParametersTransformer, this.operationPolicyProcessorFactory, this.operationParametersProcessor, this.operationExecutionFunction);
        Event result = this.compositeOperationPolicy.process(this.initialEvent);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.nextProcessResultEvent));
        ((OperationExecutionFunction)Mockito.verify((Object)this.operationExecutionFunction)).execute((Map)Matchers.any(), (Event)Matchers.same((Object)this.initialEvent));
        ((OperationPolicyProcessorFactory)Mockito.verify((Object)this.operationPolicyProcessorFactory)).createOperationPolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any());
        ((Processor)Mockito.verify((Object)this.firstPolicyOperationPolicyProcessor)).process((Event)Matchers.any());
    }

    @Test
    public void compositePolicy() throws Exception {
        this.compositeOperationPolicy = new CompositeOperationPolicy(Arrays.asList(this.firstPolicy, this.secondPolicy), this.operationPolicyParametersTransformer, this.operationPolicyProcessorFactory, this.operationParametersProcessor, this.operationExecutionFunction);
        Event result = this.compositeOperationPolicy.process(this.initialEvent);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.nextProcessResultEvent));
        ((OperationExecutionFunction)Mockito.verify((Object)this.operationExecutionFunction)).execute((Map)Matchers.any(), (Event)Matchers.same((Object)this.initialEvent));
        ((OperationPolicyProcessorFactory)Mockito.verify((Object)this.operationPolicyProcessorFactory)).createOperationPolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any());
        ((OperationPolicyProcessorFactory)Mockito.verify((Object)this.operationPolicyProcessorFactory)).createOperationPolicy((Policy)Matchers.same((Object)this.secondPolicy), (Processor)Matchers.any());
        ((Processor)Mockito.verify((Object)this.firstPolicyOperationPolicyProcessor)).process((Event)Matchers.any());
        ((Processor)Mockito.verify((Object)this.firstPolicyOperationPolicyProcessor)).process((Event)Matchers.any());
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptyPolicyList() throws Exception {
        this.compositeOperationPolicy = new CompositeOperationPolicy(Collections.emptyList(), this.operationPolicyParametersTransformer, this.operationPolicyProcessorFactory, this.operationParametersProcessor, this.operationExecutionFunction);
    }

    @Test
    public void policyExecutionFailurePropagates() throws Exception {
        RuntimeException policyException = new RuntimeException("policy failure");
        Mockito.when((Object)this.firstPolicyOperationPolicyProcessor.process((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{policyException});
        this.compositeOperationPolicy = new CompositeOperationPolicy(Arrays.asList(this.firstPolicy, this.secondPolicy), this.operationPolicyParametersTransformer, this.operationPolicyProcessorFactory, this.operationParametersProcessor, this.operationExecutionFunction);
        this.expectedException.expect(MuleException.class);
        this.expectedException.expectCause(Is.is((Object)policyException));
        this.compositeOperationPolicy.process(this.initialEvent);
    }

    @Test
    public void nextProcessorExecutionFailurePropagates() throws Exception {
        RuntimeException policyException = new RuntimeException("policy failure");
        Mockito.when((Object)this.operationExecutionFunction.execute((Map)Matchers.any(), (Event)Matchers.any())).thenThrow(new Throwable[]{policyException});
        this.compositeOperationPolicy = new CompositeOperationPolicy(Arrays.asList(this.firstPolicy, this.secondPolicy), this.operationPolicyParametersTransformer, this.operationPolicyProcessorFactory, this.operationParametersProcessor, this.operationExecutionFunction);
        this.expectedException.expect(MuleException.class);
        this.expectedException.expectCause(Is.is((Object)policyException));
        this.compositeOperationPolicy.process(this.initialEvent);
    }

    private Event createTestEvent() {
        return Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.mockFlowConstruct, (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)"http"))).message(Message.of(null)).build();
    }
}

