/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.policy.CompositeSourcePolicy;
import org.mule.runtime.core.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.core.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.policy.SuccessSourcePolicyResult;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class CompositeSourcePolicyTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private CompositeSourcePolicy compositeSourcePolicy;
    private FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Optional<SourcePolicyParametersTransformer> sourcePolicyParametersTransformer = Optional.of(Mockito.mock(SourcePolicyParametersTransformer.class));
    private MessageSourceResponseParametersProcessor sourceParametersTransformer = (MessageSourceResponseParametersProcessor)Mockito.mock(MessageSourceResponseParametersProcessor.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Policy firstPolicy = (Policy)Mockito.mock(Policy.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Policy secondPolicy = (Policy)Mockito.mock(Policy.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Event initialEvent;
    private Event modifiedEvent;
    private Event firstPolicyResultEvent;
    private Event secondPolicyResultEvent;
    private Processor flowExecutionProcessor = (Processor)Mockito.mock(Processor.class);
    private Event nextProcessResultEvent = (Event)Mockito.mock(Event.class);
    private SourcePolicyProcessorFactory sourcePolicyProcessorFactory = (SourcePolicyProcessorFactory)Mockito.mock(SourcePolicyProcessorFactory.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Processor firstPolicySourcePolicyProcessor = (Processor)Mockito.mock(Processor.class);
    private Processor secondPolicySourcePolicyProcessor = (Processor)Mockito.mock(Processor.class);

    @Before
    public void setUp() throws Exception {
        this.initialEvent = this.createTestEvent();
        this.modifiedEvent = this.createTestEvent();
        this.firstPolicyResultEvent = this.createTestEvent();
        this.secondPolicyResultEvent = this.createTestEvent();
        Mockito.when((Object)this.nextProcessResultEvent.getMessage()).thenReturn(Mockito.mock(Message.class));
        Mockito.when((Object)this.flowExecutionProcessor.process((Event)Matchers.any())).thenReturn((Object)this.nextProcessResultEvent);
        Mockito.when((Object)this.firstPolicy.getPolicyChain().process((Event)Matchers.any())).thenReturn((Object)this.firstPolicyResultEvent);
        Mockito.when((Object)this.secondPolicy.getPolicyChain().process((Event)Matchers.any())).thenReturn((Object)this.secondPolicyResultEvent);
        Mockito.when((Object)this.sourcePolicyProcessorFactory.createSourcePolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any())).thenAnswer(policyFactoryInvocation -> {
            Mockito.when((Object)this.firstPolicySourcePolicyProcessor.process((Event)Matchers.any())).thenAnswer(policyProcessorInvocation -> {
                ((Processor)policyFactoryInvocation.getArguments()[1]).process(this.modifiedEvent);
                return this.firstPolicyResultEvent;
            });
            return this.firstPolicySourcePolicyProcessor;
        });
        Mockito.when((Object)this.sourcePolicyProcessorFactory.createSourcePolicy((Policy)Matchers.same((Object)this.secondPolicy), (Processor)Matchers.any())).thenAnswer(policyFactoryInvocation -> {
            Mockito.when((Object)this.secondPolicySourcePolicyProcessor.process((Event)Matchers.any())).thenAnswer(policyProcessorInvocation -> {
                ((Processor)policyFactoryInvocation.getArguments()[1]).process(this.modifiedEvent);
                return this.secondPolicyResultEvent;
            });
            return this.secondPolicySourcePolicyProcessor;
        });
    }

    @Test
    public void singlePolicy() throws Exception {
        this.compositeSourcePolicy = new CompositeSourcePolicy(Arrays.asList(this.firstPolicy), this.sourcePolicyParametersTransformer, this.sourcePolicyProcessorFactory, this.flowExecutionProcessor, this.sourceParametersTransformer);
        Either sourcePolicyResult = this.compositeSourcePolicy.process(this.initialEvent);
        Assert.assertThat((Object)sourcePolicyResult.isRight(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SuccessSourcePolicyResult)sourcePolicyResult.getRight()).getFlowExecutionResult(), (Matcher)Is.is((Object)this.firstPolicyResultEvent));
        ((Processor)Mockito.verify((Object)this.flowExecutionProcessor)).process(this.modifiedEvent);
        ((SourcePolicyProcessorFactory)Mockito.verify((Object)this.sourcePolicyProcessorFactory)).createSourcePolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any());
        ((Processor)Mockito.verify((Object)this.firstPolicySourcePolicyProcessor)).process((Event)Matchers.same((Object)this.initialEvent));
    }

    @Test
    public void compositePolicy() throws Exception {
        this.compositeSourcePolicy = new CompositeSourcePolicy(Arrays.asList(this.firstPolicy, this.secondPolicy), this.sourcePolicyParametersTransformer, this.sourcePolicyProcessorFactory, this.flowExecutionProcessor, this.sourceParametersTransformer);
        Either sourcePolicyResult = this.compositeSourcePolicy.process(this.initialEvent);
        Assert.assertThat((Object)sourcePolicyResult.isRight(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SuccessSourcePolicyResult)sourcePolicyResult.getRight()).getFlowExecutionResult(), (Matcher)Is.is((Object)this.firstPolicyResultEvent));
        ((Processor)Mockito.verify((Object)this.flowExecutionProcessor)).process(this.modifiedEvent);
        ((SourcePolicyProcessorFactory)Mockito.verify((Object)this.sourcePolicyProcessorFactory)).createSourcePolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any());
        ((SourcePolicyProcessorFactory)Mockito.verify((Object)this.sourcePolicyProcessorFactory)).createSourcePolicy((Policy)Matchers.same((Object)this.secondPolicy), (Processor)Matchers.any());
        ((Processor)Mockito.verify((Object)this.firstPolicySourcePolicyProcessor)).process(this.initialEvent);
        ((Processor)Mockito.verify((Object)this.secondPolicySourcePolicyProcessor)).process(this.modifiedEvent);
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptyPolicyList() throws Exception {
        this.compositeSourcePolicy = new CompositeSourcePolicy(Collections.emptyList(), this.sourcePolicyParametersTransformer, this.sourcePolicyProcessorFactory, this.flowExecutionProcessor, this.sourceParametersTransformer);
    }

    @Test
    public void policyExecutionFailurePropagates() throws Exception {
        RuntimeException policyException = new RuntimeException("policy failure");
        Mockito.when((Object)this.secondPolicySourcePolicyProcessor.process((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{policyException});
        this.compositeSourcePolicy = new CompositeSourcePolicy(Arrays.asList(this.firstPolicy, this.secondPolicy), this.sourcePolicyParametersTransformer, this.sourcePolicyProcessorFactory, this.flowExecutionProcessor, this.sourceParametersTransformer);
        this.expectedException.expect(MuleException.class);
        this.expectedException.expectCause(Is.is((Object)policyException));
        this.compositeSourcePolicy.process(this.initialEvent);
    }

    @Test
    public void nextProcessorExecutionFailurePropagates() throws Exception {
        RuntimeException policyException = new RuntimeException("policy failure");
        Mockito.when((Object)this.flowExecutionProcessor.process((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{policyException});
        this.compositeSourcePolicy = new CompositeSourcePolicy(Arrays.asList(this.firstPolicy, this.secondPolicy), this.sourcePolicyParametersTransformer, this.sourcePolicyProcessorFactory, this.flowExecutionProcessor, this.sourceParametersTransformer);
        this.expectedException.expect(MuleException.class);
        this.expectedException.expectCause(Is.is((Object)policyException));
        this.compositeSourcePolicy.process(this.initialEvent);
    }

    private Event createTestEvent() {
        return Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.mockFlowConstruct, (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)"http"))).message(Message.builder().nullPayload().build()).build();
    }
}

