/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.policy.DefaultPolicyStateHandler;
import org.mule.runtime.core.policy.PolicyStateId;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultPolicyStateHandlerTestCase
extends AbstractMuleTestCase {
    private static final String TEST_EXECUTION_ID = "test-id";
    private static final String TEST_EXECUTION_ID2 = "test-id2";
    private static final String TEST_POLICY_ID = "test-policy-id";
    private static final String TEST_POLICY_ID2 = "test-policy-id2";
    private Event eventTestExecutionId = (Event)Mockito.mock(Event.class);
    private Event eventTestExecutionId2 = (Event)Mockito.mock(Event.class);
    private DefaultPolicyStateHandler defaultPolicyStateHandler = new DefaultPolicyStateHandler();

    @Test
    public void destroyStateWithNoData() {
        this.defaultPolicyStateHandler.destroyState(TEST_EXECUTION_ID);
    }

    @Test
    public void samePolicyDifferentExecutionId() {
        PolicyStateId policyStateExecutionId = new PolicyStateId(TEST_EXECUTION_ID, TEST_POLICY_ID);
        PolicyStateId policyStateExecutionId2 = new PolicyStateId(TEST_EXECUTION_ID2, TEST_POLICY_ID);
        this.defaultPolicyStateHandler.updateState(policyStateExecutionId, this.eventTestExecutionId);
        this.defaultPolicyStateHandler.updateState(policyStateExecutionId2, this.eventTestExecutionId2);
        Assert.assertThat(this.defaultPolicyStateHandler.getLatestState(policyStateExecutionId).get(), (Matcher)Is.is((Object)this.eventTestExecutionId));
        Assert.assertThat(this.defaultPolicyStateHandler.getLatestState(policyStateExecutionId2).get(), (Matcher)Is.is((Object)this.eventTestExecutionId2));
    }

    @Test
    public void sameExecutionDifferentPolicyId() {
        PolicyStateId policy1StateExecutionId = new PolicyStateId(TEST_EXECUTION_ID, TEST_POLICY_ID);
        PolicyStateId policy2StateExecutionId = new PolicyStateId(TEST_EXECUTION_ID, TEST_POLICY_ID2);
        this.defaultPolicyStateHandler.updateState(policy1StateExecutionId, this.eventTestExecutionId);
        this.defaultPolicyStateHandler.updateState(policy2StateExecutionId, this.eventTestExecutionId2);
        Assert.assertThat(this.defaultPolicyStateHandler.getLatestState(policy1StateExecutionId).get(), (Matcher)Is.is((Object)this.eventTestExecutionId));
        Assert.assertThat(this.defaultPolicyStateHandler.getLatestState(policy2StateExecutionId).get(), (Matcher)Is.is((Object)this.eventTestExecutionId2));
    }

    @Test
    public void destroyState() {
        PolicyStateId policyStateExecutionId = new PolicyStateId(TEST_EXECUTION_ID, TEST_POLICY_ID);
        this.defaultPolicyStateHandler.destroyState(policyStateExecutionId.getExecutionIndentifier());
        Assert.assertThat((Object)this.defaultPolicyStateHandler.getLatestState(policyStateExecutionId).isPresent(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.defaultPolicyStateHandler.retrieveNextOperation(policyStateExecutionId.getExecutionIndentifier()), (Matcher)IsNull.nullValue());
    }
}

