/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.processor.AbstractMuleObjectOwner;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class AbstractMuleObjectOwnerTestCase {
    @Mock
    private TestClass mockObject1;
    @Mock
    private TestClass mockObject2;
    @Mock
    private MuleContext mockMuleContext;
    @Mock
    private FlowConstruct mockFlowConstruct;
    private AbstractMuleObjectOwner<TestClass> abstractMuleObjectOwner;

    @Before
    public void before() {
        this.abstractMuleObjectOwner = new AbstractMuleObjectOwner<TestClass>(){

            protected List<TestClass> getOwnedObjects() {
                return Arrays.asList(AbstractMuleObjectOwnerTestCase.this.mockObject1, AbstractMuleObjectOwnerTestCase.this.mockObject2);
            }
        };
        this.abstractMuleObjectOwner.setFlowConstruct(this.mockFlowConstruct);
        this.abstractMuleObjectOwner.setMuleContext(this.mockMuleContext);
    }

    @Test
    public void testInitialise() throws Exception {
        this.abstractMuleObjectOwner.initialise();
        ((TestClass)Mockito.verify((Object)this.mockObject1)).initialise();
        ((TestClass)Mockito.verify((Object)this.mockObject2)).initialise();
        ((TestClass)Mockito.verify((Object)this.mockObject1, (VerificationMode)Mockito.times((int)2))).setMuleContext(this.mockMuleContext);
        ((TestClass)Mockito.verify((Object)this.mockObject2, (VerificationMode)Mockito.times((int)2))).setMuleContext(this.mockMuleContext);
        ((TestClass)Mockito.verify((Object)this.mockObject1, (VerificationMode)Mockito.times((int)2))).setFlowConstruct(this.mockFlowConstruct);
        ((TestClass)Mockito.verify((Object)this.mockObject2, (VerificationMode)Mockito.times((int)2))).setFlowConstruct(this.mockFlowConstruct);
    }

    @Test
    public void testDispose() throws Exception {
        this.abstractMuleObjectOwner.dispose();
        ((TestClass)Mockito.verify((Object)this.mockObject1)).dispose();
        ((TestClass)Mockito.verify((Object)this.mockObject2)).dispose();
    }

    @Test
    public void testStart() throws Exception {
        this.abstractMuleObjectOwner.start();
        ((TestClass)Mockito.verify((Object)this.mockObject1)).start();
        ((TestClass)Mockito.verify((Object)this.mockObject2)).start();
    }

    @Test
    public void testStop() throws Exception {
        this.abstractMuleObjectOwner.stop();
        ((TestClass)Mockito.verify((Object)this.mockObject1)).stop();
        ((TestClass)Mockito.verify((Object)this.mockObject2)).stop();
    }

    public class TestClass
    implements Lifecycle,
    MuleContextAware,
    FlowConstructAware {
        public void dispose() {
        }

        public void setFlowConstruct(FlowConstruct flowConstruct) {
        }

        public void initialise() throws InitialisationException {
        }

        public void setMuleContext(MuleContext context) {
        }

        public void start() throws MuleException {
        }

        public void stop() throws MuleException {
        }
    }
}

