/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.beans.ExceptionListener;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.util.concurrent.Latch;
import org.mule.runtime.core.processor.AsyncDelegateMessageProcessor;
import org.mule.runtime.core.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class AsyncDelegateMessageProcessorTestCase
extends AbstractReactiveProcessorTestCase
implements ExceptionListener {
    protected AsyncDelegateMessageProcessor messageProcessor;
    protected TestListener target = new TestListener();
    protected Exception exceptionThrown;
    protected Latch latch = new Latch();
    protected Latch asyncEntrylatch = new Latch();
    private Flow flow;
    @Rule
    public ExpectedException expected;

    public AsyncDelegateMessageProcessorTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
        this.setStartContext(true);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.flow = Flow.builder((String)"flow", (MuleContext)muleContext).build();
        this.flow.initialise();
        this.flow.start();
        this.messageProcessor = this.createAsyncDelegatMessageProcessor(this.target, (FlowConstruct)this.flow);
        this.messageProcessor.start();
    }

    protected void doTearDown() throws Exception {
        this.messageProcessor.stop();
        this.messageProcessor.dispose();
        this.flow.stop();
        this.flow.dispose();
        super.doTearDown();
    }

    @Test
    public void process() throws Exception {
        Event request = this.testEvent();
        Event result = this.process((Processor)this.messageProcessor, request);
        request.getContext().success(result);
        this.assertCompletionNotDone(request.getContext());
        this.asyncEntrylatch.countDown();
        Assert.assertThat((Object)this.latch.await(30000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
        Mono.from((Publisher)this.target.sensedEvent.getContext().getCompletionPublisher()).block(Duration.ofMillis(500L));
        Assert.assertThat((Object)this.target.sensedEvent, (Matcher)CoreMatchers.notNullValue());
        Mono.from((Publisher)request.getContext().getCompletionPublisher()).block(Duration.ofMillis(500L));
        this.assertCompletionDone(this.target.sensedEvent.getContext());
        this.assertCompletionDone(request.getContext());
        this.assertTargetEvent(request);
        this.assertResponse(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void processWithTx() throws Exception {
        TestTransaction transaction = new TestTransaction(muleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)transaction);
        try {
            Event request = this.testEvent();
            Event result = this.process((Processor)this.messageProcessor, request);
            this.asyncEntrylatch.countDown();
            Assert.assertThat((Object)this.latch.await(30000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
            this.assertTargetEvent(request);
            this.assertResponse(result);
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction((Transaction)transaction);
        }
    }

    @Test
    public void processWithBlockingProcessingStrategy() throws Exception {
        this.flow.dispose();
        this.flow = Flow.builder((String)"flow", (MuleContext)muleContext).processingStrategyFactory((ProcessingStrategyFactory)new BlockingProcessingStrategyFactory()).build();
        this.flow.initialise();
        this.flow.start();
        this.messageProcessor.setFlowConstruct((FlowConstruct)this.flow);
        this.process();
    }

    @Test
    public void processWithDirectProcessingStrategy() throws Exception {
        this.flow.dispose();
        this.flow = Flow.builder((String)"flow", (MuleContext)muleContext).processingStrategyFactory((ProcessingStrategyFactory)new DirectProcessingStrategyFactory()).build();
        this.flow.initialise();
        this.flow.start();
        this.messageProcessor.setFlowConstruct((FlowConstruct)this.flow);
        this.process();
    }

    private void assertTargetEvent(Event request) {
        Assert.assertNotNull((Object)this.target.sensedEvent);
        Assert.assertThat((Object)request, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)this.target.sensedEvent)));
        Assert.assertThat((Object)request.getCorrelationId(), (Matcher)CoreMatchers.equalTo((Object)this.target.sensedEvent.getCorrelationId()));
        Assert.assertThat((Object)request.getMessage(), (Matcher)CoreMatchers.sameInstance((Object)this.target.sensedEvent.getMessage()));
        Assert.assertThat((Object)this.target.thread, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)Thread.currentThread())));
    }

    private void assertResponse(Event result) throws MuleException {
        Assert.assertThat((Object)this.testEvent(), (Matcher)CoreMatchers.sameInstance((Object)result));
        Assert.assertThat((Object)this.exceptionThrown, (Matcher)CoreMatchers.nullValue());
    }

    protected AsyncDelegateMessageProcessor createAsyncDelegatMessageProcessor(Processor listener, FlowConstruct flowConstruct) throws Exception {
        AsyncDelegateMessageProcessor mp = new AsyncDelegateMessageProcessor(MessageProcessors.newChain((Processor[])new Processor[]{listener}), "thread");
        mp.setFlowConstruct(flowConstruct);
        LifecycleUtils.initialiseIfNeeded((Object)mp, (boolean)true, (MuleContext)muleContext);
        return mp;
    }

    private void assertCompletionDone(EventContext parent) {
        Assert.assertThat((Object)Mono.from((Publisher)parent.getCompletionPublisher()).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertCompletionNotDone(EventContext child1) {
        Assert.assertThat((Object)Mono.from((Publisher)child1.getCompletionPublisher()).toFuture().isDone(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Override
    public void exceptionThrown(Exception e) {
        this.exceptionThrown = e;
    }

    class TestListener
    implements Processor {
        Event sensedEvent;
        Thread thread;

        TestListener() {
        }

        public Event process(Event event) throws MuleException {
            try {
                AsyncDelegateMessageProcessorTestCase.this.asyncEntrylatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.sensedEvent = event;
            this.thread = Thread.currentThread();
            AsyncDelegateMessageProcessorTestCase.this.latch.countDown();
            return event;
        }
    }
}

