/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.beans.ExceptionListener;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.concurrent.Latch;
import org.mule.runtime.core.processor.AsyncInterceptingMessageProcessor;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;

public class AsyncInterceptingMessageProcessorTestCase
extends AbstractReactiveProcessorTestCase
implements ExceptionListener {
    protected AsyncInterceptingMessageProcessor messageProcessor;
    protected TestListener target = new TestListener();
    protected Latch latch = new Latch();
    protected Exception exceptionThrown;
    private final Processor failingProcessor = event -> {
        throw new DefaultMuleException("failure");
    };
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public AsyncInterceptingMessageProcessorTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
        this.setStartContext(true);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.messageProcessor = this.createAsyncInterceptingMessageProcessor(this.target);
    }

    @Test
    public void testProcessOneWay() throws Exception {
        Event event = AsyncInterceptingMessageProcessorTestCase.eventBuilder().message(Message.of((Object)"Test Message")).build();
        this.assertAsync((Processor)this.messageProcessor, event);
    }

    @Test
    public void testProcessRequestResponse() throws Exception {
        Event event = AsyncInterceptingMessageProcessorTestCase.eventBuilder().message(Message.of((Object)"Test Message")).build();
        this.assertAsync((Processor)this.messageProcessor, event);
    }

    @Test
    public void testException() throws Exception {
        Flow flow = Flow.builder((String)"flow", (MuleContext)muleContext).build();
        this.initialiseObject(flow);
        Event event = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"Test Message")).build();
        this.messageProcessor.setListener(this.failingProcessor);
        this.messageProcessor.setMuleContext(muleContext);
        this.messageProcessor.setFlowConstruct((FlowConstruct)flow);
        this.expectedException.expect(DefaultMuleException.class);
        this.process((Processor)this.messageProcessor, event);
    }

    protected void assertAsync(Processor processor, Event event) throws Exception {
        Event result = this.process(processor, event);
        this.latch.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)this.target.sensedEvent);
        Assert.assertSame((Object)event, (Object)this.target.sensedEvent);
        Assert.assertEquals((Object)event.getMessageAsString(muleContext), (Object)this.target.sensedEvent.getMessageAsString(muleContext));
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)this.target.thread);
        Assert.assertSame((Object)event, (Object)result);
        Assert.assertNull((Object)this.exceptionThrown);
    }

    protected AsyncInterceptingMessageProcessor createAsyncInterceptingMessageProcessor(Processor listener) throws Exception {
        AsyncInterceptingMessageProcessor mp = new AsyncInterceptingMessageProcessor(() -> this.scheduler);
        mp.setMuleContext(muleContext);
        mp.setFlowConstruct((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext));
        mp.setListener(listener);
        return mp;
    }

    @Override
    public void exceptionThrown(Exception e) {
        this.exceptionThrown = e;
    }

    class TestListener
    implements Processor {
        Event sensedEvent;
        Thread thread;

        TestListener() {
        }

        public Event process(Event event) throws MuleException {
            this.thread = Thread.currentThread();
            this.sensedEvent = event;
            AsyncInterceptingMessageProcessorTestCase.this.latch.countDown();
            return event;
        }
    }
}

