/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.serialization.ObjectSerializer;
import org.mule.runtime.core.api.util.concurrent.Latch;
import org.mule.runtime.core.internal.lock.MuleLockFactory;
import org.mule.runtime.core.internal.lock.SingleServerLockProvider;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.processor.IdempotentRedeliveryPolicy;
import org.mule.tck.SerializationTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class IdempotentRedeliveryPolicyTestCase
extends AbstractMuleTestCase {
    public static final String STRING_MESSAGE = "message";
    public static final int MAX_REDELIVERY_COUNT = 5;
    private static final String UTF_8 = "utf-8";
    private static ObjectSerializer serializer;
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ObjectStoreManager mockObjectStoreManager = (ObjectStoreManager)Mockito.mock(ObjectStoreManager.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private Processor mockFailingMessageProcessor = (Processor)Mockito.mock(Processor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private Processor mockWaitingMessageProcessor = (Processor)Mockito.mock(Processor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private Processor mockDlqMessageProcessor = (Processor)Mockito.mock(Processor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private InternalMessage message = (InternalMessage)Mockito.mock(InternalMessage.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private Event event = (Event)Mockito.mock(Event.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private Latch waitLatch = new Latch();
    private CountDownLatch waitingMessageProcessorExecutionLatch = new CountDownLatch(2);
    private final IdempotentRedeliveryPolicy irp = new IdempotentRedeliveryPolicy();

    @Before
    public void setUpTest() throws MuleException {
        Mockito.when((Object)this.mockFailingMessageProcessor.process((Event)Matchers.any(Event.class))).thenThrow(new Throwable[]{new RuntimeException("failing")});
        Mockito.when((Object)this.mockWaitingMessageProcessor.process(this.event)).thenAnswer(invocationOnMock -> {
            this.waitingMessageProcessorExecutionLatch.countDown();
            this.waitLatch.await(2000L, TimeUnit.MILLISECONDS);
            return this.mockFailingMessageProcessor.process((Event)invocationOnMock.getArguments()[0]);
        });
        MuleLockFactory muleLockFactory = new MuleLockFactory();
        muleLockFactory.setMuleContext(this.mockMuleContext);
        Mockito.when((Object)this.mockMuleContext.getRegistry().get("_muleLockProvider")).thenReturn((Object)new SingleServerLockProvider());
        muleLockFactory.initialise();
        Mockito.when((Object)this.mockMuleContext.getLockFactory()).thenReturn((Object)muleLockFactory);
        Mockito.when((Object)this.mockMuleContext.getObjectStoreManager()).thenReturn((Object)this.mockObjectStoreManager);
        Mockito.when((Object)this.mockMuleContext.getConfiguration().getDefaultEncoding()).thenReturn((Object)UTF_8);
        InMemoryObjectStore inMemoryObjectStore = new InMemoryObjectStore();
        Mockito.when((Object)this.mockObjectStoreManager.getObjectStore(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyInt(), (long)Matchers.anyInt(), (long)Matchers.anyInt())).thenAnswer(invocation -> inMemoryObjectStore);
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        serializer = SerializationTestUtils.getJavaSerializerWithMockContext();
        this.irp.setMaxRedeliveryCount(5);
        this.irp.setUseSecureHash(true);
        this.irp.setFlowConstruct((FlowConstruct)Mockito.mock(FlowConstruct.class));
        this.irp.setMuleContext(this.mockMuleContext);
        this.irp.setListener(this.mockFailingMessageProcessor);
    }

    @Test
    public void messageDigestFailure() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue(new Object(), DataType.OBJECT));
        this.irp.initialise();
        Event process = this.irp.process(this.event);
        Assert.assertThat((Object)process, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testMessageRedeliveryUsingMemory() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue((Object)STRING_MESSAGE, DataType.STRING));
        this.irp.initialise();
        this.processUntilFailure();
        ((Processor)Mockito.verify((Object)this.mockFailingMessageProcessor, (VerificationMode)VerificationModeFactory.times((int)6))).process(this.event);
    }

    @Test
    public void testMessageRedeliveryUsingSerializationStore() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue((Object)STRING_MESSAGE, DataType.STRING));
        Mockito.reset((Object[])new ObjectStoreManager[]{this.mockObjectStoreManager});
        SerializationObjectStore serializationObjectStore = new SerializationObjectStore();
        Mockito.when((Object)this.mockObjectStoreManager.getObjectStore(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyInt(), (long)Matchers.anyInt(), (long)Matchers.anyInt())).thenAnswer(invocation -> serializationObjectStore);
        this.irp.initialise();
        this.processUntilFailure();
        ((Processor)Mockito.verify((Object)this.mockFailingMessageProcessor, (VerificationMode)VerificationModeFactory.times((int)6))).process(this.event);
    }

    @Test
    public void testThreadSafeObjectStoreUsage() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue((Object)STRING_MESSAGE, DataType.STRING));
        this.irp.setListener(this.mockWaitingMessageProcessor);
        this.irp.initialise();
        ExecuteIrpThread firstIrpExecutionThread = new ExecuteIrpThread();
        firstIrpExecutionThread.start();
        ExecuteIrpThread threadCausingRedeliveryException = new ExecuteIrpThread();
        threadCausingRedeliveryException.start();
        this.waitingMessageProcessorExecutionLatch.await(5000L, TimeUnit.MILLISECONDS);
        this.waitLatch.release();
        firstIrpExecutionThread.join();
        threadCausingRedeliveryException.join();
        ((Processor)Mockito.verify((Object)this.mockFailingMessageProcessor, (VerificationMode)VerificationModeFactory.times((int)2))).process(this.event);
    }

    private void processUntilFailure() {
        for (int i = 0; i < 7; ++i) {
            try {
                this.irp.process(this.event);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class InMemoryObjectStore
    implements ObjectStore<AtomicInteger> {
        private Map<Serializable, AtomicInteger> store = new HashMap<Serializable, AtomicInteger>();

        public boolean contains(Serializable key) throws ObjectStoreException {
            return this.store.containsKey(key);
        }

        public void store(Serializable key, AtomicInteger value) throws ObjectStoreException {
            this.store.put(key, value);
        }

        public AtomicInteger retrieve(Serializable key) throws ObjectStoreException {
            return this.store.get(key);
        }

        public AtomicInteger remove(Serializable key) throws ObjectStoreException {
            return this.store.remove(key);
        }

        public void clear() throws ObjectStoreException {
            this.store.clear();
        }

        public boolean isPersistent() {
            return false;
        }
    }

    public static class SerializationObjectStore
    implements ObjectStore<AtomicInteger> {
        private Map<Serializable, Serializable> store = new HashMap<Serializable, Serializable>();

        public boolean contains(Serializable key) throws ObjectStoreException {
            return this.store.containsKey(key);
        }

        public void store(Serializable key, AtomicInteger value) throws ObjectStoreException {
            this.store.put(key, (Serializable)serializer.getExternalProtocol().serialize((Object)value));
        }

        public AtomicInteger retrieve(Serializable key) throws ObjectStoreException {
            Serializable serializable = this.store.get(key);
            return (AtomicInteger)serializer.getExternalProtocol().deserialize((byte[])serializable);
        }

        public AtomicInteger remove(Serializable key) throws ObjectStoreException {
            Serializable serializable = this.store.remove(key);
            return (AtomicInteger)serializer.getExternalProtocol().deserialize((byte[])serializable);
        }

        public boolean isPersistent() {
            return false;
        }

        public void clear() throws ObjectStoreException {
            this.store.clear();
        }
    }

    public class ExecuteIrpThread
    extends Thread {
        public Exception exception;

        @Override
        public void run() {
            try {
                IdempotentRedeliveryPolicyTestCase.this.irp.process(IdempotentRedeliveryPolicyTestCase.this.event);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

