/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.MuleFatalException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class MapProcessorTestCase
extends AbstractMuleContextTestCase {
    @Mock
    private EventContext eventContext;
    @Mock
    private Event event;
    private RuntimeException exception = new RuntimeException(){};
    private Error error = new LinkageError();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private Processor testProcessor = event -> Event.builder((EventContext)this.eventContext).message(Message.of((Object)"test")).build();
    private Processor testProcessorReturnsNull = event -> Event.builder((EventContext)this.eventContext).message(Message.of(null)).build();
    private Processor testProcessorThrowsException = event -> {
        throw this.exception;
    };
    private Processor testProcessorThrowsError = event -> {
        throw this.error;
    };

    @Test
    public void mapBlocking() throws Exception {
        Event result = this.testProcessor.process(this.event);
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"test"));
    }

    @Test
    public void mapStreamBlockingGet() {
        Event result = (Event)Mono.just((Object)this.event).transform((Function)this.testProcessor).block();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"test"));
    }

    @Test
    public void mapStreamSubscribe() throws Exception {
        Event result = (Event)Mono.just((Object)this.event).transform((Function)this.testProcessor).block();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"test"));
    }

    @Test
    public void mapBlockingNullResult() throws Exception {
        Event result = this.testProcessorReturnsNull.process(this.event);
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void mapStreamBlockingGetNullResult() {
        Event result = (Event)Mono.just((Object)this.event).transform((Function)this.testProcessorReturnsNull).block();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void mapStreamSubscribeNullResult() throws Exception {
        Event result = (Event)Mono.just((Object)this.event).transform((Function)this.testProcessorReturnsNull).block();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void mapBlockingExceptionThrown() throws Exception {
        this.thrown.expect(CoreMatchers.is((Object)this.exception));
        this.testProcessorThrowsException.process(this.event);
    }

    @Test
    public void mapStreamBlockingGetExceptionThrown() throws Throwable {
        Event result;
        this.thrown.expect(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
        this.thrown.expectCause(CoreMatchers.is((Object)this.exception));
        try {
            result = (Event)Mono.just((Object)this.event).transform((Function)this.testProcessorThrowsException).block();
        }
        catch (Exception e) {
            throw Exceptions.unwrap((Throwable)e);
        }
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void mapStreamSubscribeExceptionThrown() throws Exception {
        Mono.just((Object)this.event).transform((Function)this.testProcessorThrowsException).onErrorResume(throwable -> {
            Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
            Assert.assertThat((Object)throwable.getCause(), (Matcher)CoreMatchers.is((Object)this.exception));
            return Mono.empty();
        }).subscribe();
    }

    @Test
    public void mapBlockingErrorThrown() throws Exception {
        this.thrown.expect(CoreMatchers.is((Object)this.error));
        this.testProcessorThrowsError.process(this.event);
    }

    @Test
    public void mapStreamBlockingGetErrorThrown() throws Throwable {
        Event result = null;
        try {
            result = (Event)Mono.just((Object)this.event).transform((Function)this.testProcessorThrowsError).block();
        }
        catch (Exception e) {
            Throwable problem = Exceptions.unwrap((Throwable)e);
            Assert.assertThat((Object)problem, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
            Assert.assertThat((Object)problem.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MuleFatalException.class)));
            Assert.assertThat((Object)problem.getCause().getCause(), (Matcher)CoreMatchers.is((Object)this.error));
        }
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void mapStreamSubscribeErrorThrown() throws Exception {
        Mono.just((Object)this.event).transform((Function)this.testProcessorThrowsError).onErrorResume(throwable -> {
            Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessagingException.class)));
            Assert.assertThat((Object)throwable.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MuleFatalException.class)));
            Assert.assertThat((Object)throwable.getCause().getCause(), (Matcher)CoreMatchers.is((Object)this.error));
            return Mono.empty();
        }).subscribe().block();
    }
}

