/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.chain;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.util.ObjectUtils;
import org.mule.runtime.core.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.exception.ErrorTypeLocator;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.mule.runtime.core.processor.ResponseMessageProcessorAdapter;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.ProactorStreamProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.ReactorProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.TransactionAwareWorkQueueProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.WorkQueueProcessingStrategyFactory;
import org.mule.runtime.core.routing.ChoiceRouter;
import org.mule.runtime.core.routing.ScatterGatherRouter;
import org.mule.runtime.core.routing.filters.AcceptAllFilter;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import org.mule.tck.size.SmallTest;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@RunWith(value=Parameterized.class)
@SmallTest
public class DefaultMessageProcessorChainTestCase
extends AbstractReactiveProcessorTestCase {
    protected MuleContext muleContext;
    private AtomicInteger nonBlockingProcessorsExecuted = new AtomicInteger(0);
    private ProcessingStrategyFactory processingStrategyFactory;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Flow flow;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({new TransactionAwareWorkQueueProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.BLOCKING}, {new ReactorProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.BLOCKING}, {new ProactorStreamProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.BLOCKING}, {new WorkQueueProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.BLOCKING}, {new BlockingProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.BLOCKING}, {new DirectProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.BLOCKING}, {new TransactionAwareWorkQueueProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.NON_BLOCKING}, {new ReactorProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.NON_BLOCKING}, {new ProactorStreamProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.NON_BLOCKING}, {new WorkQueueProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.NON_BLOCKING}, {new BlockingProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.NON_BLOCKING}, {new DirectProcessingStrategyFactory(), AbstractReactiveProcessorTestCase.Mode.NON_BLOCKING});
    }

    public DefaultMessageProcessorChainTestCase(ProcessingStrategyFactory processingStrategyFactory, AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
        this.processingStrategyFactory = processingStrategyFactory;
    }

    @Before
    public void before() throws MuleException {
        this.nonBlockingProcessorsExecuted.set(0);
        this.muleContext = (MuleContext)Mockito.spy((Object)AbstractReactiveProcessorTestCase.muleContext);
        ErrorTypeLocator errorTypeLocator = (ErrorTypeLocator)Mockito.mock(ErrorTypeLocator.class);
        ErrorType errorType = (ErrorType)Mockito.mock(ErrorType.class);
        ExceptionContextProvider exceptionContextProvider = (ExceptionContextProvider)Mockito.mock(ExceptionContextProvider.class);
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.isContainerMode()).thenReturn((Object)false);
        Mockito.when((Object)muleConfiguration.getId()).thenReturn((Object)RandomStringUtils.randomNumeric((int)3));
        Mockito.when((Object)muleConfiguration.getShutdownTimeout()).thenReturn((Object)1000L);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        Mockito.when((Object)this.muleContext.getErrorTypeLocator()).thenReturn((Object)errorTypeLocator);
        Mockito.when((Object)this.muleContext.getExceptionContextProviders()).thenReturn(Collections.singletonList(exceptionContextProvider));
        Mockito.when((Object)errorTypeLocator.lookupErrorType((Throwable)((Exception)Matchers.any()))).thenReturn((Object)errorType);
        this.flow = Flow.builder((String)"flow", (MuleContext)this.muleContext).processingStrategyFactory(this.processingStrategyFactory).build();
        this.flow.initialise();
        this.flow.start();
    }

    @After
    public void after() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.muleContext.getSchedulerService());
        this.flow.stop();
        this.flow.dispose();
    }

    @Test
    public void testMPChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3")});
        Assert.assertEquals((Object)"0123", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMPChainWithNullReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingMP mp1 = this.getAppendingMP("1");
        AppendingMP mp2 = this.getAppendingMP("2");
        ReturnNullMP nullmp = new ReturnNullMP();
        AppendingMP mp3 = this.getAppendingMP("3");
        builder.chain(new Processor[]{mp1, mp2, nullmp, mp3});
        Event requestEvent = this.getTestEventUsingFlow("0");
        Assert.assertNull((Object)this.process((Processor)builder.build(), requestEvent));
        Assert.assertSame((Object)requestEvent.getMessage(), (Object)mp1.event.getMessage());
        Assert.assertNotSame((Object)mp1.event, (Object)mp1.resultEvent);
        Assert.assertEquals((Object)"01", (Object)mp1.resultEvent.getMessage().getPayload().getValue());
        Assert.assertSame((Object)mp1.resultEvent.getMessage(), (Object)mp2.event.getMessage());
        Assert.assertNotSame((Object)mp2.event, (Object)mp2.resultEvent);
        Assert.assertEquals((Object)"012", (Object)mp2.resultEvent.getMessage().getPayload().getValue());
        Assert.assertSame((Object)mp2.resultEvent.getMessage(), (Object)nullmp.event.getMessage());
        Assert.assertEquals((Object)"012", (Object)nullmp.event.getMessage().getPayload().getValue());
        Assert.assertNull((Object)mp3.event);
    }

    @Test
    public void testMPChainWithVoidReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingMP mp1 = this.getAppendingMP("1");
        AppendingMP mp2 = this.getAppendingMP("2");
        ReturnVoidMP voidmp = new ReturnVoidMP();
        AppendingMP mp3 = this.getAppendingMP("3");
        builder.chain(new Processor[]{mp1, mp2, voidmp, mp3});
        Event requestEvent = this.getTestEventUsingFlow("0");
        Assert.assertEquals((Object)"0123", (Object)this.process((Processor)builder.build(), requestEvent).getMessage().getPayload().getValue());
        Assert.assertNotSame((Object)mp1.event, (Object)mp1.resultEvent);
        Assert.assertNotSame((Object)mp2.event, (Object)mp2.resultEvent);
        Assert.assertEquals((Object)mp2.resultEvent.getMessage(), (Object)voidmp.event.getMessage());
        Assert.assertThat((Object)mp3.event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)mp2.resultEvent.getMessage().getPayload().getValue()));
        Assert.assertEquals((Object)mp3.event.getMessage().getPayload().getValue(), (Object)"012");
    }

    @Test
    public void testMPChainWithNullReturnAtEnd() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new ReturnNullMP()});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMPChainWithVoidReturnAtEnd() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new ReturnVoidMP()});
        Assert.assertEquals((Object)"0123", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMPChainWithBuilder() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1")});
        builder.chain(new MessageProcessorBuilder[]{() -> this.getAppendingMP("2")});
        builder.chain(new Processor[]{this.getAppendingMP("3")});
        Assert.assertEquals((Object)"0123", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testInterceptingMPChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2"), new AppendingInterceptingMP("3")});
        Assert.assertEquals((Object)"0before1before2before3after3after2after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testInterceptingMPChainWithNullReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP lastMP = new AppendingInterceptingMP("3");
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2"), new ReturnNullInterceptongMP(), lastMP});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertFalse((boolean)lastMP.invoked);
    }

    @Test
    public void testInterceptingMPChainWithVoidReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP lastMP = new AppendingInterceptingMP("3");
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2"), new ReturnNullInterceptongMP(), lastMP});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
        Assert.assertFalse((boolean)lastMP.invoked);
    }

    @Test
    public void testMixedMPChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMixedMPChainWithNullReturn1() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new ReturnNullInterceptongMP(), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithVoidReturn1() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new ReturnVoidMPInterceptongMP(), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertThat((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"0before1after1"));
    }

    @Test
    public void testMixedMPChainWithNullReturn2() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), new ReturnNullInterceptongMP(), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithVoidlReturn2() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), new ReturnVoidMPInterceptongMP(), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before12after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMixedMPChainWithNullReturn3() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new ReturnNullMP(), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithVoidReturn3() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new ReturnVoidMP(), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMixedMPChainWithNullReturn4() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), new ReturnNullMP(), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithVoidReturn4() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), new ReturnVoidMP(), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMixedMPChainWithNullReturn5() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new ReturnNullMP(), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithVoidReturn5() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new ReturnVoidMP(), new AppendingInterceptingMP("4"), this.getAppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMixedMPChainWithNullReturnAtEnd() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5"), new ReturnNullMP()});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithVoidReturnAtEnd() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), this.getAppendingMP("2"), this.getAppendingMP("3"), new AppendingInterceptingMP("4"), this.getAppendingMP("5"), new ReturnVoidMP()});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedMPChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), this.getAppendingMP("b")}).build(), this.getAppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedMPChainWithNullReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), new ReturnNullMP(), this.getAppendingMP("b")}).build(), new ReturnNullMP(), this.getAppendingMP("2")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testNestedMPChainWithVoidReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), new ReturnVoidMP(), this.getAppendingMP("b")}).build(), new ReturnVoidMP(), this.getAppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedMPChainWithNullReturnAtEndOfNestedChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), this.getAppendingMP("b"), new ReturnNullMP()}).build(), this.getAppendingMP("2")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testNestedMPChainWithVoidReturnAtEndOfNestedChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), this.getAppendingMP("b"), new ReturnVoidMP()}).build(), this.getAppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedMPChainWithNullReturnAtEndOfNestedChainWithNonInterceptingWrapper() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        MessageProcessorChain nested = new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), this.getAppendingMP("b"), new ReturnNullMP()}).build();
        nested.setMuleContext(this.muleContext);
        builder.chain(new Processor[]{this.getAppendingMP("1"), event -> nested.process(event), this.getAppendingMP("2")});
        Assert.assertNull((String)"012", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testNestedMPChainWithVoidReturnAtEndOfNestedChainWithNonInterceptingWrapper() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        MessageProcessorChain nested = new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.getAppendingMP("a"), this.getAppendingMP("b"), new ReturnVoidMP()}).build();
        nested.setMuleContext(this.muleContext);
        builder.chain(new Processor[]{this.getAppendingMP("1"), event -> nested.process(Event.builder((Event)event).message(event.getMessage()).flow((FlowConstruct)this.flow).build()), this.getAppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedInterceptingMPChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{new AppendingInterceptingMP("a"), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertEquals((Object)"0before1beforeabeforebafterbafterabefore2after2after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedInterceptingMPChainWithNullReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{new AppendingInterceptingMP("a"), new ReturnNullInterceptongMP(), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertNull((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")));
    }

    @Test
    public void testNestedInterceptingMPChainWithVoidReturn() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{new AppendingInterceptingMP("a"), new ReturnVoidMPInterceptongMP(), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertThat((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"0before1beforeaafterabefore2after2after1"));
    }

    @Test
    public void testNestedMixedMPChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{new AppendingInterceptingMP("a"), this.getAppendingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertEquals((Object)"01beforeabafterabefore2after2", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testInterceptingMPChainStopFlow() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2", true), new AppendingInterceptingMP("3")});
        Assert.assertEquals((Object)"0before1after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testNestedInterceptingMPChainStopFlow() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new Processor[]{new AppendingInterceptingMP("a", true), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("3")});
        Assert.assertEquals((Object)"0before1before3after3after1", (Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue());
    }

    @Test
    public void testMPChainLifecycle() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP mp1 = new AppendingInterceptingMP("1");
        AppendingInterceptingMP mp2 = new AppendingInterceptingMP("2");
        MessageProcessorChain chain = builder.chain(new Processor[]{mp1, mp2}).build();
        ((MuleContextAware)chain).setMuleContext(this.muleContext);
        ((FlowConstructAware)chain).setFlowConstruct((FlowConstruct)Mockito.mock(FlowConstruct.class));
        ((Lifecycle)chain).initialise();
        ((Lifecycle)chain).start();
        ((Lifecycle)chain).stop();
        ((Lifecycle)chain).dispose();
        this.assertLifecycle(mp1);
        this.assertLifecycle(mp2);
    }

    @Test
    public void testNestedMPChainLifecycle() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        DefaultMessageProcessorChainBuilder nestedBuilder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP mp1 = new AppendingInterceptingMP("1");
        AppendingInterceptingMP mp2 = new AppendingInterceptingMP("2");
        AppendingInterceptingMP mpa = new AppendingInterceptingMP("a");
        AppendingInterceptingMP mpb = new AppendingInterceptingMP("b");
        MessageProcessorChain chain = builder.chain(new Processor[]{mp1, nestedBuilder.chain(new Processor[]{mpa, mpb}).build(), mp2}).build();
        ((MuleContextAware)chain).setMuleContext(this.muleContext);
        ((FlowConstructAware)chain).setFlowConstruct((FlowConstruct)Mockito.mock(FlowConstruct.class));
        ((Lifecycle)chain).initialise();
        ((Lifecycle)chain).start();
        ((Lifecycle)chain).stop();
        ((Lifecycle)chain).dispose();
        this.assertLifecycle(mp1);
        this.assertLifecycle(mp2);
        this.assertLifecycle(mpa);
        this.assertLifecycle(mpb);
    }

    @Test
    public void testNoneIntercepting() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        Event restul = this.process((Processor)builder.build(), this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"MessageProcessorMessageProcessorMessageProcessor", (Object)restul.getMessage().getPayload().getValue());
    }

    @Test
    public void testAllIntercepting() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new TestIntercepting(), new TestIntercepting(), new TestIntercepting()});
        Event restul = this.process((Processor)builder.build(), this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"InterceptingMessageProcessorInterceptingMessageProcessorInterceptingMessageProcessor", (Object)restul.getMessage().getPayload().getValue());
    }

    @Test
    public void testMix() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        Event restul = this.process((Processor)builder.build(), this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"InterceptingMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessor", (Object)restul.getMessage().getPayload().getValue());
    }

    @Test
    public void testMixStaticFactoryt() throws Exception {
        MessageProcessorChain chain = MessageProcessors.newChain((Processor[])new Processor[]{new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        Event restul = this.process((Processor)chain, this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"InterceptingMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessor", (Object)restul.getMessage().getPayload().getValue());
    }

    @Test
    public void testMix2() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting()});
        Event restul = this.process((Processor)builder.build(), this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"MessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessor", (Object)restul.getMessage().getPayload().getValue());
    }

    @Test
    public void testMix2StaticFactory() throws Exception {
        MessageProcessorChain chain = MessageProcessors.newChain((Processor[])new Processor[]{new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting()});
        Event result = this.process((Processor)chain, this.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"MessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessor", (Object)result.getMessage().getPayload().getValue());
    }

    @Test
    public void testResponseProcessor() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        ResponseMessageProcessorAdapter responseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)this.getAppendingMP("3"));
        responseMessageProcessorAdapter.setMuleContext(this.muleContext);
        builder.chain(new Processor[]{this.getAppendingMP("1"), responseMessageProcessorAdapter, this.getAppendingMP("2")});
        Assert.assertThat((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"0123"));
    }

    @Test
    public void testResponseProcessorInNestedChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        ResponseMessageProcessorAdapter responseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)this.getAppendingMP("c"));
        responseMessageProcessorAdapter.setMuleContext(this.muleContext);
        builder.chain(new Processor[]{this.getAppendingMP("1"), MessageProcessors.newChain((Processor[])new Processor[]{this.getAppendingMP("a"), responseMessageProcessorAdapter, this.getAppendingMP("b")}), this.getAppendingMP("2")});
        Assert.assertThat((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"01abc2"));
    }

    @Test
    public void testNestedResponseProcessor() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        ResponseMessageProcessorAdapter innerResponseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)this.getAppendingMP("4"));
        ResponseMessageProcessorAdapter responseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)MessageProcessors.newChain((Processor[])new Processor[]{innerResponseMessageProcessorAdapter, this.getAppendingMP("3")}));
        builder.chain(new Processor[]{this.getAppendingMP("1"), responseMessageProcessorAdapter, this.getAppendingMP("2")});
        this.process((Processor)builder.build(), this.getTestEventUsingFlow("0"));
        Assert.assertThat((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"01234"));
    }

    @Test
    public void testNestedResponseProcessorEndOfChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        MessageProcessorChain chain = MessageProcessors.newChain(Collections.singletonList(this.getAppendingMP("1")));
        ResponseMessageProcessorAdapter responseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)chain);
        responseMessageProcessorAdapter.setMuleContext(this.muleContext);
        builder.chain(new Processor[]{responseMessageProcessorAdapter});
        this.process((Processor)builder.build(), this.getTestEventUsingFlow("0"));
        Assert.assertThat((Object)this.process((Processor)builder.build(), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"01"));
    }

    @Test
    public void testAll() throws Exception {
        ScatterGatherRouter scatterGatherRouter = new ScatterGatherRouter();
        scatterGatherRouter.addRoute((Processor)this.getAppendingMP("1"));
        scatterGatherRouter.addRoute((Processor)this.getAppendingMP("2"));
        scatterGatherRouter.addRoute((Processor)this.getAppendingMP("3"));
        scatterGatherRouter.setFlowConstruct((FlowConstruct)this.flow);
        LifecycleUtils.initialiseIfNeeded((Object)scatterGatherRouter, (boolean)true, (MuleContext)this.muleContext);
        scatterGatherRouter.start();
        Event event = this.getTestEventUsingFlow("0");
        MessageProcessorChain chain = MessageProcessors.newChain(Collections.singletonList(scatterGatherRouter));
        Message result = this.process((Processor)chain, Event.builder((Event)event).message(event.getMessage()).build()).getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(List.class));
        List resultMessage = (List)result.getPayload().getValue();
        Assert.assertThat((Object)resultMessage.stream().map(msg -> msg.getPayload().getValue()).collect(Collectors.toList()).toArray(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)new String[]{"01", "02", "03"})));
        scatterGatherRouter.stop();
        scatterGatherRouter.dispose();
    }

    @Test
    public void testChoice() throws Exception {
        ChoiceRouter choiceRouter = new ChoiceRouter();
        choiceRouter.addRoute((Processor)MessageProcessors.newChain((Processor[])new Processor[]{this.getAppendingMP("1")}), (Filter)new AcceptAllFilter());
        choiceRouter.addRoute((Processor)MessageProcessors.newChain((Processor[])new Processor[]{this.getAppendingMP("2")}), (Filter)new AcceptAllFilter());
        choiceRouter.addRoute((Processor)MessageProcessors.newChain((Processor[])new Processor[]{this.getAppendingMP("3")}), (Filter)new AcceptAllFilter());
        Assert.assertThat((Object)this.process((Processor)MessageProcessors.newChain((Processor[])new Processor[]{choiceRouter}), this.getTestEventUsingFlow("0")).getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"01"));
    }

    @Test
    public void testExceptionAfter() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new ExceptionThrowingMessageProcessor()});
        this.expectedException.expect(IllegalStateException.class);
        this.process((Processor)builder.build(), this.getTestEventUsingFlow("0"));
    }

    @Test
    public void testExceptionBefore() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new ExceptionThrowingMessageProcessor(), this.getAppendingMP("1")});
        this.expectedException.expect(IllegalStateException.class);
        this.process((Processor)builder.build(), this.getTestEventUsingFlow("0"));
    }

    @Test
    public void testExceptionBetween() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{this.getAppendingMP("1"), new ExceptionThrowingMessageProcessor(), this.getAppendingMP("2")});
        this.expectedException.expect(IllegalStateException.class);
        this.process((Processor)builder.build(), this.getTestEventUsingFlow("0"));
    }

    @Test
    public void testExceptionInResponse() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new Processor[]{new ResponseMessageProcessorAdapter((Processor)new ExceptionThrowingMessageProcessor()), this.getAppendingMP("1")});
        this.expectedException.expect(IllegalStateException.class);
        this.process((Processor)builder.build(), this.getTestEventUsingFlow("0"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Event process(Processor messageProcessor, Event event) throws Exception {
        if (messageProcessor instanceof MuleContextAware) {
            ((MuleContextAware)messageProcessor).setMuleContext(this.muleContext);
        }
        if (messageProcessor instanceof FlowConstructAware) {
            ((FlowConstructAware)messageProcessor).setFlowConstruct((FlowConstruct)this.flow);
        }
        try {
            Event event2 = super.process(messageProcessor, event);
            return event2;
        }
        finally {
            SchedulerService schedulerService = this.muleContext.getSchedulerService();
        }
    }

    private AppendingMP getAppendingMP(String append) {
        return new NonBlockingAppendingMP(append);
    }

    private void assertLifecycle(AppendingInterceptingMP mp) {
        Assert.assertTrue((boolean)mp.flowConstuctInjected);
        Assert.assertTrue((boolean)mp.muleContextInjected);
        Assert.assertTrue((boolean)mp.initialised);
        Assert.assertTrue((boolean)mp.started);
        Assert.assertTrue((boolean)mp.stopped);
        Assert.assertTrue((boolean)mp.disposed);
    }

    protected Event getTestEventUsingFlow(Object data) {
        Event event = (Event)Mockito.mock(Event.class);
        EventContext eventContext = DefaultEventContext.create((FlowConstruct)this.flow, (ComponentLocation)TEST_CONNECTOR_LOCATION);
        Message message = Message.of((Object)data);
        Mockito.when((Object)event.getFlowCallStack()).thenReturn((Object)new DefaultFlowCallStack());
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        Mockito.when((Object)event.getSession()).thenReturn(Mockito.mock(MuleSession.class));
        Mockito.when((Object)event.getError()).thenReturn(Optional.empty());
        Mockito.when((Object)event.getContext()).thenReturn((Object)eventContext);
        return event;
    }

    public static class ExceptionThrowingMessageProcessor
    implements Processor {
        public Event process(Event event) throws MuleException {
            throw new IllegalStateException();
        }
    }

    static class ReturnVoidMPInterceptongMP
    extends AbstractInterceptingMessageProcessor {
        ReturnVoidMPInterceptongMP() {
        }

        public Event process(Event event) throws MuleException {
            return event;
        }
    }

    private static class ReturnVoidMP
    implements Processor {
        Event event;

        private ReturnVoidMP() {
        }

        public Event process(Event event) throws MuleException {
            this.event = event;
            return event;
        }
    }

    static class ReturnNullInterceptongMP
    extends AbstractInterceptingMessageProcessor {
        ReturnNullInterceptongMP() {
        }

        public Event process(Event event) throws MuleException {
            return null;
        }
    }

    static class ReturnNullMP
    implements Processor {
        Event event;

        ReturnNullMP() {
        }

        public Event process(Event event) throws MuleException {
            this.event = event;
            return null;
        }
    }

    class AppendingInterceptingMP
    extends AbstractInterceptingMessageProcessor
    implements FlowConstructAware,
    Lifecycle {
        String appendString;
        boolean muleContextInjected;
        boolean flowConstuctInjected;
        boolean initialised;
        boolean started;
        boolean stopped;
        boolean disposed;
        private boolean stopProcessing;
        boolean invoked;

        public AppendingInterceptingMP(String appendString) {
            this(appendString, false);
        }

        public AppendingInterceptingMP(String appendString, boolean stopProcessing) {
            this.appendString = appendString;
            this.stopProcessing = stopProcessing;
        }

        public Event process(Event event) throws MuleException {
            if (this.stopProcessing) {
                return event;
            }
            Event result = this.processNext(this.appendBefore(event));
            if (result != null) {
                return this.appendAfter(result);
            }
            return result;
        }

        public Publisher<Event> apply(Publisher<Event> publisher) {
            if (this.stopProcessing) {
                return publisher;
            }
            return Flux.from(publisher).map(before -> this.appendBefore((Event)before)).transform((Function)this.applyNext()).map(after -> {
                if (after != null) {
                    return this.appendAfter((Event)after);
                }
                return after;
            });
        }

        private Event appendAfter(Event after) {
            return Event.builder((Event)after).message(Message.of((Object)(after.getMessage().getPayload().getValue() + "after" + this.appendString))).build();
        }

        private Event appendBefore(Event before) {
            return Event.builder((Event)before).message(Message.of((Object)(before.getMessage().getPayload().getValue() + "before" + this.appendString))).build();
        }

        public void initialise() throws InitialisationException {
            this.initialised = true;
        }

        public void start() throws MuleException {
            this.started = true;
        }

        public void stop() throws MuleException {
            this.stopped = true;
        }

        public void dispose() {
            this.disposed = true;
        }

        public String toString() {
            return ObjectUtils.toString((Object)((Object)this));
        }

        public void setMuleContext(MuleContext context) {
            this.muleContextInjected = true;
            super.setMuleContext(context);
        }

        public void setFlowConstruct(FlowConstruct flowConstruct) {
            this.flowConstuctInjected = true;
            super.setFlowConstruct(flowConstruct);
        }
    }

    class AppendingMP
    implements Processor,
    Lifecycle,
    FlowConstructAware,
    MuleContextAware {
        String appendString;
        boolean muleContextInjected;
        boolean flowConstuctInjected;
        boolean initialised;
        boolean started;
        boolean stopped;
        boolean disposed;
        Event event;
        Event resultEvent;

        public AppendingMP(String append) {
            this.appendString = append;
        }

        public Event process(Event event) throws MuleException {
            return this.innerProcess(event);
        }

        private Event innerProcess(Event event) {
            Event result;
            this.event = event;
            this.resultEvent = result = Event.builder((Event)event).message(Message.of((Object)(event.getMessage().getPayload().getValue() + this.appendString))).build();
            return result;
        }

        public void initialise() throws InitialisationException {
            this.initialised = true;
        }

        public void start() throws MuleException {
            this.started = true;
        }

        public void stop() throws MuleException {
            this.stopped = true;
        }

        public void dispose() {
            this.disposed = true;
        }

        public String toString() {
            return ObjectUtils.toString((Object)this);
        }

        public void setMuleContext(MuleContext context) {
            this.muleContextInjected = true;
        }

        public void setFlowConstruct(FlowConstruct flowConstruct) {
            this.flowConstuctInjected = true;
        }
    }

    class NonBlockingAppendingMP
    extends AppendingMP {
        public ReactiveProcessor.ProcessingType getProcessingType() {
            return ReactiveProcessor.ProcessingType.CPU_INTENSIVE;
        }

        public NonBlockingAppendingMP(String append) {
            super(append);
        }

        @Override
        public Event process(Event event) throws MuleException {
            DefaultMessageProcessorChainTestCase.this.nonBlockingProcessorsExecuted.incrementAndGet();
            return super.process(event);
        }
    }

    static class TestIntercepting
    extends AbstractInterceptingMessageProcessor {
        TestIntercepting() {
        }

        public Event process(Event event) throws MuleException {
            return this.processNext(Event.builder((Event)event).message(Message.of((Object)(event.getMessage().getPayload().getValue() + "InterceptingMessageProcessor"))).build());
        }
    }

    static class TestNonIntercepting
    implements Processor {
        TestNonIntercepting() {
        }

        public Event process(Event event) throws MuleException {
            return Event.builder((Event)event).message(Message.of((Object)(event.getMessage().getPayload().getValue() + "MessageProcessor"))).build();
        }
    }
}

