/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.interceptor;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.interception.ProcessorInterceptorProvider;
import org.mule.runtime.core.processor.interceptor.DefaultProcessorInterceptorManager;
import org.mule.runtime.core.processor.interceptor.a.ProcessorInterceptorFactoryA;
import org.mule.runtime.core.processor.interceptor.b.ProcessorInterceptorFactoryB;
import org.mule.runtime.core.processor.interceptor.c.ProcessorInterceptorFactoryC;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.reflections.ReflectionUtils;

public class DefaultProcessorInterceptorManagerTestCase
extends AbstractMuleTestCase {
    private ProcessorInterceptorProvider manager;

    @Before
    public void before() throws IllegalArgumentException, IllegalAccessException {
        this.manager = new DefaultProcessorInterceptorManager();
        this.injectMockMuleContext(this.manager);
    }

    private void injectMockMuleContext(Object injectionTarget) throws IllegalAccessException {
        Field contextField = (Field)ReflectionUtils.getFields(DefaultProcessorInterceptorManager.class, (Predicate[])new Predicate[]{ReflectionUtils.withType(MuleContext.class)}).iterator().next();
        contextField.setAccessible(true);
        contextField.set(injectionTarget, Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
    }

    @Test
    public void noInterceptors() {
        Assert.assertThat((Object)this.manager.getInterceptorFactories(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void interceptorsOrderedAsRegisterd() {
        ProcessorInterceptorFactoryA intFactoryA = new ProcessorInterceptorFactoryA();
        ProcessorInterceptorFactoryB intFactoryB = new ProcessorInterceptorFactoryB();
        ProcessorInterceptorFactoryC intFactoryC = new ProcessorInterceptorFactoryC();
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryA);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryB);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryC);
        Assert.assertThat((Object)this.manager.getInterceptorFactories(), (Matcher)Matchers.contains((Object[])new ProcessorInterceptorFactory[]{intFactoryA, intFactoryB, intFactoryC}));
    }

    @Test
    public void interceptorsOrdered() {
        ProcessorInterceptorFactoryA intFactoryA = new ProcessorInterceptorFactoryA();
        ProcessorInterceptorFactoryB intFactoryB = new ProcessorInterceptorFactoryB();
        ProcessorInterceptorFactoryC intFactoryC = new ProcessorInterceptorFactoryC();
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryA);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryB);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryC);
        this.manager.setInterceptorsOrder(new String[]{"org.mule.runtime.core.processor.interceptor.c", "org.mule.runtime.core.processor.interceptor.b"});
        Assert.assertThat((Object)this.manager.getInterceptorFactories(), (Matcher)Matchers.contains((Object[])new ProcessorInterceptorFactory[]{intFactoryC, intFactoryB, intFactoryA}));
    }

    @Test
    public void interceptorsOrderedManyPerOrderItem() {
        ProcessorInterceptorFactoryA intFactoryA1 = new ProcessorInterceptorFactoryA();
        ProcessorInterceptorFactoryA intFactoryA2 = new ProcessorInterceptorFactoryA();
        ProcessorInterceptorFactoryA intFactoryA3 = new ProcessorInterceptorFactoryA();
        ProcessorInterceptorFactoryA intFactoryA4 = new ProcessorInterceptorFactoryA();
        ProcessorInterceptorFactoryA intFactoryA5 = new ProcessorInterceptorFactoryA();
        ProcessorInterceptorFactoryB intFactoryB1 = new ProcessorInterceptorFactoryB();
        ProcessorInterceptorFactoryB intFactoryB2 = new ProcessorInterceptorFactoryB();
        ProcessorInterceptorFactoryB intFactoryB3 = new ProcessorInterceptorFactoryB();
        ProcessorInterceptorFactoryB intFactoryB4 = new ProcessorInterceptorFactoryB();
        ProcessorInterceptorFactoryB intFactoryB5 = new ProcessorInterceptorFactoryB();
        ProcessorInterceptorFactoryC intFactoryC1 = new ProcessorInterceptorFactoryC();
        ProcessorInterceptorFactoryC intFactoryC2 = new ProcessorInterceptorFactoryC();
        ProcessorInterceptorFactoryC intFactoryC3 = new ProcessorInterceptorFactoryC();
        ProcessorInterceptorFactoryC intFactoryC4 = new ProcessorInterceptorFactoryC();
        ProcessorInterceptorFactoryC intFactoryC5 = new ProcessorInterceptorFactoryC();
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryA1);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryA2);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryA3);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryA4);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryA5);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryB1);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryB2);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryB3);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryB4);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryB5);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryC1);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryC2);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryC3);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryC4);
        this.manager.addInterceptorFactory((ProcessorInterceptorFactory)intFactoryC5);
        this.manager.setInterceptorsOrder(new String[]{"org.mule.runtime.core.processor.interceptor.c", "org.mule.runtime.core.processor.interceptor.b"});
        Assert.assertThat((Object)this.manager.getInterceptorFactories(), (Matcher)Matchers.contains((Object[])new ProcessorInterceptorFactory[]{intFactoryC1, intFactoryC2, intFactoryC3, intFactoryC4, intFactoryC5, intFactoryB1, intFactoryB2, intFactoryB3, intFactoryB4, intFactoryB5, intFactoryA1, intFactoryA2, intFactoryA3, intFactoryA4, intFactoryA5}));
    }
}

