/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.interceptor;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.processor.ParametersResolverProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.component.ComponentAnnotations;
import org.mule.runtime.core.exception.Errors;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.processor.interceptor.InterceptionException;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.EventMatcher;
import org.mule.tck.junit4.matcher.MessagingExceptionMatcher;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=Parameterized.class)
public class ReactiveInterceptorAdapterTestCase
extends AbstractMuleContextTestCase {
    private final boolean useMockInterceptor;
    private final Processor processor;
    private Flow flow;
    @Rule
    public ExpectedException expected = ExpectedException.none();

    public ReactiveInterceptorAdapterTestCase(boolean useMockInterceptor, Processor processor) {
        this.useMockInterceptor = useMockInterceptor;
        this.processor = (Processor)Mockito.spy((Object)processor);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({true, new ProcessorInApp()}, {true, new OperationProcessorInApp()}, {false, new ProcessorInApp()}, {false, new OperationProcessorInApp()});
    }

    @Before
    public void before() throws MuleException {
        this.flow = Flow.builder((String)"flow", (MuleContext)muleContext).messageProcessors(Collections.singletonList(this.processor)).build();
    }

    @After
    public void after() throws MuleException {
        this.flow.stop();
        this.flow.dispose();
    }

    private ProcessorInterceptor prepareInterceptor(ProcessorInterceptor interceptor) {
        if (this.useMockInterceptor) {
            return (ProcessorInterceptor)Mockito.spy((Object)interceptor);
        }
        return interceptor;
    }

    @Test
    public void interceptorApplied() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.eq((Object)((AnnotatedObject)this.processor).getLocation()), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.eq((Object)((AnnotatedObject)this.processor).getLocation()), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.eq((Object)((AnnotatedObject)this.processor).getLocation()), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void interceptorMutatesEventBefore() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public void before(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event) {
                event.message(Message.of((Object)"test"));
            }
        });
        this.startFlowWithInterceptors(interceptor);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)2));
        }
    }

    @Test
    public void interceptorMutatesEventAfter() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
                event.message(Message.of((Object)"test"));
            }
        });
        this.startFlowWithInterceptors(interceptor);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void interceptorMutatesEventAroundBeforeProceed() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                event.message(Message.of((Object)"test"));
                return action.proceed();
            }
        });
        this.startFlowWithInterceptors(interceptor);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void interceptorMutatesEventAroundAfterProceed() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                return CompletableFuture.supplyAsync(() -> {
                    event.message(Message.of((Object)"test"));
                    return event;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void interceptorMutatesEventAroundBeforeSkip() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                event.message(Message.of((Object)"test"));
                return action.skip();
            }
        });
        this.startFlowWithInterceptors(interceptor);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void interceptorMutatesEventAroundAfterSkip() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                action.skip();
                return CompletableFuture.supplyAsync(() -> {
                    event.message(Message.of((Object)"test"));
                    return event;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorMutatesEventAroundAfterFailWithErrorType() throws Exception {
        final ErrorType errorTypeMock = (ErrorType)Mockito.mock(ErrorType.class);
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                event.message(Message.of((Object)"test"));
                return action.fail(errorTypeMock);
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expect(MessagingException.class);
        this.expected.expect((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)EventMatcher.hasErrorTypeThat((Matcher)IsSame.sameInstance((Object)errorTypeMock))));
        this.expected.expectCause(org.hamcrest.Matchers.instanceOf(InterceptionException.class));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.argThat((Matcher)org.hamcrest.Matchers.not(Optional.empty())));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.argThat((Matcher)org.hamcrest.Matchers.not(Optional.empty())));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorMutatesEventAroundAfterFailWithCause() throws Exception {
        final RuntimeException cause = new RuntimeException("");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                event.message(Message.of((Object)"test"));
                return action.fail(cause);
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expectCause(IsSame.sameInstance((Object)cause));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.of(cause)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.of(cause)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionBefore() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public void before(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event) {
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionAfter() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionAround() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionAroundAfterProceed() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionAroundAfterProceedInCallback() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                return CompletableFuture.supplyAsync(() -> {
                    throw expectedException;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expect(MessagingException.class);
        this.expected.expect((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.UNKNOWN.getNamespace(), (String)Errors.ComponentIdentifiers.UNKNOWN.getName())));
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptorThrowsExceptionAroundAfterSkipInCallback() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                action.skip();
                return CompletableFuture.supplyAsync(() -> {
                    throw expectedException;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor);
        this.expected.expect(MessagingException.class);
        this.expected.expect((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.UNKNOWN.getNamespace(), (String)Errors.ComponentIdentifiers.UNKNOWN.getName())));
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void interceptedThrowsException() throws Exception {
        RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor);
        Mockito.when((Object)this.processor.process((Event)Matchers.any())).thenThrow(new Throwable[]{expectedException});
        this.expected.expect(MessagingException.class);
        this.expected.expect((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.UNKNOWN.getNamespace(), (String)Errors.ComponentIdentifiers.UNKNOWN.getName())));
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    @Test
    public void interceptorSkipsProcessor() throws Exception {
        ProcessorInterceptor interceptor = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                return action.skip();
            }
        });
        this.startFlowWithInterceptors(interceptor);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void firstInterceptorMutatesEventBefore() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){

            public void before(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event) {
                event.message(Message.of((Object)"test"));
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)2));
        }
    }

    @Test
    public void secondInterceptorMutatesEventBefore() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){

            public void before(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event) {
                event.message(Message.of((Object)"test"));
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)2));
        }
    }

    @Test
    public void firstInterceptorMutatesEventAfter() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
                event.message(Message.of((Object)"test"));
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void secondInterceptorMutatesEventAfter() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
                event.message(Message.of((Object)"test"));
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void firstInterceptorMutatesEventAroundBeforeProceed() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                event.message(Message.of((Object)"test"));
                return action.proceed();
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", "test"), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)2));
        }
    }

    @Test
    public void secondInterceptorMutatesEventAroundBeforeProceed() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                event.message(Message.of((Object)"test"));
                return action.proceed();
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("test")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void firstInterceptorMutatesEventAroundAfterProceed() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                return CompletableFuture.supplyAsync(() -> {
                    event.message(Message.of((Object)"test"));
                    return event;
                });
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void secondInterceptorMutatesEventAroundAfterProceed() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                return CompletableFuture.supplyAsync(() -> {
                    event.message(Message.of((Object)"test"));
                    return event;
                });
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), ReactiveInterceptorAdapterTestCase.mapArgWithEntry("param", ""), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.hasPayloadValue("")));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("test")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void firstInterceptorThrowsExceptionBefore() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){

            public void before(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event) {
                throw expectedException;
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void secondInterceptorThrowsExceptionBefore() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){

            public void before(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event) {
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void firstInterceptorThrowsExceptionAfter() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
                throw expectedException;
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void secondInterceptorThrowsExceptionAfter() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){

            public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void firstInterceptorThrowsExceptionAround() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                throw expectedException;
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void secondInterceptorThrowsExceptionAround() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void firstInterceptorThrowsExceptionAroundAfterProceed() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                throw expectedException;
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void secondInterceptorThrowsExceptionAroundAfterProceed() throws Exception {
        final RuntimeException expectedException = new RuntimeException("Some Error");
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                action.proceed();
                throw expectedException;
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        this.expected.expectCause(IsSame.sameInstance((Object)expectedException));
        try {
            this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
            if (!this.useMockInterceptor) return;
        }
        catch (Throwable throwable) {
            if (!this.useMockInterceptor) throw throwable;
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
            throw throwable;
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
        ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.of(expectedException)));
        this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
    }

    @Test
    public void firstInterceptorSkipsProcessor() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                return action.skip();
            }
        });
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)""));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.argThat((Matcher)ReactiveInterceptorAdapterTestCase.interceptionHasPayloadValue("")), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void secondInterceptorSkipsProcessor() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){

            public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, Object> parameters, InterceptionEvent event, InterceptionAction action) {
                return action.skip();
            }
        });
        this.startFlowWithInterceptors(interceptor1, interceptor2);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)""));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor, Mockito.never())).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void firstInterceptorDoesntApply() throws Exception {
        final ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){});
        ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptorFactories(new ProcessorInterceptorFactory(){

            public boolean intercept(ComponentLocation location) {
                return false;
            }

            public ProcessorInterceptor get() {
                return interceptor1;
            }
        }, () -> interceptor2);
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1, Mockito.never())).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    @Test
    public void secondInterceptorDoesntApply() throws Exception {
        ProcessorInterceptor interceptor1 = this.prepareInterceptor(new ProcessorInterceptor(){});
        final ProcessorInterceptor interceptor2 = this.prepareInterceptor(new ProcessorInterceptor(){});
        this.startFlowWithInterceptorFactories(() -> interceptor1, new ProcessorInterceptorFactory(){

            public boolean intercept(ComponentLocation location) {
                return false;
            }

            public ProcessorInterceptor get() {
                return interceptor2;
            }
        });
        Event result = this.process((Processor)this.flow, ReactiveInterceptorAdapterTestCase.eventBuilder().message(Message.of((Object)"")).build());
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
        if (this.useMockInterceptor) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.processor, interceptor1, interceptor2});
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).before((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).around((ComponentLocation)Matchers.any(), (Map)Matchers.any(), (InterceptionEvent)Matchers.any(), (InterceptionAction)Matchers.any());
            ((Processor)inOrder.verify((Object)this.processor)).process((Event)Matchers.any());
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor2, Mockito.never())).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            ((ProcessorInterceptor)inOrder.verify((Object)interceptor1)).after((ComponentLocation)Matchers.any(), (InterceptionEvent)Matchers.any(), (Optional)Matchers.eq(Optional.empty()));
            Assert.assertThat(result.getParameters().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)0));
            this.verifyParametersResolvedAndDisposed(Mockito.times((int)1));
        }
    }

    private void verifyParametersResolvedAndDisposed(VerificationMode times) {
        if (this.processor instanceof OperationProcessorInApp) {
            ((OperationProcessorInApp)((Object)Mockito.verify((Object)((Object)((OperationProcessorInApp)this.processor)), (VerificationMode)times))).resolveParameters((Event)Matchers.any());
            ((OperationProcessorInApp)((Object)Mockito.verify((Object)((Object)((OperationProcessorInApp)this.processor)), (VerificationMode)times))).disposeResolvedParameters((ExecutionContext<OperationModel>)((ExecutionContext)Matchers.any()));
        }
    }

    private void startFlowWithInterceptors(ProcessorInterceptor ... interceptors) throws Exception {
        for (ProcessorInterceptor interceptionHandler : interceptors) {
            muleContext.getProcessorInterceptorManager().addInterceptorFactory(() -> interceptionHandler);
        }
        this.flow.initialise();
        this.flow.start();
    }

    private void startFlowWithInterceptorFactories(ProcessorInterceptorFactory ... interceptorFactories) throws Exception {
        for (ProcessorInterceptorFactory interceptionHandlerFactory : interceptorFactories) {
            muleContext.getProcessorInterceptorManager().addInterceptorFactory(interceptionHandlerFactory);
        }
        this.flow.initialise();
        this.flow.start();
    }

    private static DefaultComponentLocation buildLocation(String componentIdentifier) {
        TypedComponentIdentifier part = TypedComponentIdentifier.builder().withIdentifier(ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier)).withType(TypedComponentIdentifier.ComponentType.PROCESSOR).build();
        return new DefaultComponentLocation(Optional.of("flowName"), Collections.singletonList(new DefaultComponentLocation.DefaultLocationPart("0", Optional.of(part), Optional.empty(), Optional.empty())));
    }

    private static Map<String, Object> mapArgWithEntry(String key, Object value) {
        return (Map)Matchers.argThat((Matcher)IsMapContaining.hasEntry((Object)key, (Object)value));
    }

    private static EventPayloadMatcher hasPayloadValue(Object expectedPayload) {
        return new EventPayloadMatcher((Matcher<Object>)Is.is((Object)expectedPayload));
    }

    private static InterceptionPayloadMatcher interceptionHasPayloadValue(Object expectedPayload) {
        return new InterceptionPayloadMatcher((Matcher<Object>)Is.is((Object)expectedPayload));
    }

    private static final class InterceptionPayloadMatcher
    extends TypeSafeMatcher<InterceptionEvent> {
        private Matcher<Object> payloadMatcher;

        public InterceptionPayloadMatcher(Matcher<Object> payloadMatcher) {
            this.payloadMatcher = payloadMatcher;
        }

        public void describeTo(Description description) {
            this.payloadMatcher.describeTo(description);
        }

        protected boolean matchesSafely(InterceptionEvent item) {
            return this.payloadMatcher.matches(item.getMessage().getPayload().getValue());
        }
    }

    private static final class EventPayloadMatcher
    extends TypeSafeMatcher<Event> {
        private Matcher<Object> payloadMatcher;

        public EventPayloadMatcher(Matcher<Object> payloadMatcher) {
            this.payloadMatcher = payloadMatcher;
        }

        public void describeTo(Description description) {
            this.payloadMatcher.describeTo(description);
        }

        protected boolean matchesSafely(Event item) {
            return this.payloadMatcher.matches(item.getMessage().getPayload().getValue());
        }
    }

    private static class OperationProcessorInApp
    extends AbstractAnnotatedObject
    implements ParametersResolverProcessor,
    Processor {
        private final ExecutionContext executionContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);

        public OperationProcessorInApp() {
            this.setAnnotations((Map)ImmutableMap.builder().put((Object)ComponentAnnotations.ANNOTATION_PARAMETERS, Collections.singletonMap("param", "#[payload]")).put((Object)LOCATION_KEY, (Object)ReactiveInterceptorAdapterTestCase.buildLocation("test:operationProcessor")).build());
        }

        public Event process(Event event) throws MuleException {
            return event;
        }

        public ParametersResolverProcessor.ParametersResolverProcessorResult resolveParameters(Event event) {
            return new ParametersResolverProcessor.ParametersResolverProcessorResult(Collections.singletonMap("operationParam", "operationParamValue"), this.executionContext);
        }

        public void disposeResolvedParameters(ExecutionContext<OperationModel> executionContext) {
            Assert.assertThat(executionContext, (Matcher)IsSame.sameInstance((Object)this.executionContext));
        }
    }

    private static class ProcessorInApp
    extends AbstractAnnotatedObject
    implements Processor {
        public ProcessorInApp() {
            this.setAnnotations((Map)ImmutableMap.builder().put((Object)ComponentAnnotations.ANNOTATION_PARAMETERS, Collections.singletonMap("param", "#[payload]")).put((Object)LOCATION_KEY, (Object)ReactiveInterceptorAdapterTestCase.buildLocation("test:processor")).build());
        }

        public Event process(Event event) throws MuleException {
            return event;
        }
    }
}

