/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.strategy;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Test;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.processor.strategy.ReactorStreamProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.WorkQueueProcessingStrategyTestCase;
import org.mule.runtime.core.processor.strategy.WorkQueueStreamProcessingStrategyFactory;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@Features(value={"Processing Strategies"})
@Stories(value={"Work Queue"})
public class WorkQueueStreamProcessingStrategyTestCase
extends WorkQueueProcessingStrategyTestCase {
    public WorkQueueStreamProcessingStrategyTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
    }

    @Override
    protected ProcessingStrategy createProcessingStrategy(MuleContext muleContext, String schedulersNamePrefix) {
        return new WorkQueueStreamProcessingStrategyFactory.WorkQueueStreamProcessingStrategy(() -> this.blocking, ReactorStreamProcessingStrategyFactory.DEFAULT_BUFFER_SIZE, 1, ReactorStreamProcessingStrategyFactory.DEFAULT_WAIT_STRATEGY, () -> this.blocking, 4);
    }

    @Override
    @Test
    @Description(value="If IO pool has maximum size of 1 only 1 thread is used for CPU_LIGHT processor and further requests block.")
    public void singleCpuLightConcurrentMaxConcurrency1() throws Exception {
        this.flow.setProcessingStrategyFactory((context, prefix) -> new WorkQueueStreamProcessingStrategyFactory.WorkQueueStreamProcessingStrategy(() -> this.blocking, ReactorStreamProcessingStrategyFactory.DEFAULT_BUFFER_SIZE, 1, ReactorStreamProcessingStrategyFactory.DEFAULT_WAIT_STRATEGY, () -> this.blocking, 1));
        this.internalConcurrent(true, ReactiveProcessor.ProcessingType.CPU_LITE, 1, new Processor[0]);
        MatcherAssert.assertThat((Object)this.threads, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.threads.stream().filter(name -> name.startsWith("I/O")).count(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"cpuLight"))));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"cpuIntensive"))));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"custom"))));
    }

    @Override
    @Test
    @Description(value="If IO pool has maximum size of 1 only 1 thread is used for BLOCKING processor and further requests block.")
    public void singleBlockingConcurrentMaxConcurrency1() throws Exception {
        this.flow.setProcessingStrategyFactory((context, prefix) -> new WorkQueueStreamProcessingStrategyFactory.WorkQueueStreamProcessingStrategy(() -> this.blocking, ReactorStreamProcessingStrategyFactory.DEFAULT_BUFFER_SIZE, 1, ReactorStreamProcessingStrategyFactory.DEFAULT_WAIT_STRATEGY, () -> this.blocking, 1));
        this.internalConcurrent(true, ReactiveProcessor.ProcessingType.BLOCKING, 1, new Processor[0]);
        MatcherAssert.assertThat((Object)this.threads, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.threads.stream().filter(name -> name.startsWith("I/O")).count(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"cpuLight"))));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"cpuIntensive"))));
        MatcherAssert.assertThat((Object)this.threads, (Matcher)CoreMatchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"custom"))));
    }
}

