/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.registry;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.Registry;
import org.mule.runtime.core.api.registry.RegistryBroker;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.registry.DefaultRegistryBroker;
import org.mule.runtime.core.registry.TransientRegistry;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Kiwi;

public class RegistryBrokerTestCase
extends AbstractMuleContextTestCase {
    private String tracker;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.tracker = new String();
    }

    protected boolean isStartContext() {
        return false;
    }

    @Test
    public void testCrossRegistryLifecycleOrder() throws MuleException {
        TransientRegistry reg1 = new TransientRegistry(muleContext);
        reg1.initialise();
        TransientRegistry reg2 = new TransientRegistry(muleContext);
        reg2.initialise();
        reg1.registerObject("flow", (Object)new LifecycleTrackerFlow("flow", muleContext));
        reg2.registerObject("flow2", (Object)new LifecycleTrackerFlow("flow2", muleContext));
        muleContext.addRegistry((Registry)reg1);
        muleContext.addRegistry((Registry)reg2);
        muleContext.start();
        Assert.assertEquals((Object)"flow2-start flow-start ", (Object)this.tracker.toString());
        this.tracker = new String();
        muleContext.stop();
        Assert.assertEquals((Object)"flow2-stop flow-stop ", (Object)this.tracker);
    }

    @Test
    public void testConcurrentRegistryAddRemove() throws Exception {
        DefaultRegistryBroker broker = new DefaultRegistryBroker(muleContext);
        int N = 50;
        final CountDownLatch start = new CountDownLatch(1);
        CountDownLatch end = new CountDownLatch(50);
        AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 50; ++i) {
            new Thread(new Runnable((RegistryBroker)broker, errors, end){
                final /* synthetic */ RegistryBroker val$broker;
                final /* synthetic */ AtomicInteger val$errors;
                final /* synthetic */ CountDownLatch val$end;
                {
                    this.val$broker = registryBroker;
                    this.val$errors = atomicInteger;
                    this.val$end = countDownLatch2;
                }

                @Override
                public void run() {
                    try {
                        start.await();
                        this.val$broker.addRegistry((Registry)new TransientRegistry(muleContext));
                        this.val$broker.lookupByType(Object.class);
                    }
                    catch (Exception e) {
                        this.val$errors.incrementAndGet();
                    }
                    finally {
                        this.val$end.countDown();
                    }
                }
            }, "thread-eval-" + i).start();
        }
        start.countDown();
        end.await();
        if (errors.get() > 0) {
            Assert.fail();
        }
    }

    @Test
    public void registerWhenNoRegistriesManuallyAddedYet() throws Exception {
        String KEY1 = "apple";
        Apple VALUE1 = new Apple();
        String KEY2 = "Kiwi";
        Kiwi VALUE2 = new Kiwi();
        muleContext.getRegistry().registerObject("apple", (Object)VALUE1);
        muleContext.getRegistry().registerObject("Kiwi", (Object)VALUE2);
        Assert.assertThat((Object)muleContext.getRegistry().get("apple"), (Matcher)CoreMatchers.is((Object)VALUE1));
        Assert.assertThat((Object)muleContext.getRegistry().get("Kiwi"), (Matcher)CoreMatchers.is((Object)VALUE2));
        Assert.assertThat((Object)muleContext.getRegistry().lookupObject(Apple.class), (Matcher)CoreMatchers.is((Object)VALUE1));
        Assert.assertThat((Object)muleContext.getRegistry().lookupObject(Kiwi.class), (Matcher)CoreMatchers.is((Object)VALUE2));
    }

    class LifecycleTrackerFlow
    extends DefaultFlowBuilder.DefaultFlow {
        public LifecycleTrackerFlow(String name, MuleContext muleContext) {
            super(name, muleContext);
        }

        protected void doStart() throws MuleException {
            super.doStart();
            RegistryBrokerTestCase.this.tracker = RegistryBrokerTestCase.this.tracker + this.name + "-start ";
        }

        protected void doStop() throws MuleException {
            super.doStop();
            RegistryBrokerTestCase.this.tracker = RegistryBrokerTestCase.this.tracker + this.name + "-stop ";
        }
    }
}

